/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.incoming;

import com.sun.org.apache.xml.internal.security.exceptions.Base64DecodingException;
import com.sun.xml.stream.buffer.MutableXMLStreamBuffer;
import com.sun.xml.stream.buffer.stax.StreamReaderBufferCreator;
import com.sun.xml.ws.encoding.TagInfoset;
import com.sun.xml.ws.security.opt.api.NamespaceContextInfo;
import com.sun.xml.ws.security.opt.api.PolicyBuilder;
import com.sun.xml.ws.security.opt.api.SecurityElementWriter;
import com.sun.xml.ws.security.opt.api.SecurityHeaderElement;
import com.sun.xml.ws.security.opt.crypto.dsig.SignatureValue;
import com.sun.xml.ws.security.opt.crypto.dsig.SignedInfo;
import com.sun.xml.ws.security.opt.crypto.jaxb.JAXBValidateContext;
import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.ws.security.opt.impl.dsig.ExcC14NParameterSpec;
import com.sun.xml.ws.security.opt.impl.incoming.SecurityContext;
import com.sun.xml.ws.security.opt.impl.incoming.URIResolver;
import com.sun.xml.ws.security.opt.impl.incoming.processor.KeyInfoProcessor;
import com.sun.xml.ws.security.opt.impl.incoming.processor.SignedInfoProcessor;
import com.sun.xml.ws.security.opt.impl.incoming.processor.StreamingPayLoadDigester;
import com.sun.xml.ws.security.opt.impl.util.SOAPUtil;
import com.sun.xml.ws.security.opt.impl.util.StreamUtil;
import com.sun.xml.ws.security.opt.impl.util.XMLStreamReaderFactory;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.c14n.StAXEXC14nCanonicalizerImpl;
import com.sun.xml.wss.impl.misc.Base64;
import com.sun.xml.wss.impl.misc.DefaultSecurityEnvironmentImpl;
import com.sun.xml.wss.impl.policy.mls.SignaturePolicy;
import com.sun.xml.wss.impl.policy.mls.WSSPolicy;
import com.sun.xml.wss.logging.impl.opt.signature.LogStringsMessages;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jcp.xml.dsig.internal.DigesterOutputStream;
import org.jvnet.staxex.Base64Data;
import org.jvnet.staxex.XMLStreamReaderEx;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Signature
implements SecurityHeaderElement,
NamespaceContextInfo,
SecurityElementWriter,
PolicyBuilder {
    private static final Logger logger = Logger.getLogger("com.sun.xml.wss.logging.impl.opt.signature", "com.sun.xml.wss.logging.impl.opt.signature.LogStrings");
    public static final int SIGNEDINFO_EVENT = 1;
    public static final int SIGNATUREVALUE_EVENT = 2;
    public static final int KEYINFO_EVENT = 3;
    public static final int OBJECT_EVENT = 4;
    public static final String SIGNED_INFO = "SignedInfo";
    public static final String SIGNATURE_VALUE = "SignatureValue";
    public static final String KEYINFO = "KeyInfo";
    public static final String OBJECT = "Object";
    private SignaturePolicy signPolicy = null;
    private HashMap<String, String> currentParentNS = new HashMap();
    private JAXBFilterProcessingContext context;
    private StreamReaderBufferCreator creator = null;
    private SecurityContext securityContext = null;
    private String id = "";
    private SignedInfoProcessor sip = null;
    private XMLStreamWriter canonWriter = null;
    private com.sun.xml.ws.security.opt.crypto.dsig.Signature sig = null;
    private JAXBValidateContext jvc = new JAXBValidateContext();
    private SignedInfo si = null;
    private boolean validationStatus = false;
    private MutableXMLStreamBuffer buffer = null;
    private boolean cacheSignature = false;
    private boolean storeSigConfirmValue = true;

    public Signature(JAXBFilterProcessingContext jpc, Map<String, String> namespaceList, StreamReaderBufferCreator sbc) {
        this.currentParentNS.putAll(namespaceList);
        this.creator = sbc;
        this.securityContext = jpc.getSecurityContext();
        this.context = jpc;
        this.cacheSignature = true;
        this.signPolicy = new SignaturePolicy();
        this.signPolicy.setFeatureBinding(new SignaturePolicy.FeatureBinding());
    }

    public Signature(JAXBFilterProcessingContext jpc, Map<String, String> namespaceList, StreamReaderBufferCreator sbc, boolean cacheSig) {
        this.currentParentNS.putAll(namespaceList);
        this.creator = sbc;
        this.securityContext = jpc.getSecurityContext();
        this.context = jpc;
        this.cacheSignature = cacheSig;
        this.signPolicy = new SignaturePolicy();
        this.signPolicy.setFeatureBinding(new SignaturePolicy.FeatureBinding());
    }

    /*
     * Unable to fully structure code
     */
    public void process(XMLStreamReader signature) throws XWSSecurityException {
        try {
            block38: {
                reader = null;
                this.buffer = new MutableXMLStreamBuffer();
                this.buffer.createFromXMLStreamReader(signature);
                reader = this.buffer.readAsXMLStreamReader();
                reader.next();
                signatureValue = null;
                signatureRoot = new TagInfoset(reader);
                for (i = 0; i < reader.getNamespaceCount(); ++i) {
                    prefix = reader.getNamespacePrefix(i);
                    uri = reader.getNamespaceURI(i);
                    if (prefix == null) {
                        prefix = "";
                    }
                    this.currentParentNS.put(prefix, uri);
                }
                this.context.setCurrentBuffer(this.buffer);
                key = null;
                this.id = reader.getAttributeValue(null, "Id");
                if (this.id == null || this.id.length() == 0) {
                    this.id = "pvid" + this.context.generateID();
                    if (Signature.logger.isLoggable(Level.FINEST)) {
                        Signature.logger.log(Level.FINEST, LogStringsMessages.WSS_1755_MISSINGID_INCOMING_SIGNATURE(this.id));
                    }
                }
                this.signPolicy.setUUID(this.id);
                if (!StreamUtil.moveToNextElement(reader)) break block38;
                refElement = this.getEventType(reader);
                while (true) {
                    if (reader.getEventType() == 8) break;
                    switch (refElement) {
                        case 1: {
                            this.sip = new SignedInfoProcessor(signatureRoot, this.currentParentNS, reader, this.context, this.signPolicy, this.buffer);
                            this.si = this.sip.process();
                            this.canonWriter = this.sip.getCanonicalizer();
                            break;
                        }
                        case 2: {
                            if (this.canonWriter == null) {
                                Signature.logger.log(Level.SEVERE, LogStringsMessages.WSS_1707_ERROR_PROCESSING_SIGNEDINFO(this.id));
                                throw new XWSSecurityException("Elements under Signature are not as per defined schema or error must have occurred while processing SignedInfo for Signature with ID" + this.id);
                            }
                            StreamUtil.writeCurrentEvent((XMLStreamReader)reader, this.canonWriter);
                            if (reader instanceof XMLStreamReaderEx) {
                                reader.next();
                                sb = null;
                                while (true) {
                                    if (reader.getEventType() != 4) break;
                                    if (reader.getEventType() == 2) break;
                                    charSeq = ((XMLStreamReaderEx)reader).getPCDATA();
                                    if (charSeq instanceof Base64Data) {
                                        bd = (Base64Data)((XMLStreamReaderEx)reader).getPCDATA();
                                        signatureValue = bd.getExact();
                                        this.canonWriter.writeCharacters(Base64.encode(signatureValue));
                                    } else {
                                        if (sb == null) {
                                            sb = new StringBuffer();
                                        }
                                        for (i = 0; i < charSeq.length(); ++i) {
                                            sb.append(charSeq.charAt(i));
                                        }
                                    }
                                    reader.next();
                                }
                                if (sb != null) {
                                    tmp = sb.toString();
                                    this.canonWriter.writeCharacters(tmp);
                                    try {
                                        signatureValue = Base64.decode(tmp);
                                    }
                                    catch (Base64DecodingException dec) {
                                        Signature.logger.log(Level.SEVERE, LogStringsMessages.WSS_1708_BASE_64_DECODING_ERROR(this.id));
                                        throw new XWSSecurityException("Error occurred while decoding signatureValue for Signature with ID" + this.id);
                                    }
                                } else {
                                    reader.next();
                                }
                            } else {
                                tmp = StreamUtil.getCV((XMLStreamReader)reader);
                                this.canonWriter.writeCharacters(tmp);
                                try {
                                    signatureValue = Base64.decode(tmp);
                                }
                                catch (Base64DecodingException dec) {
                                    Signature.logger.log(Level.SEVERE, LogStringsMessages.WSS_1708_BASE_64_DECODING_ERROR(this.id));
                                    throw new XWSSecurityException("Error occurred while decoding signatureValue for Signature with ID" + this.id);
                                }
                            }
                            scList = (ArrayList)this.context.getExtraneousProperty("receivedSignValues");
                            if (scList == null || !this.storeSigConfirmValue) break;
                            scList.add(signatureValue);
                            break;
                        }
                        case 3: {
                            if (this.canonWriter == null) {
                                Signature.logger.log(Level.SEVERE, LogStringsMessages.WSS_1707_ERROR_PROCESSING_SIGNEDINFO(this.id));
                                throw new XWSSecurityException("Elements under Signature are not as per defined schema or error must have occurred while processing SignedInfo for Signature with ID" + this.id);
                            }
                            this.securityContext.setInferredKB(null);
                            kip = new KeyInfoProcessor(this.context, KeySelector.Purpose.VERIFY);
                            key = kip.getKey(reader);
                            if (!(key instanceof PublicKey)) ** GOTO lbl108
                            cert = null;
                            try {
                                cert = this.context.getSecurityEnvironment().getCertificate(this.context.getExtraneousProperties(), (PublicKey)key, false);
                            }
                            catch (XWSSecurityException ex) {
                                if (!Signature.logger.isLoggable(Level.FINE)) ** GOTO lbl106
                                Signature.logger.log(Level.FINE, "", ex);
                            }
lbl106:
                            // 3 sources

                            if (cert != null && !this.context.isSamlSignatureKey()) {
                                this.context.getSecurityEnvironment().updateOtherPartySubject(DefaultSecurityEnvironmentImpl.getSubject(this.context), cert);
                            }
lbl108:
                            // 4 sources

                            inferredKB = this.securityContext.getInferredKB();
                            this.signPolicy.setKeyBinding(inferredKB);
                            this.securityContext.setInferredKB(null);
                            break;
                        }
                        default: {
                            Signature.logger.log(Level.SEVERE, LogStringsMessages.WSS_1709_UNRECOGNIZED_SIGNATURE_ELEMENT(reader.getName()));
                            throw new XWSSecurityException("Element name " + reader.getName() + " is not recognized under Signature");
                        }
                    }
                    if (StreamUtil._break(reader, "Signature", "http://www.w3.org/2000/09/xmldsig#")) {
                        reader.next();
                        break;
                    }
                    if (!StreamUtil.isStartElement(reader) && StreamUtil.moveToNextStartOREndElement(reader) && StreamUtil._break(reader, "Signature", "http://www.w3.org/2000/09/xmldsig#")) {
                        reader.next();
                        break;
                    }
                    if (reader.getEventType() != 1) {
                        StreamUtil.moveToNextStartOREndElement(reader);
                        isBreak = false;
                        while (reader.getEventType() == 2) {
                            if (StreamUtil._break(reader, "Signature", "http://www.w3.org/2001/04/xmlenc#")) {
                                isBreak = true;
                                break;
                            }
                            StreamUtil.moveToNextStartOREndElement(reader);
                        }
                        if (isBreak || reader.getEventType() == 8) break;
                    }
                    refElement = this.getEventType(reader);
                }
            }
            this.sig = new com.sun.xml.ws.security.opt.crypto.dsig.Signature();
            sv = new SignatureValue();
            sv.setValue(signatureValue);
            this.sig.setSignatureValue(sv);
            this.jvc.setURIDereferencer(new URIResolver(this.context));
            this.sig.setSignedInfo(this.si);
            this.sig.setVerificationKey(key);
            if (this.sip.getReferenceList().size() == 0) {
                if (!this.sig.validate(this.jvc)) {
                    this.validationStatus = true;
                    Signature.logger.log(Level.SEVERE, LogStringsMessages.WSS_1710_SIGNATURE_VERFICATION_FAILED(this.id));
                    throw SOAPUtil.newSOAPFaultException(MessageConstants.WSSE_FAILED_CHECK, LogStringsMessages.WSS_1710_SIGNATURE_VERFICATION_FAILED(this.id), null);
                }
                this.validationStatus = true;
            }
        }
        catch (XMLStreamException ex) {
            Signature.logger.log(Level.SEVERE, LogStringsMessages.WSS_1711_ERROR_VERIFYING_SIGNATURE());
            throw new XWSSecurityException(ex);
        }
        catch (XMLSignatureException xse) {
            Signature.logger.log(Level.SEVERE, LogStringsMessages.WSS_1711_ERROR_VERIFYING_SIGNATURE());
            throw new XWSSecurityException(xse);
        }
    }

    public void process(XMLStreamReader signature, boolean storeSigConfirmValue) throws XWSSecurityException {
        this.storeSigConfirmValue = storeSigConfirmValue;
        this.process(signature);
        this.storeSigConfirmValue = true;
    }

    public boolean validate() throws XWSSecurityException {
        if (this.isReady()) {
            try {
                boolean status = this.sig.validate(this.jvc);
                this.validationStatus = true;
                return status;
            }
            catch (XMLSignatureException ex) {
                this.validationStatus = true;
                logger.log(Level.SEVERE, LogStringsMessages.WSS_1713_SIGNATURE_VERIFICATION_EXCEPTION(ex.getMessage()), ex);
                throw new XWSSecurityException(ex);
            }
        }
        return false;
    }

    public com.sun.xml.ws.security.opt.crypto.dsig.Reference removeReferenceWithID(String id) {
        ArrayList<com.sun.xml.ws.security.opt.crypto.dsig.Reference> refList = this.sip.getReferenceList();
        com.sun.xml.ws.security.opt.crypto.dsig.Reference ref = null;
        for (int i = 0; i < refList.size(); ++i) {
            if (!refList.get(i).getURI().equals(id)) continue;
            ref = this.sip.getReferenceList().remove(i);
            break;
        }
        return ref;
    }

    public ArrayList<com.sun.xml.ws.security.opt.crypto.dsig.Reference> getReferences() {
        return this.sip.getReferenceList();
    }

    public boolean isValidated() {
        return this.validationStatus;
    }

    public boolean isReady() throws XWSSecurityException {
        if (this.sip.getReferenceList().size() == 0) {
            return true;
        }
        ArrayList refList = (ArrayList)this.sip.getReferenceList().clone();
        for (int i = 0; i < refList.size(); ++i) {
            com.sun.xml.ws.security.opt.crypto.dsig.Reference ref = (com.sun.xml.ws.security.opt.crypto.dsig.Reference)refList.get(i);
            if (!this.sip.processReference(ref)) continue;
            this.sip.getReferenceList().remove(ref);
        }
        return this.sip.getReferenceList().size() == 0;
    }

    public boolean verifyReferences() {
        throw new UnsupportedOperationException();
    }

    public boolean verifySignatureValue() {
        throw new UnsupportedOperationException();
    }

    private int getEventType(XMLStreamReader reader) {
        if (reader.getEventType() == 1) {
            if (reader.getLocalName() == SIGNED_INFO) {
                return 1;
            }
            if (reader.getLocalName() == SIGNATURE_VALUE) {
                return 2;
            }
            if (reader.getLocalName() == KEYINFO) {
                return 3;
            }
            if (reader.getLocalName() == OBJECT) {
                return 4;
            }
        }
        return -1;
    }

    private boolean _break(XMLStreamReader reader) throws XMLStreamException {
        if (reader.getEventType() == 2 && reader.getLocalName() == "Signature" && reader.getNamespaceURI() == "http://www.w3.org/2000/09/xmldsig#") {
            reader.next();
            return true;
        }
        return false;
    }

    @Override
    public boolean refersToSecHdrWithId(String id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNamespaceURI() {
        return "http://www.w3.org/2000/09/xmldsig#";
    }

    @Override
    public String getLocalPart() {
        return "Signature";
    }

    @Override
    public XMLStreamReader readHeader() throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeTo(OutputStream os) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeTo(XMLStreamWriter streamWriter) throws XMLStreamException {
        if (this.buffer == null) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1712_UNBUFFERED_SIGNATURE_ERROR());
            throw new XMLStreamException("Signature is not buffered , message not as per configured policy");
        }
        this.buffer.writeToXMLStreamWriter(streamWriter);
    }

    public XMLStreamReader wrapWithDigester(Reference ref, XMLStreamReader message, TagInfoset bodyTag, HashMap<String, String> parentNS, boolean payLoad) throws XWSSecurityException {
        List trList;
        MessageDigest md = null;
        try {
            String algo = StreamUtil.convertDigestAlgorithm(ref.getDigestMethod().getAlgorithm());
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Digest Algorithm is " + ref.getDigestMethod().getAlgorithm());
                logger.log(Level.FINE, "Mapped Digest Algorithm is " + algo);
            }
            md = MessageDigest.getInstance(algo);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new XWSSecurityException(nsae);
        }
        DigesterOutputStream dos = new DigesterOutputStream(md);
        StAXEXC14nCanonicalizerImpl canonicalizer = new StAXEXC14nCanonicalizerImpl();
        canonicalizer.setStream(dos);
        if (logger.isLoggable(Level.FINEST)) {
            canonicalizer.setStream(new ByteArrayOutputStream());
        }
        if ((trList = ref.getTransforms()).size() > 1) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1714_UNSUPPORTED_TRANSFORM_ERROR());
            throw new XWSSecurityException("Only EXC14n Transform is supported");
        }
        Transform tr = (Transform)trList.get(0);
        ExcC14NParameterSpec spec = (ExcC14NParameterSpec)tr.getParameterSpec();
        if (spec != null) {
            canonicalizer.setInclusivePrefixList(spec.getPrefixList());
        }
        if (parentNS != null && parentNS.size() > 0) {
            for (Map.Entry<String, String> entry : parentNS.entrySet()) {
                String prefix = entry.getKey();
                try {
                    String uri = entry.getValue();
                    canonicalizer.writeNamespace(prefix, uri);
                }
                catch (XMLStreamException ex) {
                    logger.log(Level.SEVERE, LogStringsMessages.WSS_1715_ERROR_CANONICALIZING_BODY(), ex);
                }
            }
        }
        try {
            if (!payLoad) {
                bodyTag.writeStart(canonicalizer);
            }
        }
        catch (XMLStreamException ex) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1715_ERROR_CANONICALIZING_BODY(), ex);
            throw new XWSSecurityException("Error occurred while canonicalizing BodyTag" + ex);
        }
        StreamingPayLoadDigester digester = new StreamingPayLoadDigester(ref, message, canonicalizer, payLoad);
        return XMLStreamReaderFactory.createFilteredXMLStreamReader(message, digester);
    }

    @Override
    public void writeTo(XMLStreamWriter streamWriter, HashMap props) throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    @Override
    public HashMap<String, String> getInscopeNSContext() {
        return this.currentParentNS;
    }

    @Override
    public WSSPolicy getPolicy() {
        return this.signPolicy;
    }
}

