/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.wom.impl.extension.wsdl11.soap;

import java.util.Collection;
import java.util.Collections;
import javax.xml.namespace.QName;
import org.jvnet.wom.api.WSDLExtension;
import org.jvnet.wom.api.binding.wsdl11.soap.SOAP11Constants;
import org.jvnet.wom.api.binding.wsdl11.soap.SOAP12Constants;
import org.jvnet.wom.api.binding.wsdl11.soap.SOAPBody;
import org.jvnet.wom.impl.extension.Messages;
import org.jvnet.wom.impl.extension.wsdl11.AbstractWSDLExtensionHandler;
import org.jvnet.wom.impl.extension.wsdl11.soap.SOAPHeaderImpl;
import org.jvnet.wom.impl.util.XmlUtil;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAPHeaderExtensionHandler
extends AbstractWSDLExtensionHandler {
    private final QName[] names = new QName[]{SOAP11Constants.SOAPHEADER_NAME, SOAP12Constants.SOAPHEADER_NAME};
    private SOAPHeaderImpl header;
    private final ContentHandler contentHandler = new SOAPHeaderCH();

    public SOAPHeaderExtensionHandler(ErrorHandler errorHandler, EntityResolver entityResolver) {
        super(errorHandler, entityResolver);
    }

    @Override
    public Collection<WSDLExtension> getExtensions() {
        return Collections.singleton(this.header);
    }

    @Override
    public ContentHandler getContentHandlerFor(String nsUri, String localName) {
        if (this.canHandle(nsUri, localName)) {
            return this.contentHandler;
        }
        return null;
    }

    @Override
    protected QName[] getExtensionNames() {
        return this.names;
    }

    private class SOAPHeaderCH
    extends AbstractWSDLExtensionHandler.WSDLExtensibilityContentHandler {
        private SOAPHeaderCH() {
        }

        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            String message;
            if (!SOAPHeaderExtensionHandler.this.canHandle(uri, localName)) {
                return;
            }
            String encodingStyleAtt = atts.getValue("encodingStyle");
            String[] encodingStyle = null;
            if (encodingStyleAtt != null) {
                encodingStyle = encodingStyleAtt.split("\\s");
            }
            String namespace = atts.getValue("namespace");
            String useatt = XmlUtil.fixNull(atts.getValue("use")).trim();
            SOAPBody.Use use = SOAPBody.Use.literal;
            if (useatt.equals("encoded")) {
                use = SOAPBody.Use.encoded;
            } else if (!useatt.equals("literal")) {
                SOAPHeaderExtensionHandler.this.errorHandler.error(new SAXParseException(Messages.format("invalid.attr", "use", useatt, "literal or encoded"), this.locator));
            }
            String part = atts.getValue("part");
            if (part == null) {
                SOAPHeaderExtensionHandler.this.errorHandler.error(new SAXParseException(Messages.format("missing.attr", "part", "soap:header"), this.locator));
            }
            if ((message = atts.getValue("message")) == null) {
                SOAPHeaderExtensionHandler.this.errorHandler.error(new SAXParseException(Messages.format("missing.attr", "message", "soap:header"), this.locator));
            }
            String localPart = XmlUtil.getLocalPart(message);
            String prefix = XmlUtil.getPrefix(message);
            SOAPHeaderExtensionHandler.this.header = new SOAPHeaderImpl(new QName(uri, localName));
            SOAPHeaderExtensionHandler.this.header.setMessage(new QName(this.resolveNamespacePrefix(prefix), localPart));
            SOAPHeaderExtensionHandler.this.header.setPart(part);
            SOAPHeaderExtensionHandler.this.header.setUse(use);
            SOAPHeaderExtensionHandler.this.header.setEncodingStyle(encodingStyle);
            SOAPHeaderExtensionHandler.this.header.setNamespace(namespace);
        }
    }
}

