/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.wom.impl.extension.wsdl11.soap;

import java.util.Collection;
import java.util.Collections;
import javax.xml.namespace.QName;
import org.jvnet.wom.api.WSDLExtension;
import org.jvnet.wom.api.binding.wsdl11.soap.SOAP11Constants;
import org.jvnet.wom.api.binding.wsdl11.soap.SOAP12Constants;
import org.jvnet.wom.api.binding.wsdl11.soap.SOAPBody;
import org.jvnet.wom.impl.extension.Messages;
import org.jvnet.wom.impl.extension.wsdl11.AbstractWSDLExtensionHandler;
import org.jvnet.wom.impl.extension.wsdl11.soap.SOAPBodyImpl;
import org.jvnet.wom.impl.util.XmlUtil;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAPBodyExtensionHandler
extends AbstractWSDLExtensionHandler {
    private final ContentHandler contentHandler = new SOAPBodyCH();
    private SOAPBodyImpl body;
    private final QName[] names = new QName[]{SOAP11Constants.SOAPBODY_NAME, SOAP12Constants.SOAPBODY_NAME};

    public SOAPBodyExtensionHandler(ErrorHandler errorHandler, EntityResolver entityResolver) {
        super(errorHandler, entityResolver);
    }

    @Override
    public Collection<WSDLExtension> getExtensions() {
        return Collections.singleton(this.body);
    }

    @Override
    protected QName[] getExtensionNames() {
        return this.names;
    }

    @Override
    public ContentHandler getContentHandlerFor(String nsUri, String localName) {
        if (this.canHandle(nsUri, localName)) {
            return this.contentHandler;
        }
        return null;
    }

    private class SOAPBodyCH
    extends AbstractWSDLExtensionHandler.WSDLExtensibilityContentHandler {
        private SOAPBodyCH() {
        }

        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if (!SOAPBodyExtensionHandler.this.canHandle(uri, localName)) {
                return;
            }
            String encodingStyleAtt = atts.getValue("encodingStyle");
            String[] encodingStyle = null;
            if (encodingStyleAtt != null) {
                encodingStyle = encodingStyleAtt.split("\\s");
            }
            String namespace = atts.getValue("namespace");
            String useatt = XmlUtil.fixNull(atts.getValue("use")).trim();
            SOAPBody.Use use = SOAPBody.Use.literal;
            if (useatt.equals("encoded")) {
                use = SOAPBody.Use.encoded;
            } else if (!useatt.equals("literal")) {
                SOAPBodyExtensionHandler.this.errorHandler.error(new SAXParseException(Messages.format("invalid.attr", "use", useatt, "literal or encoded"), this.locator));
            }
            String partsAtt = atts.getValue("parts");
            String[] parts = null;
            if (partsAtt != null) {
                parts = partsAtt.split("\\s");
            }
            SOAPBodyExtensionHandler.this.body = new SOAPBodyImpl(new QName(uri, localName));
            SOAPBodyExtensionHandler.this.body.setParts(parts);
            SOAPBodyExtensionHandler.this.body.setEncodingStyle(encodingStyle);
            SOAPBodyExtensionHandler.this.body.setNamespace(namespace);
            SOAPBodyExtensionHandler.this.body.setUse(use);
        }
    }
}

