/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.tcp.io;

import com.sun.xml.ws.transport.tcp.io.BufferedMessageInputStream;
import com.sun.xml.ws.transport.tcp.io.FramedMessageInputStream;
import com.sun.xml.ws.transport.tcp.io.FramedMessageOutputStream;
import com.sun.xml.ws.transport.tcp.pool.ByteBufferStreamPool;
import com.sun.xml.ws.transport.tcp.resources.MessagesMessages;
import com.sun.xml.ws.transport.tcp.util.ByteBufferFactory;
import com.sun.xml.ws.transport.tcp.util.FrameType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Connection {
    private static final Logger logger = Logger.getLogger("com.sun.xml.ws.transport.tcp");
    private static ByteBufferStreamPool<FramedMessageInputStream> byteBufferInputStreamPool = new ByteBufferStreamPool<FramedMessageInputStream>(FramedMessageInputStream.class);
    private static ByteBufferStreamPool<FramedMessageOutputStream> byteBufferOutputStreamPool = new ByteBufferStreamPool<FramedMessageOutputStream>(FramedMessageOutputStream.class);
    private SocketChannel socketChannel;
    private WeakReference<BufferedMessageInputStream> inputStreamRef;
    private FramedMessageInputStream inputStream = byteBufferInputStreamPool.take();
    private FramedMessageOutputStream outputStream = byteBufferOutputStreamPool.take();
    private boolean isDirectMode;
    private int messageId;
    private int channelId;
    private int contentId;

    public Connection(SocketChannel socketChannel) {
        this.setSocketChannel(socketChannel);
    }

    public SocketChannel getSocketChannel() {
        return this.socketChannel;
    }

    public void setSocketChannel(SocketChannel socketChannel) {
        this.socketChannel = socketChannel;
        this.inputStream.setSocketChannel(socketChannel);
        this.outputStream.setSocketChannel(socketChannel);
    }

    public void prepareForReading() throws IOException {
        if (this.inputStreamRef != null) {
            BufferedMessageInputStream is = (BufferedMessageInputStream)this.inputStreamRef.get();
            if (this.inputStream.isMessageInProcess() && is != null && !is.isClosed()) {
                is.bufferMessage();
                logger.log(Level.FINEST, MessagesMessages.WSTCP_1050_CONNECTION_BUFFERING_IS(is.getBufferedSize()));
            }
        }
        if (this.inputStream.isMessageInProcess()) {
            this.inputStream.skipToEndOfMessage();
        }
        this.inputStream.reset();
        this.outputStream.reset();
        this.inputStream.forceHeaderRead();
        this.channelId = this.inputStream.getChannelId();
        this.messageId = this.inputStream.getMessageId();
        if (FrameType.isFrameContainsParams(this.messageId)) {
            this.contentId = this.inputStream.getContentId();
        }
    }

    public InputStream openInputStream() throws IOException {
        BufferedMessageInputStream is = new BufferedMessageInputStream(this.inputStream);
        this.inputStreamRef = new WeakReference<BufferedMessageInputStream>(is);
        return is;
    }

    public OutputStream openOutputStream() throws IOException {
        this.outputStream.setChannelId(this.channelId);
        this.outputStream.setMessageId(this.messageId);
        this.outputStream.setContentId(this.contentId);
        this.outputStream.buildHeader();
        return this.outputStream;
    }

    public void flush() throws IOException {
        this.outputStream.flushLast();
    }

    public boolean isDirectMode() {
        return this.isDirectMode;
    }

    public void setDirectMode(boolean isDirectMode) {
        this.isDirectMode = isDirectMode;
        this.inputStream.setDirectMode(isDirectMode);
        this.outputStream.setDirectMode(isDirectMode);
    }

    public int getChannelId() {
        return this.channelId;
    }

    public void setChannelId(int channelId) {
        this.channelId = channelId;
    }

    public int getMessageId() {
        return this.messageId;
    }

    public void setMessageId(int messageId) {
        this.messageId = messageId;
    }

    public int getContentId() {
        return this.contentId;
    }

    public void setContentId(int contentId) {
        this.contentId = contentId;
    }

    public Map<Integer, String> getContentProperties() {
        return this.inputStream.getContentProperties();
    }

    public void setContentProperty(int key, String value) {
        this.outputStream.setContentProperty(key, value);
    }

    public void setInputStreamByteBuffer(ByteBuffer messageBuffer) {
        this.inputStream.setByteBuffer(messageBuffer);
    }

    public void close() throws IOException {
        if (this.inputStream != null) {
            byteBufferInputStreamPool.release(this.inputStream);
            this.inputStream = null;
        }
        if (this.outputStream != null) {
            byteBufferOutputStreamPool.release(this.outputStream);
            this.outputStream = null;
        }
        this.socketChannel.close();
    }

    public static Connection create(String host, int port) throws IOException {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, MessagesMessages.WSTCP_1051_CONNECTION_OPEN_TCP_SOCKET(host, port));
        }
        SocketChannel socketChannel = SocketChannel.open();
        Socket socket = socketChannel.socket();
        socket.connect(new InetSocketAddress(host, port));
        socketChannel.configureBlocking(false);
        Connection connection = new Connection(socketChannel);
        ByteBuffer byteBuffer = ByteBufferFactory.allocateView(4096, false);
        byteBuffer.position(0);
        byteBuffer.limit(0);
        connection.setInputStreamByteBuffer(byteBuffer);
        return connection;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public String getHost() {
        return Connection.getHost(this.socketChannel);
    }

    public int getPort() {
        return Connection.getPort(this.socketChannel);
    }

    public String getLocalHost() {
        return Connection.getLocalHost(this.socketChannel);
    }

    public int getLocalPort() {
        return Connection.getLocalPort(this.socketChannel);
    }

    public String toString() {
        return "host: " + this.getHost() + " port: " + this.getPort();
    }

    public static String getHost(SocketChannel socketChannel) {
        return socketChannel.socket().getInetAddress().getHostAddress();
    }

    public static int getPort(SocketChannel socketChannel) {
        return socketChannel.socket().getPort();
    }

    public static String getLocalHost(SocketChannel socketChannel) {
        return socketChannel.socket().getLocalAddress().getHostAddress();
    }

    public static int getLocalPort(SocketChannel socketChannel) {
        return socketChannel.socket().getLocalPort();
    }
}

