/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.runtime.testing;

import com.sun.xml.ws.api.FeatureConstructor;
import com.sun.xml.ws.rm.localization.RmLogger;
import com.sun.xml.ws.rm.runtime.testing.PacketFilter;
import javax.xml.ws.WebServiceFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PacketFilteringFeature
extends WebServiceFeature {
    public static final String ID = "com.sun.xml.ws.rm.runtime.testing.PacketFilteringFeature";
    private static final RmLogger LOGGER = RmLogger.getLogger(PacketFilteringFeature.class);
    private final PacketFilter[] filters;

    public PacketFilteringFeature() {
        this.filters = null;
        this.enabled = true;
    }

    public PacketFilteringFeature(boolean enabled) {
        this.filters = null;
        this.enabled = enabled;
    }

    public PacketFilteringFeature(Class<? extends PacketFilter> ... filterClasses) {
        this(true, filterClasses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FeatureConstructor(value={"enabled", "filters"})
    public PacketFilteringFeature(boolean enabled, Class<? extends PacketFilter> ... filterClasses) {
        this.enabled = enabled;
        if (filterClasses != null && filterClasses.length > 0) {
            this.filters = new PacketFilter[filterClasses.length];
            int i = 0;
            for (Class<? extends PacketFilter> filterClass : filterClasses) {
                try {
                    this.filters[i] = filterClass.newInstance();
                }
                catch (InstantiationException ex) {
                    LOGGER.warning("Error instantiating packet filter of class [" + filterClass.getName() + "]", ex);
                }
                catch (IllegalAccessException ex) {
                    LOGGER.warning("Error instantiating packet filter of class [" + filterClass.getName() + "]", ex);
                }
                finally {
                    ++i;
                }
            }
        } else {
            this.filters = null;
        }
    }

    public String getID() {
        return ID;
    }

    public PacketFilter[] getFilters() {
        return this.filters;
    }
}

