/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.runtime;

import com.sun.xml.ws.rm.RmException;
import com.sun.xml.ws.rm.localization.LocalizationMessages;
import com.sun.xml.ws.rm.localization.RmLogger;
import com.sun.xml.ws.runtime.util.Session;
import com.sun.xml.ws.runtime.util.SessionManager;
import com.sun.xml.ws.security.secext10.ObjectFactory;
import com.sun.xml.ws.security.secext10.SecurityTokenReferenceType;
import com.sun.xml.ws.security.trust.WSTrustElementFactory;
import com.sun.xml.ws.security.trust.elements.str.DirectReference;
import com.sun.xml.ws.security.trust.elements.str.Reference;

final class Utilities {
    private static final RmLogger LOGGER = RmLogger.getLogger(Utilities.class);

    private Utilities() {
    }

    static void assertSequenceId(String expected, String actual) throws IllegalStateException {
        if (expected != null && !expected.equals(actual)) {
            throw LOGGER.logSevereException(new IllegalStateException(LocalizationMessages.WSRM_1105_SEQUENCE_ID_NOT_RECOGNIZED(actual, expected)));
        }
    }

    static String extractSecurityContextTokenId(SecurityTokenReferenceType strType) throws RmException {
        Reference strReference = WSTrustElementFactory.newInstance().createSecurityTokenReference(new ObjectFactory().createSecurityTokenReference(strType)).getReference();
        if (!(strReference instanceof DirectReference)) {
            throw LOGGER.logSevereException(new RmException(LocalizationMessages.WSRM_1132_SECURITY_REFERENCE_ERROR(strReference.getClass().getName())));
        }
        return ((DirectReference)strReference).getURIAttr().toString();
    }

    static Session startSession(String sessionId) {
        SessionManager manager = SessionManager.getSessionManager();
        Session session = manager.getSession(sessionId);
        if (session == null) {
            session = manager.createSession(sessionId);
        }
        return session;
    }

    static void endSessionIfExists(String sessionId) {
        SessionManager manager = SessionManager.getSessionManager();
        if (manager.getSession(sessionId) != null) {
            manager.terminateSession(sessionId);
        }
    }
}

