/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.runtime;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.Headers;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.rm.RmRuntimeException;
import com.sun.xml.ws.rm.RmVersion;
import com.sun.xml.ws.rm.localization.LocalizationMessages;
import com.sun.xml.ws.rm.localization.RmLogger;
import com.sun.xml.ws.rm.policy.Configuration;
import com.sun.xml.ws.rm.runtime.Rm10PacketAdapter;
import com.sun.xml.ws.rm.runtime.Rm11PacketAdapter;
import com.sun.xml.ws.rm.runtime.sequence.Sequence;
import com.sun.xml.ws.rm.runtime.sequence.SequenceManager;
import com.sun.xml.ws.runtime.util.Session;
import com.sun.xml.ws.runtime.util.SessionManager;
import javax.xml.bind.JAXBException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class PacketAdapter {
    private static final RmLogger LOGGER = RmLogger.getLogger(PacketAdapter.class);
    Message message;
    private Packet packet;
    private boolean isSequenceDataInit;
    private boolean isAckRequestedHeaderDataInit;
    private String sequenceId;
    private String ackRequestedHeaderSequenceId;
    private long messageNumber;
    private boolean messageConsumed;
    private final Configuration configuration;
    private final RmVersion rmVersion;
    private final SOAPVersion soapVersion;
    private final AddressingVersion addressingVersion;

    static PacketAdapter getInstance(@NotNull Configuration configuration, @NotNull Packet packet) {
        switch (configuration.getRmVersion()) {
            case WSRM10: {
                return new Rm10PacketAdapter(configuration, packet);
            }
            case WSRM11: {
                return new Rm11PacketAdapter(configuration, packet);
            }
        }
        throw new IllegalStateException(LocalizationMessages.WSRM_1104_RM_VERSION_NOT_SUPPORTED(configuration.getRmVersion().namespaceUri));
    }

    PacketAdapter(@NotNull Configuration configuration, @NotNull Packet packet) {
        this.configuration = configuration;
        this.rmVersion = configuration.getRmVersion();
        this.soapVersion = configuration.getSoapVersion();
        this.addressingVersion = configuration.getAddressingVersion();
        this.insertPacket(packet);
    }

    private final void insertPacket(Packet packet) {
        this.packet = packet;
        if (packet.getMessage() != null) {
            this.message = packet.getMessage();
        }
    }

    final void consume() {
        if (this.message != null && !this.messageConsumed) {
            this.messageConsumed = true;
            this.message.consume();
        }
    }

    final Packet getPacket() {
        return this.packet;
    }

    final Packet copyPacket(boolean copyMessage) {
        return this.packet.copy(copyMessage);
    }

    final PacketAdapter createServerResponse(Object jaxbElement, String wsaAction) {
        return PacketAdapter.getInstance(this.configuration, this.packet.createServerResponse(Messages.create(this.rmVersion.jaxbContext, jaxbElement, this.soapVersion), this.addressingVersion, this.soapVersion, wsaAction));
    }

    final PacketAdapter createEmptyServerResponse(String wsaAction) {
        return PacketAdapter.getInstance(this.configuration, this.packet.createServerResponse(Messages.createEmpty(this.soapVersion), this.addressingVersion, this.soapVersion, wsaAction));
    }

    final PacketAdapter createAckResponse(Sequence sequence, String wsaAction) throws RmRuntimeException {
        PacketAdapter responseAdapter = this.createEmptyServerResponse(wsaAction);
        responseAdapter.appendSequenceAcknowledgementHeader(sequence);
        return responseAdapter;
    }

    final PacketAdapter closeTransportAndReturnNull() {
        this.packet.transportBackChannel.close();
        Packet emptyReturnPacket = new Packet();
        emptyReturnPacket.invocationProperties.putAll(this.packet.invocationProperties);
        return PacketAdapter.getInstance(this.configuration, emptyReturnPacket);
    }

    final void appendHeader(Object jaxbHeaderContent) throws IllegalStateException {
        this.checkMessageReadyState();
        this.message.getHeaders().add(Headers.create(this.rmVersion.jaxbContext, jaxbHeaderContent));
    }

    abstract void appendSequenceHeader(@NotNull String var1, long var2) throws RmRuntimeException;

    abstract void appendAckRequestedHeader(@NotNull String var1) throws RmRuntimeException;

    abstract void appendSequenceAcknowledgementHeader(@NotNull Sequence var1) throws RmRuntimeException;

    final PacketAdapter keepTransportBackChannelOpen() {
        this.packet.keepTransportBackChannelOpen();
        return this;
    }

    final PacketAdapter setEmptyRequestMessage(String wsaAction) {
        return this.setRequestMessage(Messages.createEmpty(this.soapVersion), wsaAction);
    }

    final PacketAdapter setEmptyResponseMessage(PacketAdapter requestAdapter, String wsaAction) {
        this.message = Messages.createEmpty(this.soapVersion);
        this.packet = requestAdapter.packet.createServerResponse(this.message, this.addressingVersion, this.soapVersion, wsaAction);
        return this;
    }

    final PacketAdapter setRequestMessage(Object jaxbElement, String wsaAction) {
        return this.setRequestMessage(Messages.create(this.rmVersion.jaxbContext, jaxbElement, this.soapVersion), wsaAction);
    }

    private final PacketAdapter setRequestMessage(Message newMessage, String wsaAction) {
        this.checkPacketReadyState();
        this.message = newMessage;
        this.packet.setMessage(this.message);
        this.message.assertOneWay(false);
        this.message.getHeaders().fillRequestAddressingHeaders(this.packet, this.addressingVersion, this.soapVersion, false, wsaAction);
        return this;
    }

    final boolean isProtocolMessage() {
        return this.message == null ? false : this.rmVersion.isRmAction(this.getWsaAction());
    }

    final boolean isProtocolRequest() {
        return this.message == null ? false : this.rmVersion.isRmProtocolRequest(this.getWsaAction());
    }

    final boolean isProtocolResponse() {
        return this.message == null ? false : this.rmVersion.isRmProtocolResponse(this.getWsaAction());
    }

    final boolean isRmFault() {
        return this.message == null ? false : this.rmVersion.isRmFault(this.getWsaAction());
    }

    final boolean isFault() {
        return this.message == null ? false : this.message.isFault();
    }

    final boolean containsMessage() {
        return this.message != null;
    }

    final String getWsaAction() {
        this.checkMessageReadyState();
        return this.message.getHeaders().getAction(this.addressingVersion, this.soapVersion);
    }

    final String getDestination() {
        this.checkMessageReadyState();
        return this.message.getHeaders().getTo(this.addressingVersion, this.soapVersion);
    }

    final <T> T readHeaderAsUnderstood(String name) throws RmRuntimeException {
        this.checkMessageReadyState();
        Header header = this.message.getHeaders().get(this.rmVersion.namespaceUri, name, true);
        if (header == null) {
            return (T)((Object)null);
        }
        try {
            return header.readAsJAXB(this.rmVersion.jaxbUnmarshaller);
        }
        catch (JAXBException ex) {
            throw LOGGER.logSevereException(new RmRuntimeException(LocalizationMessages.WSRM_1122_ERROR_MARSHALLING_RM_HEADER(this.rmVersion.namespaceUri + "#" + name), ex));
        }
    }

    final <T> T unmarshallMessage() throws RmRuntimeException {
        this.checkMessageReadyState();
        try {
            Object t = this.message.readPayloadAsJAXB(this.rmVersion.jaxbUnmarshaller);
            return t;
        }
        catch (JAXBException e) {
            throw LOGGER.logSevereException(new RmRuntimeException(LocalizationMessages.WSRM_1123_ERROR_UNMARSHALLING_MESSAGE(), e));
        }
        finally {
            this.messageConsumed = true;
        }
    }

    final String getSequenceId() throws RmRuntimeException {
        if (!this.isSequenceDataInit) {
            this.initSequenceHeaderData();
            this.isSequenceDataInit = true;
        }
        return this.sequenceId;
    }

    final long getMessageNumber() throws RmRuntimeException {
        if (!this.isSequenceDataInit) {
            this.initSequenceHeaderData();
            this.isSequenceDataInit = true;
        }
        return this.messageNumber;
    }

    abstract void initSequenceHeaderData() throws RmRuntimeException;

    final void setSequenceData(String sequenceId, long messageNumber) {
        this.sequenceId = sequenceId;
        this.messageNumber = messageNumber;
    }

    abstract String initAckRequestedHeaderData() throws RmRuntimeException;

    final String getAckRequestedHeaderSequenceId() throws RmRuntimeException {
        if (!this.isAckRequestedHeaderDataInit) {
            this.ackRequestedHeaderSequenceId = this.initAckRequestedHeaderData();
            this.isAckRequestedHeaderDataInit = true;
        }
        return this.ackRequestedHeaderSequenceId;
    }

    abstract void processAcknowledgements(SequenceManager var1, String var2) throws RmRuntimeException;

    Session getSession() {
        String sessionId = (String)this.packet.invocationProperties.get("com.sun.xml.ws.sessionid");
        if (sessionId == null) {
            return null;
        }
        return SessionManager.getSessionManager().getSession(sessionId);
    }

    void setSession(String sessionId) {
        this.packet.invocationProperties.put("com.sun.xml.ws.sessionid", sessionId);
        Session session = SessionManager.getSessionManager().getSession(sessionId);
        this.packet.invocationProperties.put("com.sun.xml.ws.session", session.getUserData());
    }

    boolean hasSession() {
        return this.getSession() != null;
    }

    String getSecurityContextTokenId() {
        Session session = this.getSession();
        return session != null ? session.getSecurityInfo().getIdentifier() : null;
    }

    final void checkMessageReadyState() throws IllegalStateException {
        if (this.message == null) {
            throw new IllegalStateException("This PacketAdapter instance does not contain a packet with a non-null message");
        }
    }

    final void checkPacketReadyState() throws IllegalStateException {
        if (this.packet == null) {
            throw new IllegalStateException("This PacketAdapter instance does not contain a packet with a non-null message");
        }
    }

    final boolean isSecurityContextTokenIdValid(String expectedSctId) {
        String actualSctId = this.getSecurityContextTokenId();
        return expectedSctId != null ? expectedSctId.equals(actualSctId) : actualSctId == null;
    }
}

