/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.at.common.endpoint;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.tx.at.WSATException;
import com.sun.xml.ws.tx.at.WSATHelper;
import com.sun.xml.ws.tx.at.WSATXAResource;
import com.sun.xml.ws.tx.at.common.CoordinatorIF;
import com.sun.xml.ws.tx.at.common.WSATVersion;
import com.sun.xml.ws.tx.at.internal.XidImpl;
import com.sun.xml.ws.tx.at.runtime.TransactionServices;
import javax.annotation.Resource;
import javax.transaction.xa.Xid;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Coordinator<T>
implements CoordinatorIF<T> {
    @Resource
    private WebServiceContext m_context;
    private WSATVersion<T> m_version;

    public Coordinator(WebServiceContext m_context, WSATVersion<T> m_version) {
        this.m_context = m_context;
        this.m_version = m_version;
    }

    @Override
    public void preparedOperation(T parameters) {
        Xid xidFromWebServiceContextHeaderList = this.getXid();
        if (!this.getWSATHelper().setDurableParticipantStatus(xidFromWebServiceContextHeaderList, "Prepared")) {
            this.replayOperation(parameters);
        }
    }

    @Override
    public void abortedOperation(T parameters) {
        Xid xidFromWebServiceContextHeaderList = this.getXid();
        this.getWSATHelper().setDurableParticipantStatus(xidFromWebServiceContextHeaderList, "Aborted");
    }

    @Override
    public void readOnlyOperation(T parameters) {
        Xid xidFromWebServiceContextHeaderList = this.getXid();
        this.getWSATHelper().setDurableParticipantStatus(xidFromWebServiceContextHeaderList, "ReadOnly");
    }

    @Override
    public void committedOperation(T parameters) {
        Xid xidFromWebServiceContextHeaderList = this.getXid();
        this.getWSATHelper().setDurableParticipantStatus(xidFromWebServiceContextHeaderList, "Committed");
    }

    @Override
    public void replayOperation(T parameters) {
        Xid xidFromWebServiceContextHeaderList = this.getXid();
        String wsatTid = this.getWSATHelper().getWSATTidFromWebServiceContextHeaderList(this.m_context);
        try {
            this.getTransactionServices().replayCompletion(wsatTid, this.createWSATXAResourceForXidFromReplyTo(xidFromWebServiceContextHeaderList));
        }
        catch (WSATException e) {
            // empty catch block
        }
    }

    protected TransactionServices getTransactionServices() {
        return WSATHelper.getTransactionServices();
    }

    WSATXAResource createWSATXAResourceForXidFromReplyTo(Xid xid) {
        HeaderList headerList = (HeaderList)this.m_context.getMessageContext().get((Object)"com.sun.xml.ws.api.message.HeaderList");
        WSEndpointReference wsReplyTo = headerList.getReplyTo(AddressingVersion.W3C, SOAPVersion.SOAP_12);
        EndpointReference replyTo = wsReplyTo.toSpec();
        return new WSATXAResource(this.m_version.getVersion(), replyTo, xid, true);
    }

    Xid getXid() {
        Xid xid = this.getWSATHelper().getXidFromWebServiceContextHeaderList(this.m_context);
        String bqual = this.getWSATHelper().getBQualFromWebServiceContextHeaderList(this.m_context);
        return new XidImpl(xid.getFormatId(), xid.getGlobalTransactionId(), bqual.getBytes());
    }

    boolean isDebugEnabled() {
        return WSATHelper.isDebugEnabled();
    }

    protected WSATHelper getWSATHelper() {
        return this.m_version.getWSATHelper();
    }
}

