/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.at.common;

import com.sun.xml.ws.tx.at.common.TransactionImportManager;
import com.sun.xml.ws.tx.at.common.TxLogger;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.UserTransaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionManagerImpl
implements TransactionManager,
TransactionSynchronizationRegistry {
    private static final TxLogger logger = TxLogger.getATLogger(TransactionManagerImpl.class);
    private static final String AS_TXN_MGR_JNDI_NAME = "java:appserver/TransactionManager";
    private static final String TXN_MGR_JNDI_NAME = System.getProperty("com.sun.xml.ws.tx.txnMgrJndiName", "java:appserver/TransactionManager");
    private static final String TXN_SYNC_REG_JNDI_NAME = "java:comp/TransactionSynchronizationRegistry";
    private static final String USER_TRANSACTION_JNDI_NAME = "java:comp/UserTransaction";
    private static final TransactionManagerImpl singleton = new TransactionManagerImpl();
    public static Transaction transaction;
    private final TransactionManager javaeeTM = (TransactionManager)TransactionManagerImpl.jndiLookup(TXN_MGR_JNDI_NAME);
    private final TransactionSynchronizationRegistry javaeeSynchReg = (TransactionSynchronizationRegistry)TransactionManagerImpl.jndiLookup("java:comp/TransactionSynchronizationRegistry");
    private static final TransactionSynchronizationRegistry tempjavaeeSynchReg;
    private static boolean initialized;
    private static Method servletPreInvokeTxMethod;
    private static Method servletPostInvokeTxMethod;

    public static TransactionManagerImpl getInstance() {
        return singleton;
    }

    private static Object jndiLookup(String jndiName) {
        Object result = null;
        try {
            InitialContext ctx = new InitialContext();
            result = ctx.lookup(jndiName);
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return result;
    }

    private TransactionManagerImpl() {
    }

    public TransactionManager getTransactionManager() {
        return this.javaeeTM;
    }

    public UserTransaction getUserTransaction() {
        return (UserTransaction)TransactionManagerImpl.jndiLookup(USER_TRANSACTION_JNDI_NAME);
    }

    public boolean isTransactionManagerAvailable() {
        return this.javaeeTM != null;
    }

    public void begin() throws NotSupportedException, SystemException {
        this.javaeeTM.begin();
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        this.javaeeTM.commit();
    }

    public int getStatus() throws SystemException {
        return this.javaeeTM.getStatus();
    }

    public Transaction getTransaction() throws SystemException {
        return this.javaeeTM.getTransaction();
    }

    public void resume(Transaction transaction) throws InvalidTransactionException, IllegalStateException, SystemException {
        this.javaeeTM.resume(transaction);
        this.servletPreInvokeTx();
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        this.javaeeTM.rollback();
    }

    public void setRollbackOnly() throws IllegalStateException {
        this.javaeeSynchReg.setRollbackOnly();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        this.javaeeTM.setTransactionTimeout(seconds);
    }

    public Transaction suspend() throws SystemException {
        this.servletPostInvokeTx(true);
        return this.javaeeTM.suspend();
    }

    public Object getTransactionKey() {
        return this.javaeeSynchReg.getTransactionKey();
    }

    public void putResource(Object object, Object object0) {
        tempjavaeeSynchReg.putResource(object, object0);
    }

    public Object getResource(Object object) {
        return tempjavaeeSynchReg.getResource(object);
    }

    public void registerInterposedSynchronization(Synchronization synchronization) {
        this.javaeeSynchReg.registerInterposedSynchronization(synchronization);
    }

    public void registerSynchronization(Synchronization sync) {
        String METHOD = "registerSynchronization";
        if (sync == null) {
            return;
        }
        Transaction txn = null;
        try {
            txn = this.javaeeTM.getTransaction();
        }
        catch (SystemException ex) {
            // empty catch block
        }
        if (txn != null) {
            try {
                txn.registerSynchronization(sync);
            }
            catch (IllegalStateException ex) {
            }
            catch (RollbackException ex) {
            }
            catch (SystemException ex) {
                // empty catch block
            }
        }
    }

    public int getTransactionStatus() {
        return this.javaeeSynchReg.getTransactionStatus();
    }

    public boolean getRollbackOnly() {
        return this.javaeeSynchReg.getRollbackOnly();
    }

    private static Method getMethod(Class<?> theClass, String methodName, Class<?> param) {
        Method method = null;
        try {
            method = param == null ? theClass.getMethod(methodName, new Class[0]) : theClass.getMethod(methodName, param);
            logger.finest("getMethod", "found Sun App Server 9.1 container specific method via reflection " + theClass.getName() + "." + methodName);
        }
        catch (Exception e) {
            logger.finest("getMethod", "reflection lookup of  " + theClass.getName() + "." + methodName + "(" + (param == null ? "" : param.getName()) + ") failed with handled exception ", e);
        }
        return method;
    }

    private void initServletMethods() {
        if (!initialized) {
            initialized = true;
            servletPreInvokeTxMethod = TransactionManagerImpl.getMethod(this.javaeeTM.getClass(), "servletPreInvokeTx", null);
            servletPostInvokeTxMethod = TransactionManagerImpl.getMethod(this.javaeeTM.getClass(), "servletPostInvokeTx", Boolean.TYPE);
        }
    }

    public void servletPreInvokeTx() {
        String METHOD = "servletPreInvokeTx";
        this.initServletMethods();
        if (servletPreInvokeTxMethod != null) {
            try {
                servletPreInvokeTxMethod.invoke((Object)this.javaeeTM, new Object[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void servletPostInvokeTx(Boolean suspend) {
        String METHOD = "servletPostInvokeTx";
        this.initServletMethods();
        if (servletPostInvokeTxMethod != null) {
            try {
                servletPostInvokeTxMethod.invoke((Object)this.javaeeTM, suspend);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public int getRemainingTimeout() {
        block4: {
            String METHOD = "getRemainingTimeout";
            try {
                return TransactionImportManager.getInstance().getTransactionRemainingTimeout();
            }
            catch (SystemException se) {
                if (logger.isLogging(Level.FINEST)) {
                    logger.finest("getRemainingTimeout", "getRemainingTimeout stack trace", se);
                }
            }
            catch (Throwable t) {
                if (!logger.isLogging(Level.FINEST)) break block4;
                logger.finest("getRemainingTimeout", "getTransactionRemainingTimeout() failed, default to no timeout", t);
            }
        }
        return 0;
    }

    static {
        tempjavaeeSynchReg = new TransactionSynchronizationRegistry(){
            Map map = new HashMap();

            public Object getTransactionKey() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public void putResource(Object o, Object o1) {
                this.map.put(o, o1);
            }

            public Object getResource(Object o) {
                return this.map.get(o);
            }

            public void registerInterposedSynchronization(Synchronization s) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public int getTransactionStatus() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public void setRollbackOnly() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public boolean getRollbackOnly() {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        };
        initialized = false;
        servletPreInvokeTxMethod = null;
        servletPostInvokeTxMethod = null;
    }
}

