/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.policy.config;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.config.metro.dev.FeatureReader;
import com.sun.xml.ws.config.metro.util.ParserUtil;
import com.sun.xml.ws.policy.config.PolicyFeature;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.ws.WebServiceException;

public class PolicyFeatureReader
implements FeatureReader {
    private static final Logger LOGGER = Logger.getLogger(PolicyFeatureReader.class);

    public PolicyFeature parse(XMLEventReader reader) throws WebServiceException {
        try {
            boolean attributeEnabled = true;
            StartElement element = reader.nextEvent().asStartElement();
            QName elementName = element.getName();
            Iterator<Attribute> iterator = element.getAttributes();
            while (iterator.hasNext()) {
                Attribute nextAttribute = iterator.next();
                QName attributeName = nextAttribute.getName();
                if (ENABLED_ATTRIBUTE_NAME.equals(attributeName)) {
                    attributeEnabled = ParserUtil.parseBooleanValue(nextAttribute.getValue());
                    continue;
                }
                throw (WebServiceException)LOGGER.logSevereException((Throwable)new WebServiceException("Unexpected attribute"));
            }
            EndElement endElement = reader.nextEvent().asEndElement();
            if (!elementName.equals(endElement.getName())) {
                throw (WebServiceException)LOGGER.logSevereException((Throwable)new WebServiceException("Expected end element"));
            }
            return new PolicyFeature(attributeEnabled, null);
        }
        catch (XMLStreamException e) {
            throw (WebServiceException)LOGGER.logSevereException((Throwable)new WebServiceException("Failed to unmarshal XML document", (Throwable)e));
        }
    }
}

