/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.core;

import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.signature.ObjectContainer;
import com.sun.org.apache.xml.internal.security.signature.SignedInfo;
import com.sun.org.apache.xml.internal.security.signature.XMLSignature;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureException;
import com.sun.org.apache.xml.internal.security.transforms.Transforms;
import com.sun.org.apache.xml.internal.security.utils.ElementProxy;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverSpi;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.KeyInfoHeaderBlock;
import com.sun.xml.wss.core.SecurityHeaderBlock;
import com.sun.xml.wss.impl.misc.SecurityHeaderBlockImpl;
import java.security.Key;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.soap.SOAPElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SignatureHeaderBlock
extends SecurityHeaderBlockImpl {
    public static final String SignatureSpecNS = "http://www.w3.org/2000/09/xmldsig#";
    public static final String SignatureSpecNSprefix = "ds";
    public static final String TAG_SIGNATURE = "Signature";
    XMLSignature delegateSignature = null;
    boolean dirty = false;
    private static Logger log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");
    String baseURI = null;
    private Document document = null;

    public SignatureHeaderBlock(SOAPElement elem) throws XWSSecurityException {
        super(elem);
        try {
            this.document = elem.getOwnerDocument();
            this.delegateSignature = new XMLSignature(elem, null);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0322.exception.creating.signatureblock", e);
            throw new XWSSecurityException(e);
        }
    }

    public SignatureHeaderBlock(XMLSignature signature) throws XWSSecurityException {
        this.document = signature.getDocument();
        this.delegateSignature = signature;
        this.dirty = true;
        this.setSOAPElement(this.getAsSoapElement());
    }

    public SignatureHeaderBlock(Document doc, String signatureMethodURI) throws XWSSecurityException {
        try {
            this.document = doc;
            this.delegateSignature = new XMLSignature(doc, null, signatureMethodURI, "http://www.w3.org/2001/10/xml-exc-c14n#");
            this.dirty = true;
            this.setSOAPElement(this.getAsSoapElement());
        }
        catch (XMLSecurityException e) {
            log.log(Level.SEVERE, "WSS0322.exception.creating.signatureblock", e);
            throw new XWSSecurityException(e);
        }
    }

    public XMLSignature getSignature() {
        return this.delegateSignature;
    }

    public void sign(Key signingKey) throws XWSSecurityException {
        try {
            this.delegateSignature.sign(signingKey);
            this.dirty = true;
        }
        catch (XMLSignatureException e) {
            log.log(Level.SEVERE, "WSS0323.exception.while.signing", e);
            throw new XWSSecurityException(e);
        }
    }

    public SOAPElement getSignedInfo() throws XWSSecurityException {
        return this.convertToSoapElement(this.delegateSignature.getSignedInfo());
    }

    public SignedInfo getDSSignedInfo() {
        return this.delegateSignature.getSignedInfo();
    }

    public SOAPElement getKeyInfo() throws XWSSecurityException {
        return this.convertToSoapElement(this.delegateSignature.getKeyInfo());
    }

    public KeyInfoHeaderBlock getKeyInfoHeaderBlock() throws XWSSecurityException {
        return new KeyInfoHeaderBlock(this.delegateSignature.getKeyInfo());
    }

    public byte[] getSignatureValue() throws XWSSecurityException {
        try {
            return this.delegateSignature.getSignatureValue();
        }
        catch (XMLSignatureException e) {
            log.log(Level.SEVERE, "WSS0324.exception.in.getting.signaturevalue", e);
            throw new XWSSecurityException(e);
        }
    }

    public void addSignedInfoReference(String referenceURI, Transforms transforms) throws XWSSecurityException {
        try {
            this.delegateSignature.addDocument(referenceURI, transforms);
            this.dirty = true;
        }
        catch (XMLSecurityException e) {
            log.log(Level.SEVERE, "WSS0325.exception.adding.reference.to.signedinfo", e);
            throw new XWSSecurityException(e);
        }
    }

    public void addSignedInfoReference(String referenceURI, Transforms trans, String digestURI) throws XWSSecurityException {
        try {
            this.delegateSignature.addDocument(referenceURI, trans, digestURI);
            this.dirty = true;
        }
        catch (XMLSecurityException e) {
            log.log(Level.SEVERE, "WSS0325.exception.adding.reference.to.signedinfo", e);
            throw new XWSSecurityException(e);
        }
    }

    public void addSignedInfoReference(String referenceURI, Transforms trans, String digestURI, String referenceId, String referenceType) throws XWSSecurityException {
        try {
            this.delegateSignature.addDocument(referenceURI, trans, digestURI, referenceId, referenceType);
            this.dirty = true;
        }
        catch (XMLSecurityException e) {
            log.log(Level.SEVERE, "WSS0325.exception.adding.reference.to.signedinfo", e);
            throw new XWSSecurityException(e);
        }
    }

    public boolean checkSignatureValue(X509Certificate cert) throws XWSSecurityException {
        try {
            return this.delegateSignature.checkSignatureValue(cert);
        }
        catch (XMLSignatureException e) {
            log.log(Level.SEVERE, "WSS0326.exception.verifying.signature", e);
            throw new XWSSecurityException(e);
        }
    }

    public boolean checkSignatureValue(Key pk) throws XWSSecurityException {
        try {
            return this.delegateSignature.checkSignatureValue(pk);
        }
        catch (XMLSignatureException e) {
            log.log(Level.SEVERE, "WSS0326.exception.verifying.signature", e);
            throw new XWSSecurityException(e);
        }
    }

    public void appendObject(SOAPElement object) throws XWSSecurityException {
        try {
            ObjectContainer objc = new ObjectContainer(object, null);
            this.delegateSignature.appendObject(objc);
        }
        catch (XMLSecurityException e) {
            log.log(Level.SEVERE, "WSS0382.error.appending.object", e.getMessage());
            throw new XWSSecurityException(e);
        }
    }

    public SOAPElement getObjectItem(int index) throws XWSSecurityException {
        return this.convertToSoapElement(this.delegateSignature.getObjectItem(index));
    }

    public int getObjectCount() {
        return this.delegateSignature.getObjectLength();
    }

    public void setId(String id) {
        this.delegateSignature.setId(id);
    }

    public String getId() {
        return this.delegateSignature.getId();
    }

    public void setBaseURI(String uri) {
        this.baseURI = uri;
    }

    public SOAPElement getAsSoapElement() throws XWSSecurityException {
        if (this.document == null) {
            log.log(Level.SEVERE, "WSS0383.document.not.set");
            throw new XWSSecurityException("Document not set");
        }
        if (this.dirty) {
            this.setSOAPElement(this.convertToSoapElement(this.delegateSignature));
            this.dirty = false;
        }
        return this.delegateElement;
    }

    public void setDocument(Document doc) {
        this.document = doc;
    }

    public void saveChanges() {
        this.dirty = true;
    }

    public void setApacheResourceResolver(ResourceResolverSpi resolver) {
        this.delegateSignature.addResourceResolver(resolver);
    }

    public static SecurityHeaderBlock fromSoapElement(SOAPElement element) throws XWSSecurityException {
        return SecurityHeaderBlockImpl.fromSoapElement(element, SignatureHeaderBlock.class);
    }

    private SOAPElement convertToSoapElement(ElementProxy proxy) throws XWSSecurityException {
        try {
            Element elem = proxy.getElement();
            if (elem instanceof SOAPElement) {
                return (SOAPElement)elem;
            }
            return (SOAPElement)this.document.importNode(elem, true);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0327.exception.converting.signature.tosoapelement", e);
            throw new XWSSecurityException(e);
        }
    }
}

