/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.tcp.policy;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.PolicyMapKey;
import com.sun.xml.ws.policy.jaxws.spi.PolicyFeatureConfigurator;
import com.sun.xml.ws.transport.TcpTransportFeature;
import com.sun.xml.ws.transport.tcp.wsit.TCPConstants;
import java.util.Collection;
import java.util.LinkedList;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCPTransportFeatureConfigurator
implements PolicyFeatureConfigurator {
    private static final QName ENABLED = new QName("enabled");
    private static final Logger LOGGER = Logger.getLogger(TCPTransportFeatureConfigurator.class);

    @Override
    public Collection<WebServiceFeature> getFeatures(PolicyMapKey key, PolicyMap policyMap) throws PolicyException {
        Policy policy;
        LinkedList<WebServiceFeature> features = new LinkedList<WebServiceFeature>();
        if (key != null && policyMap != null && (policy = policyMap.getEndpointEffectivePolicy(key)) != null) {
            for (AssertionSet alternative : policy) {
                for (PolicyAssertion assertion : alternative) {
                    if (!assertion.getName().equals(TCPConstants.TCPTRANSPORT_POLICY_ASSERTION)) continue;
                    boolean isEnabled = true;
                    String value = assertion.getAttributeValue(ENABLED);
                    if (value != null) {
                        isEnabled = Boolean.valueOf(value = value.trim()) != false || value.equalsIgnoreCase("yes");
                    }
                    features.add(new TcpTransportFeature(isEnabled));
                }
            }
        }
        return features;
    }
}

