/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.ws.api.security.trust.WSTrustException;
import com.sun.xml.ws.assembler.ClientTubelineAssemblyContext;
import com.sun.xml.ws.commons.MaintenanceTaskExecutor;
import com.sun.xml.ws.commons.VolatileReference;
import com.sun.xml.ws.rx.RxRuntimeException;
import com.sun.xml.ws.rx.mc.runtime.McClientTube;
import com.sun.xml.ws.rx.mc.runtime.spi.ProtocolMessageHandler;
import com.sun.xml.ws.rx.rm.api.RmProtocolVersion;
import com.sun.xml.ws.rx.rm.localization.LocalizationMessages;
import com.sun.xml.ws.rx.rm.protocol.AcknowledgementData;
import com.sun.xml.ws.rx.rm.protocol.CloseSequenceData;
import com.sun.xml.ws.rx.rm.protocol.CloseSequenceResponseData;
import com.sun.xml.ws.rx.rm.protocol.CreateSequenceData;
import com.sun.xml.ws.rx.rm.protocol.CreateSequenceResponseData;
import com.sun.xml.ws.rx.rm.protocol.TerminateSequenceData;
import com.sun.xml.ws.rx.rm.protocol.TerminateSequenceResponseData;
import com.sun.xml.ws.rx.rm.runtime.ClientAckRequesterTask;
import com.sun.xml.ws.rx.rm.runtime.ClientDestinationDeliveryCallback;
import com.sun.xml.ws.rx.rm.runtime.ClientSourceDeliveryCallback;
import com.sun.xml.ws.rx.rm.runtime.JaxwsApplicationMessage;
import com.sun.xml.ws.rx.rm.runtime.RmConfiguration;
import com.sun.xml.ws.rx.rm.runtime.RuntimeContext;
import com.sun.xml.ws.rx.rm.runtime.Utilities;
import com.sun.xml.ws.rx.rm.runtime.delivery.DeliveryQueueBuilder;
import com.sun.xml.ws.rx.rm.runtime.delivery.PostmanPool;
import com.sun.xml.ws.rx.rm.runtime.sequence.DuplicateMessageRegistrationException;
import com.sun.xml.ws.rx.rm.runtime.sequence.DuplicateSequenceException;
import com.sun.xml.ws.rx.rm.runtime.sequence.Sequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceManager;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceManagerFactory;
import com.sun.xml.ws.rx.rm.runtime.sequence.UnknownSequenceException;
import com.sun.xml.ws.rx.util.Communicator;
import com.sun.xml.ws.security.secconv.SecureConversationInitiator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;

final class ClientTube
extends AbstractFilterTubeImpl {
    private static final Logger LOGGER = Logger.getLogger(ClientTube.class);
    private static final Lock INIT_LOCK = new ReentrantLock();
    private final RuntimeContext rc;
    private final WSEndpointReference rmSourceReference;
    private volatile VolatileReference<String> outboundSequenceId;

    ClientTube(ClientTube original, TubeCloner cloner) {
        super(original, cloner);
        this.rc = original.rc;
        this.rmSourceReference = original.rmSourceReference;
        this.outboundSequenceId = original.outboundSequenceId;
    }

    ClientTube(RmConfiguration configuration, Tube tubelineHead, ClientTubelineAssemblyContext context) throws RxRuntimeException {
        super(tubelineHead);
        this.outboundSequenceId = new VolatileReference<Object>(null);
        SecureConversationInitiator scInitiator = context.getImplementation(SecureConversationInitiator.class);
        if (scInitiator == null) {
            scInitiator = context.getScInitiator();
        }
        this.rc = RuntimeContext.getBuilder(configuration, new Communicator("rm-client-tube-communicator", context.getAddress(), this.next, scInitiator, configuration.getAddressingVersion(), configuration.getSoapVersion(), configuration.getRuntimeVersion().getJaxbContext(configuration.getAddressingVersion()))).build();
        DeliveryQueueBuilder outboundQueueBuilder = DeliveryQueueBuilder.getBuilder(this.rc.configuration, PostmanPool.INSTANCE.getPostman(), new ClientSourceDeliveryCallback(this.rc));
        DeliveryQueueBuilder inboundQueueBuilder = null;
        if (this.rc.configuration.requestResponseOperationsDetected()) {
            inboundQueueBuilder = DeliveryQueueBuilder.getBuilder(this.rc.configuration, PostmanPool.INSTANCE.getPostman(), new ClientDestinationDeliveryCallback(this.rc));
        }
        SequenceManager sequenceManager = SequenceManagerFactory.INSTANCE.createSequenceManager(false, context.getAddress().getURI().toString(), inboundQueueBuilder, outboundQueueBuilder, this.rc.configuration);
        this.rc.setSequenceManager(sequenceManager);
        McClientTube mcClientTube = context.getImplementation(McClientTube.class);
        if (configuration.isMakeConnectionSupportEnabled()) {
            assert (mcClientTube != null);
            this.rmSourceReference = mcClientTube.getWsmcAnonymousEndpointReference();
            mcClientTube.registerProtocolMessageHandler(ClientTube.createRmProtocolMessageHandler(this.rc));
        } else {
            this.rmSourceReference = configuration.getAddressingVersion().anonymousEpr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientTube copy(TubeCloner cloner) {
        LOGGER.entering();
        try {
            ClientTube clientTube = new ClientTube(this, cloner);
            return clientTube;
        }
        finally {
            LOGGER.exiting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NextAction processRequest(Packet request) {
        LOGGER.entering();
        try {
            try {
                INIT_LOCK.lock();
                if (this.outboundSequenceId.value == null) {
                    this.openRmSession(request);
                }
            }
            finally {
                INIT_LOCK.unlock();
            }
            assert (this.outboundSequenceId != null);
            JaxwsApplicationMessage message = new JaxwsApplicationMessage(request, request.getMessage().getID(this.rc.addressingVersion, this.rc.soapVersion));
            this.rc.sourceMessageHandler.registerMessage(message, (String)this.outboundSequenceId.value);
            Object object = message.getCorrelationId();
            synchronized (object) {
                try {
                    this.rc.suspendedFiberStorage.register(message.getCorrelationId(), Fiber.current());
                    this.rc.sourceMessageHandler.putToDeliveryQueue(message);
                    NextAction nextAction = super.doSuspend();
                    return nextAction;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (DuplicateMessageRegistrationException ex) {
                        LOGGER.logSevereException((Throwable)ex);
                        object = this.doThrow(ex);
                        return object;
                    }
                    catch (RxRuntimeException ex) {
                        LOGGER.logSevereException((Throwable)((Object)ex));
                        object = this.doThrow((Throwable)((Object)ex));
                        return object;
                    }
                }
            }
        }
        finally {
            LOGGER.exiting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NextAction processResponse(Packet repsonse) {
        LOGGER.entering();
        try {
            NextAction nextAction = super.processResponse(repsonse);
            return nextAction;
        }
        finally {
            LOGGER.exiting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NextAction processException(Throwable throwable) {
        LOGGER.entering();
        try {
            if (throwable instanceof RxRuntimeException) {
                this.closeRmSession();
            }
            NextAction nextAction = super.processException(throwable);
            return nextAction;
        }
        finally {
            LOGGER.exiting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preDestroy() {
        LOGGER.entering();
        try {
            this.closeRmSession();
        }
        finally {
            try {
                this.rc.close();
            }
            finally {
                super.preDestroy();
                LOGGER.exiting();
            }
        }
    }

    static final ProtocolMessageHandler createRmProtocolMessageHandler(final RuntimeContext rc) {
        final RmProtocolVersion rmVersion = rc.configuration.getRuntimeVersion().protocolVersion;
        return new ProtocolMessageHandler(){
            Collection<String> SUPPORTED_WSA_ACTIONS;
            {
                this.SUPPORTED_WSA_ACTIONS = Collections.unmodifiableCollection(Arrays.asList(rmVersion.ackRequestedAction, rmVersion.closeSequenceAction, rmVersion.sequenceAcknowledgementAction, rmVersion.terminateSequenceAction));
            }

            @Override
            public Collection<String> getSuportedWsaActions() {
                return this.SUPPORTED_WSA_ACTIONS;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void processProtocolMessage(Packet protocolMessagePacket) {
                if (rc.protocolHandler.containsProtocolMessage(protocolMessagePacket)) {
                    LOGGER.finer("Processing RM protocol response message.");
                    String wsaAction = rc.communicator.getWsaAction(protocolMessagePacket);
                    if (rmVersion.ackRequestedAction.equals(wsaAction) || rmVersion.sequenceAcknowledgementAction.equals(wsaAction)) {
                        AcknowledgementData ackData = rc.protocolHandler.getAcknowledgementData(protocolMessagePacket.getMessage());
                        rc.destinationMessageHandler.processAcknowledgements(ackData);
                        return;
                    } else if (rmVersion.closeSequenceAction.equals(wsaAction)) {
                        this.handleCloseSequenceAction(protocolMessagePacket);
                        return;
                    } else {
                        if (!rmVersion.terminateSequenceAction.equals(wsaAction)) throw (RxRuntimeException)((Object)LOGGER.logSevereException((Throwable)((Object)new RxRuntimeException(LocalizationMessages.WSRM_1134_UNSUPPORTED_PROTOCOL_MESSAGE(wsaAction)))));
                        this.handleTerminateSequenceAction(protocolMessagePacket);
                    }
                    return;
                } else {
                    LOGGER.severe(LocalizationMessages.WSRM_1120_RESPONSE_NOT_IDENTIFIED_AS_PROTOCOL_MESSAGE());
                }
            }

            private void handleCloseSequenceAction(Packet protocolMessagePacket) {
                CloseSequenceData requestData = rc.protocolHandler.toCloseSequenceData(protocolMessagePacket);
                rc.destinationMessageHandler.processAcknowledgements(requestData.getAcknowledgementData());
                try {
                    Sequence closedSequence = rc.sequenceManager().closeSequence(requestData.getSequenceId());
                    CloseSequenceResponseData.Builder responseBuilder = CloseSequenceResponseData.getBuilder(closedSequence.getId());
                    responseBuilder.acknowledgementData(rc.destinationMessageHandler.getAcknowledgementData(closedSequence.getId()));
                    closedSequence.clearAckRequestedFlag();
                    CloseSequenceResponseData responseData = responseBuilder.build();
                    Packet responsePacket = rc.protocolHandler.toPacket(responseData, protocolMessagePacket, true);
                    rc.communicator.sendAsync(responsePacket, null);
                }
                catch (UnknownSequenceException ex) {
                    LOGGER.warning(LocalizationMessages.WSRM_1124_NO_SUCH_SEQUENCE_ID_REGISTERED(requestData.getSequenceId()), (Throwable)((Object)ex));
                    rc.communicator.sendAsync(ex.toRequest(rc), null);
                }
            }

            private void handleTerminateSequenceAction(Packet protocolMessagePacket) {
                TerminateSequenceData requestData = rc.protocolHandler.toTerminateSequenceData(protocolMessagePacket);
                rc.destinationMessageHandler.processAcknowledgements(requestData.getAcknowledgementData());
                try {
                    rc.sequenceManager().terminateSequence(requestData.getSequenceId());
                    TerminateSequenceResponseData tsrData = TerminateSequenceResponseData.getBuilder(requestData.getSequenceId()).build();
                    Packet tsrPacket = rc.protocolHandler.toPacket(tsrData, protocolMessagePacket, true);
                    rc.communicator.sendAsync(tsrPacket, null);
                }
                catch (UnknownSequenceException ex) {
                    LOGGER.warning(LocalizationMessages.WSRM_1124_NO_SUCH_SEQUENCE_ID_REGISTERED(requestData.getSequenceId()), (Throwable)((Object)ex));
                    rc.communicator.sendAsync(ex.toRequest(rc), null);
                }
            }
        };
    }

    private void openRmSession(Packet request) {
        this.createSequences(request);
        ClientAckRequesterTask cart = new ClientAckRequesterTask(this.rc, (String)this.outboundSequenceId.value);
        MaintenanceTaskExecutor.INSTANCE.register(cart, cart.getExecutionDelay(), cart.getExecutionDelayTimeUnit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeRmSession() {
        if (this.outboundSequenceId.value == null || !this.rc.sequenceManager().isValid((String)this.outboundSequenceId.value)) {
            return;
        }
        String inboundSequenceId = this.rc.getBoundSequenceId((String)this.outboundSequenceId.value);
        try {
            if (inboundSequenceId != null) {
                this.waitForMissingAcknowledgements(inboundSequenceId, this.rc.configuration.getRmFeature().getCloseSequenceOperationTimeout());
            }
        }
        catch (RuntimeException ex) {
            LOGGER.warning(LocalizationMessages.WSRM_1103_RM_SEQUENCE_NOT_TERMINATED_NORMALLY(), (Throwable)ex);
        }
        try {
            this.sendCloseSequenceRequest();
        }
        catch (RuntimeException ex) {
            LOGGER.warning(LocalizationMessages.WSRM_1103_RM_SEQUENCE_NOT_TERMINATED_NORMALLY(), (Throwable)ex);
        }
        finally {
            this.closeSequences();
        }
        try {
            this.waitForMissingAcknowledgements((String)this.outboundSequenceId.value, this.rc.configuration.getRmFeature().getCloseSequenceOperationTimeout());
        }
        catch (RuntimeException ex) {
            LOGGER.warning(LocalizationMessages.WSRM_1103_RM_SEQUENCE_NOT_TERMINATED_NORMALLY(), (Throwable)ex);
        }
        try {
            this.terminateOutboundSequence();
        }
        catch (RuntimeException ex) {
            LOGGER.warning(LocalizationMessages.WSRM_1103_RM_SEQUENCE_NOT_TERMINATED_NORMALLY(), (Throwable)ex);
        }
        finally {
            this.rc.sequenceManager().terminateSequence((String)this.outboundSequenceId.value);
        }
        try {
            this.waitForInboundSequenceStateChange(inboundSequenceId, this.rc.configuration.getRmFeature().getCloseSequenceOperationTimeout(), Sequence.State.TERMINATING);
        }
        catch (RuntimeException ex) {
            LOGGER.warning(LocalizationMessages.WSRM_1103_RM_SEQUENCE_NOT_TERMINATED_NORMALLY(), (Throwable)ex);
        }
        finally {
            if (this.rc.sequenceManager().isValid(inboundSequenceId)) {
                try {
                    this.rc.sequenceManager().terminateSequence(inboundSequenceId);
                }
                catch (UnknownSequenceException unknownSequenceException) {}
            }
        }
    }

    private void createSequences(Packet appRequest) throws RxRuntimeException, DuplicateSequenceException {
        CreateSequenceData.Builder csBuilder = CreateSequenceData.getBuilder(this.rmSourceReference.toSpec());
        try {
            csBuilder.strType(this.rc.communicator.tryStartSecureConversation(appRequest));
        }
        catch (WSTrustException ex) {
            LOGGER.severe(LocalizationMessages.WSRM_1121_SECURE_CONVERSATION_INIT_FAILED(), (Throwable)ex);
        }
        if (this.rc.configuration.requestResponseOperationsDetected()) {
            csBuilder.offeredInboundSequenceId(this.rc.sequenceManager().generateSequenceUID());
        }
        String messageName = "CreateSequence";
        CreateSequenceData requestData = csBuilder.build();
        Packet request = this.rc.protocolHandler.toPacket(requestData, null);
        Packet response = this.sendSessionControlMessage("CreateSequence", request);
        CreateSequenceResponseData responseData = this.rc.protocolHandler.toCreateSequenceResponseData(this.verifyResponse(response, "CreateSequence", Level.SEVERE));
        if (requestData.getOfferedSequenceId() != null && responseData.getAcceptedSequenceAcksTo() == null) {
            csBuilder.offeredInboundSequenceId(this.rc.sequenceManager().generateSequenceUID());
            requestData = csBuilder.build();
            request = this.rc.protocolHandler.toPacket(requestData, null);
            response = this.sendSessionControlMessage("CreateSequence", request);
            responseData = this.rc.protocolHandler.toCreateSequenceResponseData(this.verifyResponse(response, "CreateSequence", Level.SEVERE));
        }
        if (responseData.getAcceptedSequenceAcksTo() != null && !this.rc.communicator.getDestinationAddress().getURI().toString().equals(new WSEndpointReference(responseData.getAcceptedSequenceAcksTo()).getAddress())) {
            throw new RxRuntimeException(LocalizationMessages.WSRM_1116_ACKS_TO_NOT_EQUAL_TO_ENDPOINT_DESTINATION(responseData.getAcceptedSequenceAcksTo().toString(), this.rc.communicator.getDestinationAddress()));
        }
        this.outboundSequenceId.value = this.rc.sequenceManager().createOutboundSequence(responseData.getSequenceId(), requestData.getStrType() != null ? requestData.getStrType().getId() : null, responseData.getDuration() == -1L ? -1L : responseData.getDuration() + this.rc.sequenceManager().currentTimeInMillis()).getId();
        if (requestData.getOfferedSequenceId() != null) {
            Sequence inboundSequence = this.rc.sequenceManager().createInboundSequence(requestData.getOfferedSequenceId(), requestData.getStrType() != null ? requestData.getStrType().getId() : null, responseData.getDuration() == -1L ? -1L : responseData.getDuration() + this.rc.sequenceManager().currentTimeInMillis());
            this.rc.sequenceManager().bindSequences((String)this.outboundSequenceId.value, inboundSequence.getId());
            this.rc.sequenceManager().bindSequences(inboundSequence.getId(), (String)this.outboundSequenceId.value);
        }
    }

    private boolean sendCloseSequenceRequest() {
        CloseSequenceData.Builder dataBuilder = CloseSequenceData.getBuilder((String)this.outboundSequenceId.value, this.rc.sequenceManager().getSequence((String)this.outboundSequenceId.value).getLastMessageNumber());
        dataBuilder.acknowledgementData(this.rc.sourceMessageHandler.getAcknowledgementData((String)this.outboundSequenceId.value));
        Packet request = this.rc.protocolHandler.toPacket(dataBuilder.build(), null);
        String messageName = "CloseSequence";
        Packet response = this.verifyResponse(this.sendSessionControlMessage("CloseSequence", request), "CloseSequence", Level.WARNING);
        String responseAction = this.rc.communicator.getWsaAction(response);
        if (this.rc.rmVersion.protocolVersion.closeSequenceResponseAction.equals(responseAction)) {
            CloseSequenceResponseData responseData = this.rc.protocolHandler.toCloseSequenceResponseData(response);
            this.rc.destinationMessageHandler.processAcknowledgements(responseData.getAcknowledgementData());
            if (!((String)this.outboundSequenceId.value).equals(responseData.getSequenceId())) {
                LOGGER.warning(LocalizationMessages.WSRM_1119_UNEXPECTED_SEQUENCE_ID_IN_CLOSE_SR(responseData.getSequenceId(), this.outboundSequenceId));
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void closeSequences() {
        boundSequenceId = this.rc.getBoundSequenceId((String)this.outboundSequenceId.value);
        try {
            this.rc.sequenceManager().closeSequence((String)this.outboundSequenceId.value);
        }
        finally {
            if (boundSequenceId != null) {
                try {
                    this.waitForInboundSequenceStateChange(boundSequenceId, this.rc.configuration.getRmFeature().getCloseSequenceOperationTimeout(), Sequence.State.CLOSED);
                }
                catch (RuntimeException ex) {
                    try {
                        ClientTube.LOGGER.warning(LocalizationMessages.WSRM_1103_RM_SEQUENCE_NOT_TERMINATED_NORMALLY(), (Throwable)ex);
                        ** if (!this.rc.sequenceManager().isValid((String)boundSequenceId)) goto lbl-1000
                    }
                    catch (Throwable var3_5) {
                        if (this.rc.sequenceManager().isValid(boundSequenceId)) {
                            try {
                                this.rc.sequenceManager().closeSequence(boundSequenceId);
                            }
                            catch (UnknownSequenceException ignored) {}
                        }
                        throw var3_5;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            this.rc.sequenceManager().closeSequence(boundSequenceId);
                        }
                        catch (UnknownSequenceException var2_4) {}
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                }
                if (this.rc.sequenceManager().isValid(boundSequenceId)) {
                    try {
                        this.rc.sequenceManager().closeSequence(boundSequenceId);
                    }
                    catch (UnknownSequenceException ignored) {}
                }
            }
        }
    }

    private void terminateOutboundSequence() {
        TerminateSequenceData.Builder dataBuilder = TerminateSequenceData.getBuilder((String)this.outboundSequenceId.value, this.rc.sequenceManager().getSequence((String)this.outboundSequenceId.value).getLastMessageNumber());
        dataBuilder.acknowledgementData(this.rc.sourceMessageHandler.getAcknowledgementData((String)this.outboundSequenceId.value));
        Packet request = this.rc.protocolHandler.toPacket(dataBuilder.build(), null);
        String messageName = "TerminateSequence";
        Packet response = this.verifyResponse(this.sendSessionControlMessage("TerminateSequence", request), "TerminateSequence", Level.FINE);
        if (response.getMessage() != null) {
            String responseAction = this.rc.communicator.getWsaAction(response);
            if (this.rc.rmVersion.protocolVersion.terminateSequenceResponseAction.equals(responseAction)) {
                TerminateSequenceResponseData responseData = this.rc.protocolHandler.toTerminateSequenceResponseData(response);
                this.rc.destinationMessageHandler.processAcknowledgements(responseData.getAcknowledgementData());
                if (!((String)this.outboundSequenceId.value).equals(responseData.getSequenceId())) {
                    LOGGER.warning(LocalizationMessages.WSRM_1117_UNEXPECTED_SEQUENCE_ID_IN_TERMINATE_SR(responseData.getSequenceId(), this.outboundSequenceId.value));
                }
            } else if (this.rc.rmVersion.protocolVersion.terminateSequenceAction.equals(responseAction)) {
                TerminateSequenceData responseData = this.rc.protocolHandler.toTerminateSequenceData(response);
                this.rc.destinationMessageHandler.processAcknowledgements(responseData.getAcknowledgementData());
                if (responseData.getSequenceId() != null) {
                    String expectedInboundSequenceId = this.rc.getBoundSequenceId((String)this.outboundSequenceId.value);
                    if (!ClientTube.areEqual(expectedInboundSequenceId, responseData.getSequenceId())) {
                        LOGGER.warning(LocalizationMessages.WSRM_1117_UNEXPECTED_SEQUENCE_ID_IN_TERMINATE_SR(responseData.getSequenceId(), expectedInboundSequenceId));
                    }
                    try {
                        this.rc.sequenceManager().terminateSequence(responseData.getSequenceId());
                    }
                    catch (UnknownSequenceException ex) {
                        LOGGER.warning(LocalizationMessages.WSRM_1124_NO_SUCH_SEQUENCE_ID_REGISTERED(responseData.getSequenceId()), (Throwable)((Object)ex));
                        this.rc.communicator.sendAsync(ex.toRequest(this.rc), null);
                    }
                }
            }
        }
    }

    private Packet sendSessionControlMessage(String messageName, Packet request) throws RxRuntimeException {
        int attempt = 0;
        Packet response = null;
        while (true) {
            if ((long)attempt > this.rc.configuration.getRmFeature().getMaxRmSessionControlMessageResendAttempts()) {
                throw new RxRuntimeException(LocalizationMessages.WSRM_1128_MAX_RM_SESSION_CONTROL_MESSAGE_RESEND_ATTEMPTS_REACHED(messageName));
            }
            try {
                response = this.rc.communicator.send(request.copy(true));
            }
            catch (RuntimeException ex) {
                if (!Utilities.isResendPossible(ex)) {
                    throw new RxRuntimeException(LocalizationMessages.WSRM_1106_SENDING_RM_SESSION_CONTROL_MESSAGE_FAILED(messageName), ex);
                }
                LOGGER.warning(LocalizationMessages.WSRM_1106_SENDING_RM_SESSION_CONTROL_MESSAGE_FAILED(messageName), (Throwable)ex);
                ++attempt;
                continue;
            }
            break;
        }
        return response;
    }

    private static boolean areEqual(String s1, String s2) {
        if (s1 == null) {
            return s2 == null;
        }
        return s1.equals(s2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForMissingAcknowledgements(final String sequenceId, long timeoutInMillis) {
        final CountDownLatch doneSignal = new CountDownLatch(1);
        ScheduledFuture<?> taskHandle = this.rc.scheduledTaskManager.startTask(new Runnable(){

            public void run() {
                try {
                    if (!ClientTube.this.rc.sequenceManager().getSequence(sequenceId).hasUnacknowledgedMessages()) {
                        doneSignal.countDown();
                    }
                }
                catch (UnknownSequenceException ex) {
                    LOGGER.severe(LocalizationMessages.WSRM_1111_WAITING_FOR_SEQ_ACKS_UNEXPECTED_EXCEPTION(sequenceId), (Throwable)((Object)ex));
                    doneSignal.countDown();
                }
            }
        }, 10L, 10L);
        try {
            if (timeoutInMillis > 0L) {
                boolean waitResult = doneSignal.await(timeoutInMillis, TimeUnit.MILLISECONDS);
                if (!waitResult) {
                    LOGGER.info(LocalizationMessages.WSRM_1112_WAITING_FOR_SEQ_ACKS_TIMED_OUT(sequenceId, timeoutInMillis));
                }
            } else {
                doneSignal.await();
            }
        }
        catch (InterruptedException ex) {
            LOGGER.fine(LocalizationMessages.WSRM_1113_WAITING_FOR_SEQ_ACKS_INTERRUPTED(sequenceId), (Throwable)ex);
        }
        finally {
            taskHandle.cancel(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForInboundSequenceStateChange(final String sequenceId, long timeoutInMillis, final Sequence.State waitForState) {
        final CountDownLatch stateChangedSignal = new CountDownLatch(1);
        ScheduledFuture<?> taskHandle = this.rc.scheduledTaskManager.startTask(new Runnable(){

            public void run() {
                try {
                    if (ClientTube.this.rc.sequenceManager().getSequence(sequenceId).getState() == waitForState) {
                        stateChangedSignal.countDown();
                    }
                }
                catch (UnknownSequenceException ex) {
                    LOGGER.fine(LocalizationMessages.WSRM_1124_NO_SUCH_SEQUENCE_ID_REGISTERED(sequenceId), (Throwable)((Object)ex));
                    stateChangedSignal.countDown();
                }
            }
        }, 10L, 10L);
        try {
            if (timeoutInMillis > 0L) {
                boolean waitResult = stateChangedSignal.await(timeoutInMillis, TimeUnit.MILLISECONDS);
                if (!waitResult) {
                    LOGGER.info(LocalizationMessages.WSRM_1157_WAITING_FOR_SEQ_STATE_CHANGE_TIMED_OUT(sequenceId, (Object)waitForState, timeoutInMillis));
                }
            } else {
                stateChangedSignal.await();
            }
        }
        catch (InterruptedException ex) {
            LOGGER.fine(LocalizationMessages.WSRM_1158_WAITING_FOR_SEQ_STATE_CHANGE_INTERRUPTED(sequenceId, (Object)waitForState), (Throwable)ex);
        }
        finally {
            taskHandle.cancel(true);
        }
    }

    private Packet verifyResponse(Packet response, String requestId, Level logLevel) throws RxRuntimeException {
        String logMessage = null;
        if (response == null || response.getMessage() == null) {
            logMessage = LocalizationMessages.WSRM_1114_NULL_RESPONSE_ON_PROTOCOL_MESSAGE_REQUEST(requestId);
        } else {
            String responseAction = this.rc.communicator.getWsaAction(response);
            if (response.getMessage().isFault() || this.rc.rmVersion.protocolVersion.isFault(responseAction)) {
                logMessage = LocalizationMessages.WSRM_1115_PROTOCOL_MESSAGE_REQUEST_REFUSED(requestId);
            }
        }
        if (logMessage != null) {
            if (logLevel == Level.SEVERE) {
                throw (RxRuntimeException)((Object)LOGGER.logSevereException((Throwable)((Object)new RxRuntimeException(logMessage))));
            }
            LOGGER.log(logLevel, logMessage);
        }
        return response;
    }
}

