/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.wom.impl.parser.handler;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.jvnet.wom.api.WSDLEntity;
import org.jvnet.wom.api.parser.WSDLEventReceiver;
import org.jvnet.wom.api.parser.WSDLEventSource;
import org.jvnet.wom.api.parser.WSDLExtensionHandler;
import org.jvnet.wom.impl.parser.WSDLContentHandlerEx;
import org.jvnet.wom.impl.parser.WSDLDocumentParser;
import org.jvnet.wom.impl.parser.handler.Messages;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class AbstractHandler
implements WSDLEventReceiver {
    protected static final String WSDL_NS = "http://schemas.xmlsoap.org/wsdl/";
    protected final AbstractHandler _parent;
    protected final WSDLEventSource _source;
    protected final int _cookie;
    private WSDLDocumentParser docParser;
    protected List<WSDLExtensionHandler> handlers = new ArrayList<WSDLExtensionHandler>();

    protected AbstractHandler(WSDLEventSource source, AbstractHandler parent, int parentCookie) {
        this._parent = parent;
        this._source = source;
        this._cookie = parentCookie;
    }

    protected abstract WSDLContentHandlerEx getRuntime();

    protected abstract void onChildCompleted(Object var1, int var2, boolean var3) throws SAXException;

    public void spawnChildFromEnterElement(WSDLEventReceiver child, String uri, String localname, String qname, Attributes atts) throws SAXException {
        int id = this._source.replace(this, child);
        this._source.sendEnterElement(id, uri, localname, qname, atts);
    }

    public void spawnChildFromEnterAttribute(WSDLEventReceiver child, String uri, String localname, String qname) throws SAXException {
        int id = this._source.replace(this, child);
        this._source.sendEnterAttribute(id, uri, localname, qname);
    }

    public void spawnChildFromLeaveElement(WSDLEventReceiver child, String uri, String localname, String qname) throws SAXException {
        int id = this._source.replace(this, child);
        this._source.sendLeaveElement(id, uri, localname, qname);
    }

    public void spawnChildFromLeaveAttribute(WSDLEventReceiver child, String uri, String localname, String qname) throws SAXException {
        int id = this._source.replace(this, child);
        this._source.sendLeaveAttribute(id, uri, localname, qname);
    }

    public void spawnChildFromText(WSDLEventReceiver child, String value) throws SAXException {
        int id = this._source.replace(this, child);
        this._source.sendText(id, value);
    }

    public void revertToParentFromEnterElement(Object result, int cookie, String uri, String local, String qname, Attributes atts) throws SAXException {
        int id = this._source.replace(this, this._parent);
        this._parent.onChildCompleted(result, cookie, true);
        this._source.sendEnterElement(id, uri, local, qname, atts);
    }

    public void revertToParentFromLeaveElement(Object result, int cookie, String uri, String local, String qname) throws SAXException {
        if (uri == "\u0000" && uri == local && uri == qname && this._parent == null) {
            return;
        }
        int id = this._source.replace(this, this._parent);
        this._parent.onChildCompleted(result, cookie, true);
        this._source.sendLeaveElement(id, uri, local, qname);
    }

    public void revertToParentFromEnterAttribute(Object result, int cookie, String uri, String local, String qname) throws SAXException {
        int id = this._source.replace(this, this._parent);
        this._parent.onChildCompleted(result, cookie, true);
        this._source.sendEnterAttribute(id, uri, local, qname);
    }

    public void revertToParentFromLeaveAttribute(Object result, int cookie, String uri, String local, String qname) throws SAXException {
        int id = this._source.replace(this, this._parent);
        this._parent.onChildCompleted(result, cookie, true);
        this._source.sendLeaveAttribute(id, uri, local, qname);
    }

    public void revertToParentFromText(Object result, int cookie, String text) throws SAXException {
        int id = this._source.replace(this, this._parent);
        this._parent.onChildCompleted(result, cookie, true);
        this._source.sendText(id, text);
    }

    protected void validateAttribute(ErrorHandler handler, Attributes attributes, int ... understoodAtts) throws SAXException {
        for (int i = 0; i < understoodAtts.length; ++i) {
            if (understoodAtts[i] == 1) continue;
            handler.warning(new SAXParseException(Messages.format("wsdl.unknownAttribute", attributes.getQName(i)), this.getRuntime().getLocator()));
        }
    }

    public void enterElement(String uri, String localName, String qname, Attributes atts) throws SAXException {
        boolean noCh = true;
        if (WSDL_NS.equals(uri) && localName.equals("documentation")) {
            this.getRuntime().onEnterElementConsumed(uri, localName, qname, atts);
            this.docParser = new WSDLDocumentParser();
            this.getRuntime().redirectSubtree(this.docParser, uri, localName, qname);
        } else {
            this.getRuntime().onEnterElementConsumed(uri, localName, qname, atts);
            for (WSDLExtensionHandler extensionHandler : this.getRuntime().parser.getWSDLExtensionHandlers()) {
                ContentHandler ch = extensionHandler.getContentHandlerFor(uri, localName);
                if (ch == null) continue;
                this.getRuntime().redirectSubtree(ch, uri, localName, qname);
                noCh = false;
                this.handlers.add(extensionHandler);
            }
            if (noCh) {
                this.getRuntime().getErrorHandler().warning(new SAXParseException(Messages.format("wsdl.unknownElement", new QName(uri, localName)), this.getRuntime().getLocator()));
            }
        }
    }

    protected String getWSDLDocumentation() {
        if (this.docParser == null) {
            return "";
        }
        return this.docParser.getDocumentation();
    }

    public void leaveElement(String uri, String localName, String qname) throws SAXException {
    }

    public void text(String value) throws SAXException {
    }

    public void enterAttribute(String uri, String localName, String qname) throws SAXException {
    }

    public void leaveAttribute(String uri, String localName, String qname) throws SAXException {
    }

    void endProcessingExtentionElement(WSDLEntity entity) {
        for (WSDLExtensionHandler handler : this.handlers) {
            entity.addExtension(handler.getExtensions());
        }
    }

    public void unexpectedEnterElement(String qname) throws SAXException {
        this.getRuntime().unexpectedX('<' + qname + '>');
    }

    public void unexpectedLeaveElement(String qname) throws SAXException {
        this.getRuntime().unexpectedX("</" + qname + '>');
    }

    public void unexpectedEnterAttribute(String qname) throws SAXException {
        this.getRuntime().unexpectedX('@' + qname);
    }

    public void unexpectedLeaveAttribute(String qname) throws SAXException {
        this.getRuntime().unexpectedX("/@" + qname);
    }
}

