/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime.sequence.persistent;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.rx.rm.runtime.ApplicationMessage;
import com.sun.xml.ws.rx.rm.runtime.JaxwsApplicationMessage;
import com.sun.xml.ws.rx.rm.runtime.sequence.DuplicateMessageRegistrationException;
import com.sun.xml.ws.rx.rm.runtime.sequence.DuplicateSequenceException;
import com.sun.xml.ws.rx.rm.runtime.sequence.Sequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceData;
import com.sun.xml.ws.rx.rm.runtime.sequence.persistent.PersistenceException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PersistentSequenceData
implements SequenceData {
    private static final Logger LOGGER = Logger.getLogger(PersistentSequenceData.class);
    private final String endpointUid;
    private final String sequenceId;
    private final SequenceType type;
    private final String boundSecurityTokenReferenceId;
    private final long expirationTime;
    private final FieldInfo fState = new FieldInfo("STATUS", 5);
    private final FieldInfo fAckRequestedFlag = new FieldInfo("ACK_REQUESTED_FLAG", 1);
    private final FieldInfo fLastMessageId = new FieldInfo("LAST_MESSAGE_ID", -5);
    private final FieldInfo fLastActivityTime = new FieldInfo("LAST_ACTIVITY_TIME", -5);
    private final FieldInfo fLastAcknowledgementRequestTime = new FieldInfo("LAST_ACK_REQUEST_TIME", -5);
    private final Connection sqlConnection;
    private final ResultSet sequenceDataResultSet;

    PersistentSequenceData(Connection sqlConnection, String endpointUid, String sequenceId, SequenceType type, String securityContextTokenId, long expirationTime, ResultSet dataResultSet) {
        this.sqlConnection = sqlConnection;
        this.endpointUid = endpointUid;
        this.sequenceId = sequenceId;
        this.type = type;
        this.boundSecurityTokenReferenceId = securityContextTokenId;
        this.expirationTime = expirationTime;
        this.sequenceDataResultSet = dataResultSet;
    }

    static PersistentSequenceData newInstance(Connection sqlConnection, String enpointUid, String sequenceId, SequenceType type, String securityContextTokenId, long expirationTime, Sequence.State state, boolean ackRequestedFlag, long lastMessageId, long lastActivityTime, long lastAcknowledgementRequestTime) throws DuplicateSequenceException {
        try {
            PreparedStatement ps = sqlConnection.prepareStatement("INSERT INTO RM.RM_SEQUENCES (ENDPOINT_UID, ID, TYPE, EXP_TIME, STR_ID, STATUS, ACK_REQUESTED_FLAG, LAST_MESSAGE_ID, LAST_ACTIVITY_TIME, LAST_ACK_REQUEST_TIME) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            int i = 0;
            ps.setString(++i, enpointUid);
            ps.setString(++i, sequenceId);
            ps.setString(++i, type.id);
            ps.setLong(++i, expirationTime);
            ps.setString(++i, securityContextTokenId);
            ps.setInt(++i, state.asInt());
            ps.setString(++i, Boolean.toString(ackRequestedFlag));
            ps.setLong(++i, lastMessageId);
            ps.setLong(++i, lastActivityTime);
            ps.setLong(++i, lastAcknowledgementRequestTime);
            if (ps.executeUpdate() != 1) {
                throw (PersistenceException)((Object)LOGGER.logSevereException((Throwable)((Object)new PersistenceException(String.format("Unable to insert sequence data for %s sequence with id = [ %s ]", new Object[]{type, sequenceId})))));
            }
        }
        catch (SQLException ex) {
            throw (PersistenceException)((Object)LOGGER.logSevereException((Throwable)((Object)new PersistenceException(String.format("An exception occured while storing new sequence data for %s sequence with id = [ %s ]", new Object[]{type, sequenceId}), ex))));
        }
        return PersistentSequenceData.loadInstance(sqlConnection, enpointUid, sequenceId);
    }

    static PersistentSequenceData loadInstance(Connection sqlConnection, String endpointUid, String sequenceId) {
        PersistentSequenceData data = null;
        try {
            PreparedStatement ps = sqlConnection.prepareStatement("SELECT TYPE, EXP_TIME, BOUND_ID, STR_ID, STATUS, ACK_REQUESTED_FLAG, LAST_MESSAGE_ID, LAST_ACTIVITY_TIME, LAST_ACK_REQUEST_TIME FROM RM_SEQUENCES WHERE ENDPOINT_UID=? AND ID=?");
            ps.setString(1, endpointUid);
            ps.setString(2, sequenceId);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) {
                return null;
            }
            if (!rs.isFirst() && !rs.isLast()) {
                throw (PersistenceException)((Object)LOGGER.logSevereException((Throwable)((Object)new PersistenceException(String.format("Duplicate sequence records detected for a sequence with id [ %s ]", sequenceId)))));
            }
            data = new PersistentSequenceData(sqlConnection, endpointUid, sequenceId, SequenceType.fromId(rs.getString("TYPE")), rs.getString("STR_ID"), rs.getLong("EXP_TIME"), rs);
        }
        catch (SQLException ex) {
            throw (PersistenceException)((Object)LOGGER.logSevereException((Throwable)((Object)new PersistenceException(String.format("An exception occured while loading sequence data for a sequence with id = [ %s ]", sequenceId), ex))));
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PersistentSequenceData remove(Connection sqlConnection, PersistentSequenceData data) {
        try {
            data.lockRead();
            PersistentSequenceData.remove(sqlConnection, data.endpointUid, data.sequenceId);
        }
        finally {
            data.unlockRead();
        }
        return data;
    }

    static void remove(Connection sqlConnection, String endpointUid, String sequenceId) {
        try {
            PreparedStatement ps = sqlConnection.prepareStatement("DELETE FROM RM_SEQUENCES WHERE ENDPOINT_UID=? AND ID=?");
            ps.setString(1, endpointUid);
            ps.setString(2, sequenceId);
            int rowsAffected = ps.executeUpdate();
            if (rowsAffected != 1) {
                throw (PersistenceException)((Object)LOGGER.logException((Throwable)((Object)new PersistenceException(String.format("Removing sequence with id = [ %s ] failed: Expected deleted rows: 1, Actual: %d", sequenceId, rowsAffected))), Level.WARNING));
            }
        }
        catch (SQLException ex) {
            throw (PersistenceException)((Object)LOGGER.logSevereException((Throwable)((Object)new PersistenceException(String.format("An exception occured while deleting sequence data for a sequence with id = [ %s ]", sequenceId), ex))));
        }
    }

    static void bind(Connection sqlConnection, String endpointUid, String referenceSequenceId, String boundSequenceId) {
    }

    @Override
    public void lockRead() {
    }

    @Override
    public void unlockRead() {
    }

    @Override
    public void lockWrite() {
    }

    @Override
    public void unlockWrite() {
        try {
            this.sequenceDataResultSet.updateRow();
        }
        catch (SQLException ex) {
            LOGGER.logSevereException((Throwable)((Object)new PersistenceException("Unable to update database with new data.", ex)));
        }
    }

    @Override
    public String getSequenceId() {
        return this.sequenceId;
    }

    public SequenceType getType() {
        return this.type;
    }

    @Override
    public String getBoundSecurityTokenReferenceId() {
        return this.boundSecurityTokenReferenceId;
    }

    @Override
    public long getExpirationTime() {
        return this.expirationTime;
    }

    @Override
    public long getLastMessageNumber() {
        try {
            return this.sequenceDataResultSet.getLong(this.fLastMessageId.columnName);
        }
        catch (SQLException ex) {
            throw (PersistenceException)((Object)LOGGER.logSevereException((Throwable)((Object)new PersistenceException("Unable to retrieve sequence data", ex))));
        }
    }

    @Override
    public void setLastMessageNumber(long newValue) {
        try {
            this.sequenceDataResultSet.updateLong(this.fLastMessageId.columnName, newValue);
        }
        catch (SQLException ex) {
            throw (PersistenceException)((Object)LOGGER.logSevereException((Throwable)((Object)new PersistenceException("Unable to update sequence data", ex))));
        }
    }

    @Override
    public Sequence.State getState() {
        try {
            return Sequence.State.asState(this.sequenceDataResultSet.getInt(this.fState.columnName));
        }
        catch (SQLException ex) {
            throw (PersistenceException)((Object)LOGGER.logSevereException((Throwable)((Object)new PersistenceException("Unable to retrieve sequence data", ex))));
        }
    }

    @Override
    public void setState(Sequence.State newValue) {
        try {
            this.sequenceDataResultSet.updateInt(this.fState.columnName, newValue.asInt());
        }
        catch (SQLException ex) {
            throw (PersistenceException)((Object)LOGGER.logSevereException((Throwable)((Object)new PersistenceException("Unable to update sequence data", ex))));
        }
    }

    @Override
    public boolean getAckRequestedFlag() {
        try {
            return this.sequenceDataResultSet.getBoolean(this.fAckRequestedFlag.columnName);
        }
        catch (SQLException ex) {
            throw (PersistenceException)((Object)LOGGER.logSevereException((Throwable)((Object)new PersistenceException("Unable to retrieve sequence data", ex))));
        }
    }

    @Override
    public void setAckRequestedFlag(boolean newValue) {
        try {
            this.sequenceDataResultSet.updateBoolean(this.fAckRequestedFlag.columnName, newValue);
        }
        catch (SQLException ex) {
            throw (PersistenceException)((Object)LOGGER.logSevereException((Throwable)((Object)new PersistenceException("Unable to update sequence data", ex))));
        }
    }

    @Override
    public long getLastAcknowledgementRequestTime() {
        try {
            return this.sequenceDataResultSet.getLong(this.fLastAcknowledgementRequestTime.columnName);
        }
        catch (SQLException ex) {
            throw (PersistenceException)((Object)LOGGER.logSevereException((Throwable)((Object)new PersistenceException("Unable to retrieve sequence data", ex))));
        }
    }

    @Override
    public void setLastAcknowledgementRequestTime(long newValue) {
        try {
            this.sequenceDataResultSet.updateLong(this.fLastAcknowledgementRequestTime.columnName, newValue);
        }
        catch (SQLException ex) {
            throw (PersistenceException)((Object)LOGGER.logSevereException((Throwable)((Object)new PersistenceException("Unable to update sequence data", ex))));
        }
    }

    @Override
    public long getLastActivityTime() {
        try {
            return this.sequenceDataResultSet.getLong(this.fLastActivityTime.columnName);
        }
        catch (SQLException ex) {
            throw (PersistenceException)((Object)LOGGER.logSevereException((Throwable)((Object)new PersistenceException("Unable to retrieve sequence data", ex))));
        }
    }

    @Override
    public void setLastActivityTime(long newValue) {
        try {
            this.sequenceDataResultSet.updateLong(this.fLastActivityTime.columnName, newValue);
        }
        catch (SQLException ex) {
            throw (PersistenceException)((Object)LOGGER.logSevereException((Throwable)((Object)new PersistenceException("Unable to update sequence data", ex))));
        }
    }

    @Override
    public void registerUnackedMessageNumber(long messageNumber, boolean received) throws DuplicateMessageRegistrationException {
        try {
            PreparedStatement ps = this.sqlConnection.prepareStatement("INSERT INTO RM_UNACKED_MESSAGES (ENDPOINT_UID, SEQ_ID, MSG_NUMBER, IS_RECEIVED) VALUES (?, ?, ?, ?)");
            ps.setString(1, this.endpointUid);
            ps.setString(2, this.sequenceId);
            ps.setLong(3, messageNumber);
            ps.setString(4, Boolean.toString(received));
            if (ps.executeUpdate() != 1) {
                throw (PersistenceException)((Object)LOGGER.logSevereException((Throwable)((Object)new PersistenceException(String.format("Unable to insert new unacked message registration for %s sequence with id = [ %s ] and message number [ %d ]", new Object[]{this.type, this.sequenceId, messageNumber})))));
            }
        }
        catch (SQLException ex) {
            LOGGER.logSevereException((Throwable)ex);
        }
    }

    @Override
    public void markAsAcknowledged(long messageNumber) {
        try {
            PreparedStatement ps = this.sqlConnection.prepareStatement("DELETE FROM RM_UNACKED_MESSAGES WHERE ENDPOINT_UID=? AND SEQ_ID=? AND MSG_NUMBER=?");
            ps.setString(1, this.endpointUid);
            ps.setString(2, this.sequenceId);
            ps.setLong(4, messageNumber);
            int rowsAffected = ps.executeUpdate();
            if (rowsAffected != 1) {
                throw (PersistenceException)((Object)LOGGER.logSevereException((Throwable)((Object)new PersistenceException(String.format("Message acknowledgement failed for %s sequence with id = [ %s ] and message number [ %d ]: Expected deleted rows: 1, Actual: %d", new Object[]{this.type, this.sequenceId, messageNumber, rowsAffected})))));
            }
        }
        catch (SQLException ex) {
            LOGGER.logSevereException((Throwable)ex);
        }
    }

    @Override
    public Collection<Long> getUnackedMessageNumbers() {
        try {
            PreparedStatement ps = this.sqlConnection.prepareStatement("SELECT MSG_NUMBER FROM RM_UNACKED_MESSAGES WHERE ENDPOINT_UID=? AND SEQ_ID=?");
            ps.setString(1, this.endpointUid);
            ps.setString(2, this.sequenceId);
            ResultSet rs = ps.executeQuery();
            LinkedList<Long> result = new LinkedList<Long>();
            while (rs.next()) {
                result.add(rs.getLong("MSG_NUMBER"));
            }
            return result;
        }
        catch (SQLException ex) {
            throw (PersistenceException)((Object)LOGGER.logSevereException((Throwable)((Object)new PersistenceException(String.format("Unable to load list of unacked message registration for %s sequence with id = [ %s ]", new Object[]{this.type, this.sequenceId}), ex))));
        }
    }

    @Override
    public void attachMessageToUnackedMessageNumber(ApplicationMessage message) {
        ByteArrayInputStream bais = null;
        try {
            PreparedStatement ps = this.sqlConnection.prepareStatement("UPDATE RM_UNACKED_MESSAGES SET IS_RECEIVED=?, CORRELATION_ID=?, NEXT_RESEND_COUNT=?, MSG_DATA=? WHERE ENDPOINT_UID=? AND SEQ_ID=? AND MSG_NUMBER=?");
            int i = 0;
            ps.setString(++i, Boolean.TRUE.toString());
            ps.setString(++i, message.getCorrelationId());
            ps.setLong(++i, message.getNextResendCount());
            byte[] msgData = message.toBytes();
            bais = new ByteArrayInputStream(msgData);
            ps.setBinaryStream(++i, (InputStream)bais, msgData.length);
            ps.setString(++i, this.endpointUid);
            ps.setString(++i, this.sequenceId);
            ps.setLong(++i, message.getMessageNumber());
            int rowsAffected = ps.executeUpdate();
            if (rowsAffected != 1) {
                throw (PersistenceException)((Object)LOGGER.logSevereException((Throwable)((Object)new PersistenceException(String.format("Storing message data in an unacked message registration for %s sequence with id = [ %s ] and message number [ %d ] has failed: Expected updated rows: 1, Actual: %d", new Object[]{this.type, this.sequenceId, message.getMessageNumber(), rowsAffected})))));
            }
        }
        catch (SQLException ex) {
            throw (PersistenceException)((Object)LOGGER.logSevereException((Throwable)((Object)new PersistenceException(String.format("Unable to store message data in an unacked message registration for %s sequence with id = [ %s ] and message number [ %d ]", new Object[]{this.type, this.sequenceId, message.getMessageNumber()}), ex))));
        }
        finally {
            if (bais != null) {
                try {
                    bais.close();
                }
                catch (IOException ex) {
                    LOGGER.warning("Error closing ByteArrayOutputStream after message bytes were sent to DB", (Throwable)ex);
                }
            }
        }
    }

    @Override
    public ApplicationMessage retrieveMessage(String correlationId) {
        ByteArrayInputStream bais = null;
        try {
            PreparedStatement ps = this.sqlConnection.prepareStatement("SELECT MSG_NUMBER, NEXT_RESEND_COUNT, MSG_DATA FROM RM_UNACKED_MESSAGES WHERE ENDPOINT_UID=? AND SEQ_ID=? AND CORRELATION_ID=?");
            ps.setString(1, this.endpointUid);
            ps.setString(2, this.sequenceId);
            ps.setString(3, correlationId);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) {
                ApplicationMessage applicationMessage = null;
                return applicationMessage;
            }
            if (!rs.isFirst() && !rs.isLast()) {
                throw (PersistenceException)((Object)LOGGER.logSevereException((Throwable)((Object)new PersistenceException(String.format("Duplicate records detected for unacked message registration on %s sequence with id = [ %s ] and correlation id [ %d ]", new Object[]{this.type, this.sequenceId, correlationId})))));
            }
            JaxwsApplicationMessage jaxwsApplicationMessage = JaxwsApplicationMessage.newInstance(rs.getBlob("MSG_DATA").getBinaryStream(), rs.getInt("NEXT_RESEND_COUNT"), correlationId, this.sequenceId, rs.getLong("MSG_NUMBER"));
            return jaxwsApplicationMessage;
        }
        catch (SQLException ex) {
            throw (PersistenceException)((Object)LOGGER.logSevereException((Throwable)((Object)new PersistenceException(String.format("Unable to load message data from an unacked message registration for %s sequence with id = [ %s ] and correlation id [ %d ]", new Object[]{this.type, this.sequenceId, correlationId}), ex))));
        }
        finally {
            if (bais != null) {
                try {
                    bais.close();
                }
                catch (IOException ex) {
                    LOGGER.warning("Error closing ByteArrayOutputStream after message bytes were sent to DB", (Throwable)ex);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum SequenceType {
        Inbound("I"),
        Outbound("O");

        private final String id;

        private SequenceType(String id) {
            this.id = id;
        }

        private static SequenceType fromId(String id) {
            for (SequenceType type : SequenceType.values()) {
                if (!type.id.equals(id)) continue;
                return type;
            }
            return null;
        }
    }

    private static final class FieldInfo {
        final String columnName;
        final int sqlType;

        public FieldInfo(String columnName, int sqlType) {
            this.columnName = columnName;
            this.sqlType = sqlType;
        }
    }
}

