/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime.sequence.invm;

import com.sun.xml.ws.rx.rm.runtime.ApplicationMessage;
import com.sun.xml.ws.rx.rm.runtime.sequence.DuplicateMessageRegistrationException;
import com.sun.xml.ws.rx.rm.runtime.sequence.IllegalMessageIdentifierException;
import com.sun.xml.ws.rx.rm.runtime.sequence.Sequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class InVmSequenceData
implements SequenceData {
    private final ReadWriteLock dataLock = new ReentrantReadWriteLock();
    private final String sequenceId;
    private final String boundSecurityTokenReferenceId;
    private final long expirationTime;
    private volatile Sequence.State state;
    private volatile boolean ackRequestedFlag;
    private volatile long lastMessageNumber;
    private volatile long lastActivityTime;
    private volatile long lastAcknowledgementRequestTime;
    private final Collection<Long> allUnackedMessageNumbers;
    private final Collection<Long> receivedUnackedMessageNumbers;
    private final Map<String, ApplicationMessage> weakMessageStorage;
    private final Map<Long, String> weakUnackedNumberToCorrelationIdMap;

    public InVmSequenceData(String sequenceId, String securityContextTokenId, long expirationTime, long lastMessageId, long lastActivityTime) {
        this(sequenceId, securityContextTokenId, expirationTime, Sequence.State.CREATED, false, lastMessageId, lastActivityTime, 0L);
    }

    public InVmSequenceData(String sequenceId, String securityContextTokenId, long expirationTime, Sequence.State state, boolean ackRequestedFlag, long lastMessageId, long lastActivityTime, long lastAcknowledgementRequestTime) {
        this.sequenceId = sequenceId;
        this.boundSecurityTokenReferenceId = securityContextTokenId;
        this.expirationTime = expirationTime;
        this.state = state;
        this.ackRequestedFlag = ackRequestedFlag;
        this.lastMessageNumber = lastMessageId;
        this.lastActivityTime = lastActivityTime;
        this.lastAcknowledgementRequestTime = lastAcknowledgementRequestTime;
        this.allUnackedMessageNumbers = new TreeSet<Long>();
        this.receivedUnackedMessageNumbers = new HashSet<Long>();
        this.weakMessageStorage = new WeakHashMap<String, ApplicationMessage>();
        this.weakUnackedNumberToCorrelationIdMap = new WeakHashMap<Long, String>();
    }

    @Override
    public void lockRead() {
        this.dataLock.readLock().lock();
    }

    @Override
    public void unlockRead() {
        this.dataLock.readLock().unlock();
    }

    @Override
    public void lockWrite() {
        this.dataLock.writeLock().lock();
    }

    @Override
    public void unlockWrite() {
        this.dataLock.writeLock().unlock();
    }

    @Override
    public String getSequenceId() {
        return this.sequenceId;
    }

    @Override
    public String getBoundSecurityTokenReferenceId() {
        return this.boundSecurityTokenReferenceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLastMessageNumber() {
        try {
            this.lockRead();
            long l = this.lastMessageNumber;
            return l;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLastMessageNumber(long newLastMessageNumber) {
        try {
            this.lockWrite();
            this.lastMessageNumber = newLastMessageNumber;
        }
        finally {
            this.unlockWrite();
        }
    }

    @Override
    public Sequence.State getState() {
        return this.state;
    }

    @Override
    public void setState(Sequence.State newState) {
        this.state = newState;
    }

    @Override
    public boolean getAckRequestedFlag() {
        return this.ackRequestedFlag;
    }

    @Override
    public void setAckRequestedFlag(boolean newValue) {
        this.ackRequestedFlag = newValue;
    }

    @Override
    public long getLastAcknowledgementRequestTime() {
        return this.lastAcknowledgementRequestTime;
    }

    @Override
    public void setLastAcknowledgementRequestTime(long newTime) {
        this.lastAcknowledgementRequestTime = newTime;
    }

    @Override
    public long getLastActivityTime() {
        return this.lastActivityTime;
    }

    @Override
    public void setLastActivityTime(long newTime) {
        this.lastActivityTime = newTime;
    }

    @Override
    public long getExpirationTime() {
        return this.expirationTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void attachMessageToUnackedMessageNumber(ApplicationMessage message) {
        try {
            this.lockWrite();
            String correlationKey = new String(message.getCorrelationId());
            Long msgNumberKey = this.getUnackedMessageIdentifierKey(message.getMessageNumber());
            this.weakUnackedNumberToCorrelationIdMap.put(msgNumberKey, correlationKey);
            this.weakMessageStorage.put(correlationKey, message);
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerUnackedMessageNumber(long messageNumber, boolean received) throws DuplicateMessageRegistrationException {
        try {
            this.lockWrite();
            if (received && this.receivedUnackedMessageNumbers.contains(messageNumber) || !received && this.allUnackedMessageNumbers.contains(messageNumber)) {
                throw new DuplicateMessageRegistrationException(this.sequenceId, messageNumber);
            }
            Long newUnackedInstance = new Long(messageNumber);
            this.allUnackedMessageNumbers.add(newUnackedInstance);
            if (received) {
                this.receivedUnackedMessageNumbers.add(newUnackedInstance);
            }
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markAsAcknowledged(long messageNumber) {
        try {
            this.lockWrite();
            if (!this.receivedUnackedMessageNumbers.remove(messageNumber)) {
                throw new IllegalMessageIdentifierException(this.sequenceId, messageNumber);
            }
            boolean removedFromAll = this.allUnackedMessageNumbers.remove(messageNumber);
            assert (removedFromAll);
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApplicationMessage retrieveMessage(String correlationId) {
        try {
            this.lockRead();
            ApplicationMessage applicationMessage = this.weakMessageStorage.get(correlationId);
            return applicationMessage;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Long> getUnackedMessageNumbers() {
        try {
            this.lockRead();
            Collection<Long> collection = Collections.unmodifiableCollection(new ArrayList<Long>(this.allUnackedMessageNumbers));
            return collection;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long getUnackedMessageIdentifierKey(long messageNumber) {
        try {
            this.lockRead();
            Long msgNumberKey2 = null;
            for (Long msgNumberKey2 : this.receivedUnackedMessageNumbers) {
                if (msgNumberKey2 == messageNumber) break;
            }
            Long l = msgNumberKey2;
            return l;
        }
        finally {
            this.unlockRead();
        }
    }
}

