/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.istack.logging.Logger;
import com.sun.xml.ws.rx.rm.runtime.ApplicationMessage;
import com.sun.xml.ws.rx.util.TimeSynchronizer;
import com.sun.xml.ws.rx.util.TimestampedCollection;
import java.util.LinkedList;
import java.util.logging.Level;

final class RedeliveryTask
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(RedeliveryTask.class);
    private final TimestampedCollection<Object, ApplicationMessage> scheduledMessages = TimestampedCollection.newInstance();
    @NotNull
    private final DeliveryHandler deliveryHandler;
    @NotNull
    private volatile TimeSynchronizer timeSynchronizer;

    RedeliveryTask(@NotNull DeliveryHandler deliveryHandler, @Nullable TimeSynchronizer timeSynchronizer) {
        assert (deliveryHandler != null);
        this.deliveryHandler = deliveryHandler;
        this.timeSynchronizer = timeSynchronizer;
    }

    void setTimeSynchronizer(TimeSynchronizer timeSynchronizer) {
        this.timeSynchronizer = timeSynchronizer;
    }

    public void run() {
        assert (this.timeSynchronizer != null);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest(String.format("Periodic request resend task executed - registered message queue size: [ %d ]", this.scheduledMessages.size()));
        }
        LinkedList<ApplicationMessage> readyForResendQueue = new LinkedList<ApplicationMessage>();
        while (!this.scheduledMessages.isEmpty() && this.expired(this.scheduledMessages.getOldestRegistrationTimestamp())) {
            readyForResendQueue.add(this.scheduledMessages.removeOldest());
        }
        for (ApplicationMessage message : readyForResendQueue) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.info(String.format("Pputting to sequence [ %s ] delivery queue message with number [ %d ] ", message.getSequenceId(), message.getMessageNumber()));
            }
            this.deliveryHandler.putToDeliveryQueue(message);
        }
    }

    private final boolean expired(long resumeTime) {
        return this.timeSynchronizer.currentTimeInMillis() >= resumeTime;
    }

    final boolean register(@NotNull ApplicationMessage message, long executionTime) {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(String.format("A message with number [ %d ] has been scheduled for a resend on a sequence [ %s ]", message.getMessageNumber(), message.getSequenceId()));
        }
        return this.scheduledMessages.register(executionTime, message);
    }

    public static interface DeliveryHandler {
        public void putToDeliveryQueue(ApplicationMessage var1);
    }
}

