/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.rx.RxRuntimeException;
import com.sun.xml.ws.rx.rm.runtime.ApplicationMessage;
import com.sun.xml.ws.rx.rm.runtime.JaxwsApplicationMessage;
import com.sun.xml.ws.rx.rm.runtime.RuntimeContext;
import com.sun.xml.ws.rx.rm.runtime.delivery.Postman;
import com.sun.xml.ws.rx.rm.runtime.sequence.DuplicateMessageRegistrationException;
import com.sun.xml.ws.rx.util.AbstractResponseHandler;
import java.io.IOException;
import javax.xml.ws.WebServiceException;

class ClientSourceDeliveryCallback
implements Postman.Callback {
    private static final Logger LOGGER = Logger.getLogger(ClientSourceDeliveryCallback.class);
    private final RuntimeContext rc;

    public ClientSourceDeliveryCallback(RuntimeContext rc) {
        this.rc = rc;
    }

    public void deliver(ApplicationMessage message) {
        if (!(message instanceof JaxwsApplicationMessage)) {
            throw (RxRuntimeException)((Object)LOGGER.logSevereException((Throwable)((Object)new RxRuntimeException(String.format("Unexpected message class '%s', expected class '%s'", message.getClass().getName(), JaxwsApplicationMessage.class.getName())))));
        }
        this.deliver((JaxwsApplicationMessage)JaxwsApplicationMessage.class.cast(message));
    }

    private void deliver(JaxwsApplicationMessage message) {
        this.rc.sourceMessageHandler.attachAcknowledgementInfo(message);
        Packet outboundPacketCopy = message.getPacket().copy(true);
        this.rc.protocolHandler.appendSequenceHeader(outboundPacketCopy.getMessage(), message);
        this.rc.protocolHandler.appendAcknowledgementHeaders(outboundPacketCopy, message.getAcknowledgementData());
        AbstractResponseHandler responseCallback = outboundPacketCopy.expectReply == null ? new AmbiguousMepCallbackHandler(message, this.rc) : (outboundPacketCopy.expectReply != false ? new ReqRespMepCallbackHandler(message, this.rc) : new OneWayMepCallbackHandler(message, this.rc));
        this.rc.communicator.sendAsync(outboundPacketCopy, (Fiber.CompletionCallback)((Object)responseCallback));
    }

    private static boolean isResendPossible(Throwable throwable) {
        if (throwable instanceof IOException) {
            return true;
        }
        return throwable instanceof WebServiceException && throwable.getCause() instanceof IOException;
    }

    private static class AmbiguousMepCallbackHandler
    extends AbstractResponseHandler
    implements Fiber.CompletionCallback {
        private final ApplicationMessage request;
        private final RuntimeContext rc;

        public AmbiguousMepCallbackHandler(ApplicationMessage request, RuntimeContext rc) {
            super(rc.suspendedFiberStorage, request.getCorrelationId());
            this.request = request;
            this.rc = rc;
        }

        public void onCompletion(Packet response) {
            if (response.getMessage() != null) {
                JaxwsApplicationMessage message = new JaxwsApplicationMessage(response, this.getCorrelationId());
                this.rc.protocolHandler.loadSequenceHeaderData(message, message.getJaxwsMessage());
                this.rc.protocolHandler.loadAcknowledgementData(message, message.getJaxwsMessage());
                this.rc.destinationMessageHandler.processAcknowledgements(message.getAcknowledgementData());
                if (message.getSequenceId() != null) {
                    try {
                        this.rc.destinationMessageHandler.registerMessage(message);
                        this.rc.destinationMessageHandler.putToDeliveryQueue(message);
                        return;
                    }
                    catch (DuplicateMessageRegistrationException ex) {
                        this.onCompletion(ex);
                        return;
                    }
                }
            }
            this.resumeParentFiber(response);
        }

        public void onCompletion(Throwable error) {
            if (ClientSourceDeliveryCallback.isResendPossible(error)) {
                this.rc.redeliveryTask.register(this.request, this.rc.configuration.getRetransmissionBackoffAlgorithm().nextResendTime(this.request.getNextResendCount(), this.rc.configuration.getMessageRetransmissionInterval(), this.rc.sequenceManager()));
            } else {
                this.resumeParentFiber(error);
            }
        }
    }

    private static class ReqRespMepCallbackHandler
    extends AbstractResponseHandler
    implements Fiber.CompletionCallback {
        private final ApplicationMessage request;
        private final RuntimeContext rc;

        public ReqRespMepCallbackHandler(ApplicationMessage request, RuntimeContext rc) {
            super(rc.suspendedFiberStorage, request.getCorrelationId());
            this.request = request;
            this.rc = rc;
        }

        public void onCompletion(Packet response) {
            if (response.getMessage() != null) {
                JaxwsApplicationMessage message = new JaxwsApplicationMessage(response, this.getCorrelationId());
                this.rc.protocolHandler.loadSequenceHeaderData(message, message.getJaxwsMessage());
                this.rc.protocolHandler.loadAcknowledgementData(message, message.getJaxwsMessage());
                try {
                    this.rc.destinationMessageHandler.registerMessage(message);
                    this.rc.destinationMessageHandler.processAcknowledgements(message.getAcknowledgementData());
                    this.rc.destinationMessageHandler.putToDeliveryQueue(message);
                }
                catch (DuplicateMessageRegistrationException ex) {
                    this.onCompletion(ex);
                }
            } else {
                this.rc.redeliveryTask.register(this.request, this.rc.configuration.getRetransmissionBackoffAlgorithm().nextResendTime(this.request.getNextResendCount(), this.rc.configuration.getMessageRetransmissionInterval(), this.rc.sequenceManager()));
            }
        }

        public void onCompletion(Throwable error) {
            if (ClientSourceDeliveryCallback.isResendPossible(error)) {
                this.rc.redeliveryTask.register(this.request, this.rc.configuration.getRetransmissionBackoffAlgorithm().nextResendTime(this.request.getNextResendCount(), this.rc.configuration.getMessageRetransmissionInterval(), this.rc.sequenceManager()));
            } else {
                this.resumeParentFiber(error);
            }
        }
    }

    private static class OneWayMepCallbackHandler
    extends AbstractResponseHandler
    implements Fiber.CompletionCallback {
        private final RuntimeContext rc;
        private final ApplicationMessage request;

        public OneWayMepCallbackHandler(ApplicationMessage request, RuntimeContext rc) {
            super(rc.suspendedFiberStorage, request.getCorrelationId());
            this.request = request;
            this.rc = rc;
        }

        public void onCompletion(Packet response) {
            if (response.getMessage() != null) {
                JaxwsApplicationMessage message = new JaxwsApplicationMessage(response, this.getCorrelationId());
                this.rc.protocolHandler.loadSequenceHeaderData(message, message.getJaxwsMessage());
                this.rc.protocolHandler.loadAcknowledgementData(message, message.getJaxwsMessage());
                this.rc.destinationMessageHandler.processAcknowledgements(message.getAcknowledgementData());
            }
            this.resumeParentFiber(response);
        }

        public void onCompletion(Throwable error) {
            if (ClientSourceDeliveryCallback.isResendPossible(error)) {
                this.rc.redeliveryTask.register(this.request, this.rc.configuration.getRetransmissionBackoffAlgorithm().nextResendTime(this.request.getNextResendCount(), this.rc.configuration.getMessageRetransmissionInterval(), this.rc.sequenceManager()));
            } else {
                this.resumeParentFiber(error);
            }
        }
    }
}

