/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.config.management.jmx;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.config.management.Configurator;
import com.sun.xml.ws.api.config.management.EndpointCreationAttributes;
import com.sun.xml.ws.api.config.management.ManagedEndpoint;
import com.sun.xml.ws.api.config.management.ManagementFactory;
import com.sun.xml.ws.api.config.management.NamedParameters;
import com.sun.xml.ws.config.management.ManagementMessages;
import com.sun.xml.ws.config.management.ManagementUtil;
import com.sun.xml.ws.config.management.jmx.MBeanAttribute;
import javax.management.InvalidAttributeValueException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReconfigMBeanAttribute<T>
implements MBeanAttribute {
    private static final Logger LOGGER = Logger.getLogger(ReconfigMBeanAttribute.class);
    public static final String SERVICE_WSDL_ATTRIBUTE_NAME = ManagementMessages.RECONFIG_ATTRIBUTE_NAME();
    private final ManagedEndpoint<T> managedEndpoint;
    private final EndpointCreationAttributes endpointCreationAttributes;
    private final ClassLoader classLoader;
    private volatile String newPolicies;

    public ReconfigMBeanAttribute(ManagedEndpoint<T> endpoint, EndpointCreationAttributes creationAttributes, ClassLoader classLoader) {
        this.managedEndpoint = endpoint;
        this.endpointCreationAttributes = creationAttributes;
        this.classLoader = classLoader;
    }

    @Override
    public Object get() {
        return this.newPolicies;
    }

    @Override
    public String getDescription() {
        return ManagementMessages.RECONFIG_ATTRIBUTE_DESCRIPTION();
    }

    @Override
    public OpenType getType() {
        return SimpleType.STRING;
    }

    @Override
    public void update(Object value) throws InvalidAttributeValueException {
        if (!String.class.isAssignableFrom(value.getClass())) {
            throw (InvalidAttributeValueException)LOGGER.logSevereException((Throwable)new InvalidAttributeValueException(ManagementMessages.WSM_5010_EXPECTED_STRING(SERVICE_WSDL_ATTRIBUTE_NAME, value.getClass().getName())));
        }
        this.update((String)value);
    }

    private void update(String value) throws InvalidAttributeValueException {
        try {
            this.newPolicies = value;
            ManagementFactory factory = new ManagementFactory(ManagementUtil.getAssertion(this.managedEndpoint));
            Configurator config = factory.createConfiguratorImpl();
            NamedParameters parameters = new NamedParameters().put("ENDPOINT_INSTANCE", this.managedEndpoint).put("CREATION_ATTRIBUTES", this.endpointCreationAttributes).put("CLASS_LOADER", this.classLoader).put("CONFIGURATION_DATA", value);
            config.recreate(parameters);
        }
        catch (WebServiceException cause) {
            InvalidAttributeValueException exception = new InvalidAttributeValueException(ManagementMessages.WSM_5009_RECONFIGURATION_FAILED());
            LOGGER.logSevereException((Throwable)cause);
            throw (InvalidAttributeValueException)LOGGER.logSevereException((Throwable)exception);
        }
    }
}

