/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.config.management.jmx;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.config.management.CommunicationServer;
import com.sun.xml.ws.api.config.management.ConfigReader;
import com.sun.xml.ws.api.config.management.EndpointCreationAttributes;
import com.sun.xml.ws.api.config.management.EndpointStarter;
import com.sun.xml.ws.api.config.management.ManagedEndpoint;
import com.sun.xml.ws.api.config.management.ManagementFactory;
import com.sun.xml.ws.api.config.management.NamedParameters;
import com.sun.xml.ws.config.management.ManagementMessages;
import com.sun.xml.ws.config.management.ManagementUtil;
import com.sun.xml.ws.config.management.jmx.MBeanAttribute;
import com.sun.xml.ws.config.management.jmx.ReconfigMBean;
import com.sun.xml.ws.config.management.jmx.ReconfigMBeanAttribute;
import com.sun.xml.ws.config.management.policy.ManagedServiceAssertion;
import com.sun.xml.ws.policy.PolicyAssertion;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMXAgent<T>
implements CommunicationServer {
    private static final Logger LOGGER = Logger.getLogger(JMXAgent.class);
    private static final QName JMX_SERVICE_URL_PARAMETER_QNAME = new QName("http://java.sun.com/xml/ns/metro/management", "JMXServiceURL");
    private static final String JMX_SERVICE_URL_DEFAULT_PREFIX = "service:jmx:rmi:///jndi/rmi://localhost:8686/metro/";
    private ConfigReader configReader;
    private MBeanServer server;
    private JMXConnectorServer connector;
    private String endpointId;
    private ManagedEndpoint<T> managedEndpoint;
    private EndpointCreationAttributes endpointCreationAttributes;
    private ClassLoader classLoader;

    @Override
    public void init(NamedParameters parameters) {
        try {
            this.endpointId = (String)parameters.get("ENDPOINT_ID");
            this.managedEndpoint = (ManagedEndpoint)parameters.get("ENDPOINT_INSTANCE");
            this.endpointCreationAttributes = (EndpointCreationAttributes)parameters.get("CREATION_ATTRIBUTES");
            this.classLoader = (ClassLoader)parameters.get("CLASS_LOADER");
            ManagedServiceAssertion managedService = ManagementUtil.getAssertion(this.managedEndpoint);
            ManagementFactory factory = new ManagementFactory(managedService);
            EndpointStarter endpointStarter = (EndpointStarter)parameters.get("ENDPOINT_STARTER");
            this.configReader = factory.createConfigReaderImpl(new NamedParameters().put("ENDPOINT_INSTANCE", this.managedEndpoint).put("CREATION_ATTRIBUTES", this.endpointCreationAttributes).put("CLASS_LOADER", this.classLoader).put("ENDPOINT_STARTER", endpointStarter));
            this.server = MBeanServerFactory.createMBeanServer();
            JMXServiceURL jmxUrl = this.getServiceURL(managedService);
            Map<String, String> env = managedService.getJMXConnectorServerEnvironment();
            this.connector = JMXConnectorServerFactory.newJMXConnectorServer(jmxUrl, env, this.server);
        }
        catch (MalformedURLException e) {
            throw (WebServiceException)LOGGER.logSevereException((Throwable)new WebServiceException((Throwable)e));
        }
        catch (IOException e) {
            throw (WebServiceException)LOGGER.logSevereException((Throwable)new WebServiceException((Throwable)e));
        }
    }

    @Override
    public void start() {
        if (this.server != null && this.connector != null) {
            try {
                this.server.registerMBean(this.createMBean(), this.getObjectName());
                this.connector.start();
                LOGGER.info(ManagementMessages.WSM_5001_ENDPOINT_CREATED(this.endpointId, this.connector.getAddress()));
                this.configReader.start();
            }
            catch (InstanceAlreadyExistsException ex) {
                throw (WebServiceException)LOGGER.logSevereException((Throwable)new WebServiceException((Throwable)ex));
            }
            catch (MBeanRegistrationException ex) {
                throw (WebServiceException)LOGGER.logSevereException((Throwable)new WebServiceException((Throwable)ex));
            }
            catch (NotCompliantMBeanException ex) {
                throw (WebServiceException)LOGGER.logSevereException((Throwable)new WebServiceException((Throwable)ex));
            }
            catch (IOException ex) {
                throw (WebServiceException)LOGGER.logSevereException((Throwable)new WebServiceException((Throwable)ex));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void stop() {
        try {
            if (this.connector == null) return;
            this.connector.stop();
            return;
        }
        catch (IOException ex) {
            throw (WebServiceException)LOGGER.logSevereException((Throwable)new WebServiceException((Throwable)ex));
        }
        finally {
            try {
                if (this.server != null) {
                    this.server.unregisterMBean(this.getObjectName());
                }
            }
            catch (InstanceNotFoundException ex) {
                throw (WebServiceException)LOGGER.logSevereException((Throwable)new WebServiceException((Throwable)ex));
            }
            catch (MBeanRegistrationException ex) {
                throw (WebServiceException)LOGGER.logSevereException((Throwable)new WebServiceException((Throwable)ex));
            }
            finally {
                this.configReader.stop();
            }
        }
    }

    private ReconfigMBean createMBean() {
        HashMap<String, MBeanAttribute> attributeToListener = new HashMap<String, MBeanAttribute>();
        attributeToListener.put(ReconfigMBeanAttribute.SERVICE_WSDL_ATTRIBUTE_NAME, new ReconfigMBeanAttribute<T>(this.managedEndpoint, this.endpointCreationAttributes, this.classLoader));
        return new ReconfigMBean(attributeToListener);
    }

    private ObjectName getObjectName() {
        try {
            return new ObjectName("com.sun.xml.ws.config.management:className=" + this.endpointId);
        }
        catch (MalformedObjectNameException ex) {
            throw (WebServiceException)LOGGER.logSevereException((Throwable)new WebServiceException((Throwable)ex));
        }
    }

    private JMXServiceURL getServiceURL(PolicyAssertion managedService) {
        try {
            Iterator<PolicyAssertion> parameters = managedService.getParametersIterator();
            while (parameters.hasNext()) {
                PolicyAssertion parameter = parameters.next();
                if (!JMX_SERVICE_URL_PARAMETER_QNAME.equals(parameter.getName())) continue;
                return new JMXServiceURL(parameter.getValue().trim());
            }
            String jmxServiceURL = JMX_SERVICE_URL_DEFAULT_PREFIX + this.endpointId;
            LOGGER.config(ManagementMessages.WSM_5005_DEFAULT_JMX_SERVICE_URL(jmxServiceURL));
            return new JMXServiceURL(jmxServiceURL);
        }
        catch (MalformedURLException ex) {
            throw (WebServiceException)LOGGER.logSevereException((Throwable)new WebServiceException((Throwable)ex));
        }
    }
}

