/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.api.server;

import com.sun.xml.ws.api.server.RIDeploymentEndpointData;
import com.sun.xml.ws.api.server.WSEndpoint;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;
import org.glassfish.probe.provider.annotations.ProbeListener;
import org.glassfish.probe.provider.annotations.ProbeParam;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagedObject
@Description(value="Stats for Web Services deployed using RI deployment")
public class RIDeploymentStatsProvider {
    private final ConcurrentHashMap<String, RIDeploymentEndpointData> endpoints = new ConcurrentHashMap();

    @ProbeListener(value="glassfish:webservices:ri:deploy")
    public void deploy(@ProbeParam(value="name") String name, @ProbeParam(value="endpoint") WSEndpoint endpoint) {
        this.endpoints.put(name, new RIDeploymentEndpointData(endpoint));
    }

    @ProbeListener(value="glassfish:webservices:ri:undeploy")
    public void undeploy(@ProbeParam(value="name") String name) {
        this.endpoints.remove(name);
    }

    @ManagedAttribute
    @Description(value="Endpoints with sun-jaxws.xml deployment")
    public Collection<RIDeploymentEndpointData> getRIEndpoints() {
        return Collections.unmodifiableCollection(this.endpoints.values());
    }

    RIDeploymentEndpointData getEndpoint(String appName) {
        return this.endpoints.get(appName);
    }
}

