/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.tcp.util;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.pipe.Codec;
import com.sun.xml.ws.api.pipe.SOAPBindingCodec;
import com.sun.xml.ws.api.pipe.StreamSOAPCodec;
import com.sun.xml.ws.transport.tcp.encoding.WSTCPFastInfosetStreamCodec;
import com.sun.xml.ws.transport.tcp.encoding.WSTCPFastInfosetStreamReaderRecyclable;
import com.sun.xml.ws.transport.tcp.io.Connection;
import com.sun.xml.ws.transport.tcp.resources.MessagesMessages;
import com.sun.xml.ws.transport.tcp.util.ChannelSettings;
import com.sun.xml.ws.transport.tcp.util.ConnectionSession;
import com.sun.xml.ws.transport.tcp.util.ContentType;
import com.sun.xml.ws.transport.tcp.util.WSTCPError;
import com.sun.xml.ws.transport.tcp.util.WSTCPException;
import com.sun.xml.ws.transport.tcp.util.WSTCPURI;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;

public class ChannelContext
implements WSTCPFastInfosetStreamReaderRecyclable.RecycleAwareListener {
    private static final Logger logger = Logger.getLogger("com.sun.xml.ws.transport.tcp");
    private final ConnectionSession connectionSession;
    private final ChannelSettings channelSettings;
    private Codec codec;
    private final ContentType contentType = new ContentType();

    public ChannelContext(@NotNull ConnectionSession connectionSession, @NotNull ChannelSettings channelSettings) {
        this.connectionSession = connectionSession;
        this.channelSettings = channelSettings;
    }

    @NotNull
    public ConnectionSession getConnectionSession() {
        return this.connectionSession;
    }

    @NotNull
    public ChannelSettings getChannelSettings() {
        return this.channelSettings;
    }

    @Nullable
    public Codec getCodec() {
        return this.codec;
    }

    private void setCodec(@NotNull Codec codec) {
        this.codec = codec;
    }

    @NotNull
    public Connection getConnection() {
        return this.connectionSession.getConnection();
    }

    public int getChannelId() {
        return this.channelSettings.getChannelId();
    }

    @NotNull
    public QName getWSServiceName() {
        return this.channelSettings.getWSServiceName();
    }

    public void setWSServiceName(@NotNull QName wsServiceName) {
        this.channelSettings.setWSServiceName(wsServiceName);
    }

    @Nullable
    public WSTCPURI getTargetWSURI() {
        return this.channelSettings.getTargetWSURI();
    }

    public void setContentType(@NotNull String contentTypeS) throws WSTCPException {
        Connection connection = this.connectionSession.getConnection();
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, MessagesMessages.WSTCP_1120_CHANNEL_CONTEXT_ENCODE_CT(contentTypeS));
        }
        this.contentType.parse(contentTypeS);
        int mt = this.encodeMimeType(this.contentType.getMimeType());
        connection.setContentId(mt);
        Map<String, String> parameters = this.contentType.getParameters();
        for (Map.Entry<String, String> parameter : parameters.entrySet()) {
            int paramId = this.encodeParam(parameter.getKey());
            connection.setContentProperty(paramId, parameter.getValue());
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, MessagesMessages.WSTCP_1121_CHANNEL_CONTEXT_ENCODED_CT(mt, parameters));
        }
    }

    @NotNull
    public String getContentType() throws WSTCPException {
        String mimeType;
        Connection connection = this.connectionSession.getConnection();
        int mimeId = connection.getContentId();
        Map<Integer, String> params = connection.getContentProperties();
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, MessagesMessages.WSTCP_1122_CHANNEL_CONTEXT_DECODE_CT(mimeId, params));
        }
        String contentTypeStr = mimeType = this.decodeMimeType(mimeId);
        if (params.size() > 0) {
            StringBuffer ctBuf = new StringBuffer(contentTypeStr);
            for (Map.Entry<Integer, String> parameter : params.entrySet()) {
                ctBuf.append(';');
                String paramKey = this.decodeParam(parameter.getKey());
                String paramValue = parameter.getValue();
                ctBuf.append(paramKey);
                ctBuf.append('=');
                ctBuf.append(paramValue);
            }
            contentTypeStr = ctBuf.toString();
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, MessagesMessages.WSTCP_1123_CHANNEL_CONTEXT_DECODED_CT(contentTypeStr));
        }
        return contentTypeStr;
    }

    public int encodeMimeType(@NotNull String mimeType) throws WSTCPException {
        int contentId = this.channelSettings.getNegotiatedMimeTypes().indexOf(mimeType);
        if (contentId != -1) {
            return contentId;
        }
        throw new WSTCPException(WSTCPError.createNonCriticalError(2, MessagesMessages.WSTCP_0011_UNKNOWN_CONTENT_TYPE(mimeType)));
    }

    @NotNull
    public String decodeMimeType(int contentId) throws WSTCPException {
        String mimeType = this.channelSettings.getNegotiatedMimeTypes().get(contentId);
        if (mimeType != null) {
            return mimeType;
        }
        throw new WSTCPException(WSTCPError.createNonCriticalError(2, MessagesMessages.WSTCP_0011_UNKNOWN_CONTENT_TYPE(contentId)));
    }

    public int encodeParam(@NotNull String paramStr) throws WSTCPException {
        int paramId = this.channelSettings.getNegotiatedParams().indexOf(paramStr);
        if (paramId != -1) {
            return paramId;
        }
        throw new WSTCPException(WSTCPError.createNonCriticalError(3, MessagesMessages.WSTCP_0010_UNKNOWN_PARAMETER(paramStr)));
    }

    @NotNull
    public String decodeParam(int paramId) throws WSTCPException {
        String paramStr = this.channelSettings.getNegotiatedParams().get(paramId);
        if (paramStr != null) {
            return paramStr;
        }
        throw new WSTCPException(WSTCPError.createNonCriticalError(3, MessagesMessages.WSTCP_0010_UNKNOWN_PARAMETER(paramId)));
    }

    public static void configureCodec(@NotNull ChannelContext channelContext, @NotNull SOAPVersion soapVersion, @NotNull Codec defaultCodec) {
        List<String> supportedMimeTypes = channelContext.getChannelSettings().getNegotiatedMimeTypes();
        if (supportedMimeTypes != null) {
            if (supportedMimeTypes.contains("application/vnd.sun.stateful.fastinfoset") || supportedMimeTypes.contains("application/vnd.sun.stateful.soap+fastinfoset")) {
                logger.log(Level.FINEST, "ChannelContext.configureCodec: FI Stateful");
                StreamSOAPCodec streamSoapCodec = defaultCodec instanceof SOAPBindingCodec ? ((SOAPBindingCodec)defaultCodec).getXMLCodec() : null;
                channelContext.setCodec(WSTCPFastInfosetStreamCodec.create(streamSoapCodec, soapVersion, channelContext, true));
                return;
            }
            if (supportedMimeTypes.contains("application/fastinfoset") || supportedMimeTypes.contains("application/soap+fastinfoset")) {
                logger.log(Level.FINEST, "ChannelContext.configureCodec: FI Stateless");
                StreamSOAPCodec streamSoapCodec = defaultCodec instanceof SOAPBindingCodec ? ((SOAPBindingCodec)defaultCodec).getXMLCodec() : null;
                channelContext.setCodec(WSTCPFastInfosetStreamCodec.create(streamSoapCodec, soapVersion, channelContext, false));
                return;
            }
        }
        logger.log(Level.FINEST, "ChannelContext.configureCodec: default");
        channelContext.setCodec(defaultCodec);
    }

    public String toString() {
        return String.format("ID: %d\nURI: %s\nCodec:%s", this.getChannelId(), this.getTargetWSURI(), this.getCodec());
    }

    public void onRecycled() {
        this.connectionSession.onReadCompleted();
    }
}

