/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.addressing.policy;

import com.sun.xml.ws.addressing.W3CAddressingMetadataConstants;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.model.SEIModel;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.PolicyMapExtender;
import com.sun.xml.ws.policy.PolicyMapKey;
import com.sun.xml.ws.policy.PolicySubject;
import com.sun.xml.ws.policy.jaxws.spi.PolicyMapUpdateProvider;
import com.sun.xml.ws.policy.privateutil.PolicyLogger;
import com.sun.xml.ws.policy.sourcemodel.AssertionData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.ws.soap.AddressingFeature;

public class AddressingMapUpdateProvider
implements PolicyMapUpdateProvider {
    private static final PolicyLogger LOGGER = PolicyLogger.getLogger(AddressingMapUpdateProvider.class);

    public void update(PolicyMapExtender policyMapMutator, PolicyMap policyMap, SEIModel model, WSBinding wsBinding) throws PolicyException {
        LOGGER.entering(policyMapMutator, policyMap, model, wsBinding);
        if (policyMap != null) {
            AddressingFeature addressingFeature = wsBinding.getFeature(AddressingFeature.class);
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("addressingFeature = " + addressingFeature);
            }
            if (addressingFeature != null && addressingFeature.isEnabled()) {
                this.addWsamAddressing(policyMapMutator, policyMap, model, addressingFeature);
            }
        }
        LOGGER.exiting();
    }

    private void addWsamAddressing(PolicyMapExtender policyMapMutator, PolicyMap policyMap, SEIModel model, AddressingFeature addressingFeature) throws PolicyException {
        PolicyMapKey endpointKey = PolicyMap.createWsdlEndpointScopeKey(model.getServiceQName(), model.getPortName());
        Policy existingPolicy = policyMap.getEndpointEffectivePolicy(endpointKey);
        if (existingPolicy == null || !existingPolicy.contains(W3CAddressingMetadataConstants.WSAM_ADDRESSING_ASSERTION)) {
            QName bindingName = model.getBoundPortTypeName();
            Policy addressingPolicy = this.createWsamAddressingPolicy(bindingName, addressingFeature);
            PolicySubject addressingPolicySubject = new PolicySubject((Object)bindingName, addressingPolicy);
            PolicyMapKey aKey = PolicyMap.createWsdlEndpointScopeKey(model.getServiceQName(), model.getPortName());
            policyMapMutator.putEndpointSubject(aKey, addressingPolicySubject);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Added addressing policy with ID \"" + addressingPolicy.getIdOrName() + "\" to binding element \"" + bindingName + "\"");
            }
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Addressing policy exists already, doing nothing");
        }
    }

    private Policy createWsamAddressingPolicy(QName bindingName, AddressingFeature af) {
        AddressingFeature.Responses responses;
        ArrayList<AssertionSet> assertionSets = new ArrayList<AssertionSet>(1);
        ArrayList<AddressingAssertion> assertions = new ArrayList<AddressingAssertion>(1);
        AssertionData addressingData = AssertionData.createAssertionData(W3CAddressingMetadataConstants.WSAM_ADDRESSING_ASSERTION);
        if (!af.isRequired()) {
            addressingData.setOptionalAttribute(true);
        }
        if ((responses = af.getResponses()) == AddressingFeature.Responses.ANONYMOUS) {
            AssertionData nestedAsserData = AssertionData.createAssertionData(W3CAddressingMetadataConstants.WSAM_ANONYMOUS_NESTED_ASSERTION);
            AddressingAssertion nestedAsser = new AddressingAssertion(nestedAsserData, null);
            assertions.add(new AddressingAssertion(addressingData, AssertionSet.createAssertionSet(Collections.singleton(nestedAsser))));
        } else if (responses == AddressingFeature.Responses.NON_ANONYMOUS) {
            AssertionData nestedAsserData = AssertionData.createAssertionData(W3CAddressingMetadataConstants.WSAM_NONANONYMOUS_NESTED_ASSERTION);
            AddressingAssertion nestedAsser = new AddressingAssertion(nestedAsserData, null);
            assertions.add(new AddressingAssertion(addressingData, AssertionSet.createAssertionSet(Collections.singleton(nestedAsser))));
        } else {
            assertions.add(new AddressingAssertion(addressingData, AssertionSet.createAssertionSet(null)));
        }
        assertionSets.add(AssertionSet.createAssertionSet(assertions));
        return Policy.createPolicy(null, bindingName.getLocalPart() + "_WSAM_Addressing_Policy", assertionSets);
    }

    private static final class AddressingAssertion
    extends PolicyAssertion {
        AddressingAssertion(AssertionData assertionData, AssertionSet nestedAlternative) {
            super(assertionData, null, nestedAlternative);
        }

        AddressingAssertion(AssertionData assertionData) {
            super(assertionData, null, null);
        }
    }
}

