/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.db.sdo;

import com.sun.xml.ws.db.sdo.SDOContextWrapper;
import com.sun.xml.ws.db.sdo.SDODatabindingException;
import com.sun.xml.ws.db.sdo.SDOUtils;
import com.sun.xml.ws.spi.db.PropertyAccessor;
import com.sun.xml.ws.spi.db.PropertyGetter;
import com.sun.xml.ws.spi.db.PropertySetter;
import com.sun.xml.ws.spi.db.WrapperAccessor;
import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Type;
import commonj.sdo.helper.TypeHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.xml.namespace.QName;

public final class SDOWrapperAccessor
extends WrapperAccessor {
    private SDOContextWrapper contextWrapper = null;
    private Class<?> contentClass;

    public SDOWrapperAccessor(SDOContextWrapper contextWrapper, Class<?> wrapperBean) {
        this.contextWrapper = contextWrapper;
        this.contentClass = wrapperBean;
        this.initBuilders();
    }

    protected void initBuilders() {
        HashMap<QName, SDOPropertyBuilder> setByQName = new HashMap<QName, SDOPropertyBuilder>();
        HashMap<QName, SDOPropertyBuilder> getByQName = new HashMap<QName, SDOPropertyBuilder>();
        HashMap<String, SDOPropertyBuilder> setByLocalpart = new HashMap<String, SDOPropertyBuilder>();
        HashMap<String, SDOPropertyBuilder> getByLocalpart = new HashMap<String, SDOPropertyBuilder>();
        HashSet<String> elementLocalNames = new HashSet<String>();
        TypeHelper helper = this.contextWrapper.getHelperContext().getTypeHelper();
        Type type = helper.getType(this.contentClass);
        List properties = type.getDeclaredProperties();
        for (Property p : properties) {
            QName qname = SDOUtils.getPropertyElementName(this.contextWrapper.getHelperContext(), p);
            SDOPropertyBuilder pBuilder = new SDOPropertyBuilder(qname, p.getType().getInstanceClass());
            setByQName.put(qname, pBuilder);
            getByQName.put(qname, pBuilder);
            setByLocalpart.put(qname.getLocalPart(), pBuilder);
            getByLocalpart.put(qname.getLocalPart(), pBuilder);
            if (elementLocalNames.contains(qname.getLocalPart())) {
                this.elementLocalNameCollision = true;
                continue;
            }
            elementLocalNames.add(qname.getLocalPart());
        }
        if (this.elementLocalNameCollision) {
            this.propertySetters = setByQName;
            this.propertyGetters = getByQName;
        } else {
            this.propertySetters = setByLocalpart;
            this.propertyGetters = getByLocalpart;
        }
    }

    static class SDOPropertyBuilder
    implements PropertyAccessor,
    PropertyGetter,
    PropertySetter {
        private QName qname;
        private Class<?> type;

        public SDOPropertyBuilder(QName qname, Class<?> type) {
            this.qname = qname;
            this.type = type;
        }

        public Class getType() {
            return this.type;
        }

        public <A> A getAnnotation(Class<A> annotationType) {
            return null;
        }

        public Object get(Object instance) {
            if (instance instanceof DataObject) {
                DataObject wrapperBean = (DataObject)instance;
                Property p = wrapperBean.getInstanceProperty(this.qname.getLocalPart());
                if (p == null) {
                    throw new SDODatabindingException("Property not found: " + this.qname.getLocalPart());
                }
                Object o = wrapperBean.get(p);
                return SDOUtils.unwrapPrimitives(o);
            }
            throw new SDODatabindingException("Invalid SDO object: " + instance);
        }

        public void set(Object instance, Object value) {
            Property p;
            DataObject wrapperBean;
            if (instance instanceof DataObject) {
                wrapperBean = (DataObject)instance;
                p = wrapperBean.getInstanceProperty(this.qname.getLocalPart());
                if (p == null) {
                    throw new SDODatabindingException("Property not found: " + this.qname.getLocalPart());
                }
            } else {
                throw new SDODatabindingException("Invalid SDO object: " + instance);
            }
            wrapperBean.set(p, value);
        }
    }
}

