/*
 * Decompiled with CFR 0.152.
 */
package testutil;

import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LocalConfigFileTransformer {
    public static void main(String[] args) {
        if (args == null || args.length < 3) {
            System.err.println("ERROR: need args: old config file location,\nnew (generated) config,\ntemp dir");
            return;
        }
        try {
            String oldConfig = args[0];
            String newConfig = args[2] + args[1];
            String tempdir = args[2];
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbf.newDocumentBuilder();
            Document doc = builder.parse(tempdir + "WEB-INF/sun-jaxws.xml");
            Map<String, String> endpointMap = LocalConfigFileTransformer.buildMap(doc.getElementsByTagName("endpoint"));
            doc = builder.parse(oldConfig);
            Element wsdlElement = (Element)doc.getElementsByTagName("wsdl").item(0);
            Attr wsdlAttr = wsdlElement.getAttributeNode("location");
            String location = wsdlAttr.getValue();
            String urlpattern = location.substring(location.lastIndexOf("/"), location.lastIndexOf("?"));
            String newLocation = tempdir + endpointMap.get(urlpattern);
            wsdlAttr.setValue(newLocation);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.transform(new DOMSource(doc), new StreamResult(newConfig));
        }
        catch (Exception e) {
            System.err.println("exception in LocalConfigFileTransformer:");
            e.printStackTrace();
        }
    }

    private static void checkEndpoint(Element endpoint) {
        if (endpoint == null) {
            System.err.println("\nLocalConfigFileTransformer could not find \"endpoint\" element in sun-jaxws.xml file.\nPlease check file and verify that it was generated correctly.\n");
            throw new RuntimeException("Cannot process sun-jaxws.xml file");
        }
    }

    private static Map<String, String> buildMap(NodeList nodeList) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>(nodeList.getLength());
        Element endpoint = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            endpoint = (Element)nodeList.item(i);
            LocalConfigFileTransformer.checkEndpoint(endpoint);
            String urlpattern = endpoint.getAttributeNode("urlpattern").getValue();
            String wsdl = endpoint.getAttributeNode("wsdl").getValue();
            map.put(urlpattern, wsdl.substring(1));
        }
        return map;
    }
}

