/*
 * Decompiled with CFR 0.152.
 */
package testutil;

import jakarta.xml.soap.MessageFactory;
import jakarta.xml.soap.MimeHeaders;
import jakarta.xml.soap.SOAPConnectionFactory;
import jakarta.xml.soap.SOAPMessage;
import jakarta.xml.ws.Binding;
import jakarta.xml.ws.BindingProvider;
import jakarta.xml.ws.Service;
import jakarta.xml.ws.handler.Handler;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import testutil.HTTPResponseInfo;

public class ClientServerTestUtil {
    public static boolean useLocal() {
        return Boolean.getBoolean("uselocal");
    }

    public static boolean getLog() {
        return Boolean.getBoolean("log");
    }

    public static boolean uselwhs() {
        return Boolean.getBoolean("uselwhs");
    }

    @Deprecated
    public static void setTransport(Object stub) throws Exception {
    }

    @Deprecated
    public static void setTransport(Object stub, OutputStream out) throws Exception {
    }

    public static HTTPResponseInfo sendPOSTRequest(String address, String message, String ctType) throws Exception {
        return ClientServerTestUtil.sendPOSTRequest(address, message, ctType, "\"\"");
    }

    public static HTTPResponseInfo sendPOSTRequest(String address, String message, String ctType, String soapAction) throws Exception {
        InputStream istream;
        byte[] requestData = message.getBytes();
        HttpURLConnection conn = (HttpURLConnection)new URL(address).openConnection();
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("HTTP-Version", "HTTP/1.1");
        conn.setRequestProperty("Content-Type", ctType);
        if (soapAction != null) {
            conn.setRequestProperty("SOAPAction", soapAction);
        }
        conn.setRequestProperty("Content-Length", String.valueOf(requestData.length));
        OutputStream outputStream = conn.getOutputStream();
        outputStream.write(requestData);
        boolean isFailure = true;
        int responseCode = conn.getResponseCode();
        if (responseCode == 200) {
            isFailure = false;
        }
        String responseMessage = conn.getResponseMessage();
        String bodyResponse = null;
        InputStream inputStream = istream = !isFailure ? conn.getInputStream() : conn.getErrorStream();
        if (istream != null) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(istream));
            StringBuilder sBuffer = new StringBuilder();
            String line = reader.readLine();
            while (line != null) {
                sBuffer.append(line);
                line = reader.readLine();
            }
            bodyResponse = sBuffer.toString();
        }
        conn.disconnect();
        return new HTTPResponseInfo(responseCode, responseMessage, bodyResponse);
    }

    public static HTTPResponseInfo sendPOSTRequest(String address, String message) throws Exception {
        return ClientServerTestUtil.sendPOSTRequest(address, message, "text/xml");
    }

    public static HTTPResponseInfo sendPOSTRequest(Object stub, String message) throws Exception {
        BindingProvider bp = (BindingProvider)stub;
        String address = (String)bp.getRequestContext().get("jakarta.xml.ws.service.endpoint.address");
        return ClientServerTestUtil.sendPOSTRequest(address, message);
    }

    public static HTTPResponseInfo sendPOSTRequest(Object stub, String message, String ct) throws Exception {
        BindingProvider bp = (BindingProvider)stub;
        String address = (String)bp.getRequestContext().get("jakarta.xml.ws.service.endpoint.address");
        return ClientServerTestUtil.sendPOSTRequest(address, message, ct);
    }

    public static SOAPMessage makeSaajRequest(Object stub, InputStream is) throws Exception {
        MessageFactory messageFactory = MessageFactory.newInstance();
        SOAPConnectionFactory connectionFactory = SOAPConnectionFactory.newInstance();
        MimeHeaders headers = new MimeHeaders();
        headers.addHeader("Content-Type", "text/xml");
        SOAPMessage message = messageFactory.createMessage(headers, is);
        BindingProvider bp = (BindingProvider)stub;
        String address = (String)bp.getRequestContext().get("jakarta.xml.ws.service.endpoint.address");
        URL url = new URL(address);
        return connectionFactory.createConnection().call(message, (Object)url);
    }

    public static Object getPort(Service service, Class<?> seiClass, QName port) throws Exception {
        return service.getPort(port, seiClass);
    }

    public static void addHandlerToBinding(Handler handler, BindingProvider bindingProvider) {
        Binding binding = bindingProvider.getBinding();
        List handlers = binding.getHandlerChain();
        handlers.add(handler);
        binding.setHandlerChain(handlers);
    }

    public static void clearHandlers(BindingProvider provider) {
        Binding binding = provider.getBinding();
        binding.setHandlerChain(new ArrayList());
    }

    public static String getLocalAddress(QName port) {
        return "local://" + new File(System.getProperty("tempdir")).getAbsolutePath().replace('\\', '/') + "?" + port.getLocalPart();
    }
}

