/*
 * Decompiled with CFR 0.152.
 */
package testutil;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import org.w3c.dom.Node;

public class AttachmentHelper {
    public static boolean compareSource(Source src, Source target) throws TransformerException {
        Transformer t1 = TransformerFactory.newInstance().newTransformer();
        Transformer t2 = TransformerFactory.newInstance().newTransformer();
        DOMResult srcResult = new DOMResult();
        DOMResult tarResult = new DOMResult();
        t1.transform(src, srcResult);
        Node n1 = srcResult.getNode();
        t2.transform(target, tarResult);
        Node n2 = tarResult.getNode();
        return n1.getNodeName().equals(n2.getNodeName());
    }

    public static byte[] getImageBytes(Image image, String type) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedImage bufImage = AttachmentHelper.convertToBufferedImage(image);
        ImageWriter writer = null;
        Iterator<ImageWriter> i = ImageIO.getImageWritersByMIMEType(type);
        if (i.hasNext()) {
            writer = i.next();
        }
        if (writer != null) {
            ImageOutputStream stream = null;
            stream = ImageIO.createImageOutputStream(baos);
            writer.setOutput(stream);
            writer.write(bufImage);
            stream.close();
            return baos.toByteArray();
        }
        return null;
    }

    private static BufferedImage convertToBufferedImage(Image image) throws IOException {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        MediaTracker tracker = new MediaTracker(null);
        tracker.addImage(image, 0);
        try {
            tracker.waitForAll();
        }
        catch (InterruptedException e) {
            throw new IOException(e.getMessage());
        }
        BufferedImage bufImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
        Graphics2D g = bufImage.createGraphics();
        g.drawImage(image, 0, 0, null);
        return bufImage;
    }

    public static boolean compareImages(Image image1, Image image2) throws IOException {
        if (image1 == null || image2 == null) {
            return false;
        }
        boolean matched = false;
        Rectangle rect = new Rectangle(0, 0, AttachmentHelper.convertToBufferedImage(image1).getWidth(), AttachmentHelper.convertToBufferedImage(image1).getHeight());
        Iterator<Pixel> iter1 = AttachmentHelper.handlePixels(image1, rect);
        Iterator<Pixel> iter2 = AttachmentHelper.handlePixels(image2, rect);
        while (iter1.hasNext() && iter2.hasNext()) {
            Pixel pixel = iter1.next();
            matched = pixel.equals(iter2.next());
        }
        return matched;
    }

    private static Iterator<Pixel> handlePixels(Image img, Rectangle rect) {
        int x = rect.x;
        int y = rect.y;
        int w = rect.width;
        int h = rect.height;
        int[] pixels = new int[w * h];
        PixelGrabber pg = new PixelGrabber(img, x, y, w, h, pixels, 0, w);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            System.err.println("interrupted waiting for pixels!");
            return null;
        }
        if ((pg.getStatus() & 0x80) != 0) {
            System.err.println("image fetch aborted or errored");
            return null;
        }
        ArrayList<Pixel> tmpList = new ArrayList<Pixel>();
        for (int j = 0; j < h; ++j) {
            for (int i = 0; i < w; ++i) {
                tmpList.add(AttachmentHelper.handleSinglePixel(x + i, y + j, pixels[j * w + i]));
            }
        }
        return tmpList.iterator();
    }

    private static Pixel handleSinglePixel(int x, int y, int pixel) {
        int alpha = pixel >> 24 & 0xFF;
        int red = pixel >> 16 & 0xFF;
        int green = pixel >> 8 & 0xFF;
        int blue = pixel & 0xFF;
        return new Pixel(alpha, red, green, blue);
    }

    private static class Pixel {
        private int a;
        private int r;
        private int g;
        private int b;

        Pixel(int a, int r, int g, int b) {
            this.a = a;
            this.r = r;
            this.g = g;
            this.b = b;
        }

        protected boolean equals(Pixel p) {
            return p.a == this.a && p.r == this.r && p.g == this.g && p.b == this.b;
        }
    }
}

