/*
 * Decompiled with CFR 0.152.
 */
package testutil;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class WSDLAddressPatcher
extends Task {
    private String address;
    private File wsdl;

    public void setAddress(String address) {
        this.address = address;
    }

    public void setWsdl(File wsdl) {
        this.wsdl = wsdl;
    }

    public void execute() throws BuildException {
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(this.wsdl);
            this.patch(null, doc.getDocumentElement());
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(new FileOutputStream(this.wsdl));
            transformer.transform(source, result);
        }
        catch (IOException | ParserConfigurationException | TransformerException | SAXException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private void patch(String portName, Element e) {
        NodeList nl;
        Element wsaEprEl;
        String loc;
        if ("http://schemas.xmlsoap.org/wsdl/".equals(e.getNamespaceURI()) && "port".equals(e.getLocalName())) {
            portName = e.getAttribute("name");
        }
        if ("address".equals(e.getLocalName()) && (loc = e.getAttribute("location")) != null) {
            e.setAttribute("location", this.address.replace('\\', '/').replace("#PORTNAME#", portName));
        }
        Element element = wsaEprEl = (nl = e.getElementsByTagNameNS("http://www.w3.org/2005/08/addressing", "EndpointReference")).getLength() > 0 ? (Element)nl.item(0) : null;
        if (wsaEprEl != null) {
            Element wsaAddrEl;
            nl = e.getElementsByTagNameNS("http://www.w3.org/2005/08/addressing", "Address");
            Element element2 = wsaAddrEl = nl.getLength() > 0 ? (Element)nl.item(0) : null;
            if (wsaAddrEl != null) {
                wsaAddrEl.setTextContent(this.address.replace('\\', '/').replace("#PORTNAME#", portName));
            }
        }
        NodeList children = e.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!Element.class.isAssignableFrom(child.getClass())) continue;
            this.patch(portName, (Element)child);
        }
    }
}

