/*
 * Decompiled with CFR 0.152.
 */
package testutil;

import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.transport.http.DeploymentDescriptorParser;
import com.sun.xml.ws.transport.http.HttpAdapter;
import com.sun.xml.ws.transport.http.HttpAdapterList;
import com.sun.xml.ws.transport.http.ResourceLoader;
import com.sun.xml.ws.transport.http.server.EndpointImpl;
import com.sun.xml.ws.transport.local.FileSystemResourceLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.Expand;
import org.apache.tools.ant.types.FileSet;

public class JaxwsHttpServer {
    private HttpServer appServer;
    private ExecutorService appExecutorService;
    private HttpServer adminServer;
    private ExecutorService adminExecutorService;
    private String sepChar;
    private File webappsDir;
    private File classesDir;
    private Map<String, WarInfo> deployedWARs;
    private boolean stopped;

    public JaxwsHttpServer() throws Exception {
        String j2seServerDir = System.getProperty("j2se.server.home");
        System.out.println("Server dir=" + j2seServerDir);
        this.sepChar = System.getProperty("file.separator");
        this.webappsDir = new File(j2seServerDir + this.sepChar + "webapps");
        this.classesDir = new File(this.webappsDir, "classes");
        System.out.println("webapps dir=" + this.webappsDir.getAbsolutePath());
        this.deployedWARs = new HashMap<String, WarInfo>();
        this.start();
    }

    public static void main(String[] args) throws Exception {
        new JaxwsHttpServer();
    }

    public void createDeployThread() {
        new Thread(new DeployWAR()).start();
    }

    public synchronized boolean isStopped() {
        return this.stopped;
    }

    public synchronized void stopped() {
        this.stopped = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deployWAR(String warName) throws Exception {
        block6: {
            try {
                if (this.deployedWARs.get(warName) != null) break block6;
                try {
                    System.out.println("Deploying " + warName);
                    File warDirFile = this.expandWAR(warName);
                    for (Adapter adapter : this.parseSunJaxws(warDirFile)) {
                        this.createEndpoint(adapter, warDirFile);
                    }
                }
                finally {
                    this.deployedWARs.put(warName, new WarInfo());
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public void deployWAR(HttpExchange msg, String war) throws Exception {
        this.deployWAR(war);
        this.writeStatus(msg, 200, "DEPLOY OK " + war);
    }

    private File expandWAR(String war) throws IOException {
        String warDirName = war.substring(0, war.length() - 4);
        File warDirFile = new File(this.webappsDir, warDirName);
        if (warDirFile.exists()) {
            System.out.println("Already expanded " + war);
            return warDirFile;
        }
        System.out.println("Expanding war " + war);
        File src = new File(this.webappsDir, war);
        System.out.println("WAR path=" + src.getAbsolutePath());
        System.out.println("WAR dest path=" + warDirFile.getAbsolutePath());
        Expand e = new Expand();
        e.setProject(new Project());
        e.setDest(warDirFile);
        e.setSrc(src);
        e.setTaskType("unzip");
        e.execute();
        System.out.println("Copying classes for " + war);
        FileSet srcSet = new FileSet();
        srcSet.setDir(new File(warDirFile, "WEB-INF/classes"));
        srcSet.setIncludes("**");
        Copy copy = new Copy();
        copy.setProject(new Project());
        copy.setTodir(this.classesDir);
        copy.addFileset(srcSet);
        copy.setTaskType("copy");
        copy.execute();
        return warDirFile;
    }

    private List<Adapter> parseSunJaxws(File warDirFile) throws Exception {
        File ddFile = new File(warDirFile, "WEB-INF" + this.sepChar + "sun-jaxws.xml");
        System.out.println("dd file=" + ddFile.getName());
        DeploymentDescriptorParser parser = new DeploymentDescriptorParser(this.getClass().getClassLoader(), (ResourceLoader)new FileSystemResourceLoader(warDirFile), null, (DeploymentDescriptorParser.AdapterFactory)new AdapterList());
        return parser.parse(ddFile);
    }

    private void createEndpoint(Adapter adapter, File warDirFile) throws Exception {
        String urlPattern = adapter.urlPattern;
        if (urlPattern.endsWith("/*")) {
            urlPattern = urlPattern.substring(0, urlPattern.length() - 2);
        }
        String warDirName = warDirFile.getName();
        String contextRoot = "/" + warDirName + urlPattern;
        System.out.println("Context Root=" + contextRoot);
        HttpContext context = this.appServer.createContext(contextRoot);
        EndpointImpl endpoint = new EndpointImpl(adapter.getEndpoint(), (Object)context);
    }

    public void collectMetadata(File wsdlDirFile, List<File> metadataFile) {
        File[] files = wsdlDirFile.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                this.collectMetadata(file, metadataFile);
                continue;
            }
            metadataFile.add(file);
        }
    }

    public void undeployWAR(HttpExchange msg, String war) throws IOException {
        System.out.println("Undeploy war=" + war);
        this.writeStatus(msg, 200, "UNDEPLOY OK " + war);
    }

    public void stop(HttpExchange msg) throws IOException {
        System.out.println("Stop ");
        this.stopped();
        this.appServer.stop(2);
        this.appExecutorService.shutdown();
        System.out.println("AppServer Stopped ");
        this.writeStatus(msg, 200, "STOP OK ");
        this.adminServer.stop(2);
        this.adminExecutorService.shutdown();
        System.out.println("AdminServer Stopped ");
    }

    private void startAppServer() throws Exception {
        this.appServer = HttpServer.create(new InetSocketAddress(8080), 5);
        this.appExecutorService = Executors.newFixedThreadPool(5);
        this.appServer.setExecutor(this.appExecutorService);
        this.appServer.start();
        System.out.println("AppServer started");
    }

    private void start() throws Exception {
        this.startAppServer();
        this.startAdminServer();
        this.createDeployThread();
    }

    public void startAdminServer() throws Exception {
        InetSocketAddress inetAddress = new InetSocketAddress(9999);
        this.adminServer = HttpServer.create(inetAddress, 5);
        this.adminExecutorService = Executors.newFixedThreadPool(5);
        this.adminServer.setExecutor(this.adminExecutorService);
        HttpContext context = this.adminServer.createContext("/admin");
        context.setHandler(new HttpHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handle(HttpExchange msg) {
                try {
                    System.out.println("Received HTTP request:" + msg.getRequestURI());
                    String method = msg.getRequestMethod();
                    if ("GET".equals(method)) {
                        InputStream is = msg.getRequestBody();
                        JaxwsHttpServer.readFully(is);
                        is.close();
                        JaxwsHttpServer.this.writeGetReply(msg);
                    } else {
                        System.out.println("****** METHOD not handled ***** " + method);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    msg.close();
                }
            }
        });
        this.adminServer.start();
        System.out.println("AdminServer started");
    }

    protected void writeGetReply(HttpExchange msg) throws Exception {
        String queryString = msg.getRequestURI().getQuery();
        System.out.println("queryString=" + queryString);
        if (queryString.startsWith("deploy=")) {
            int index = queryString.indexOf("=");
            String warName = null;
            if (index != -1) {
                warName = queryString.substring(index + 1);
                this.deployWAR(msg, warName);
            } else {
                this.writeStatus(msg, 200, "Don't know " + queryString);
            }
        } else if (queryString.startsWith("undeploy=")) {
            int index = queryString.indexOf("=");
            String warName = null;
            if (index != -1) {
                warName = queryString.substring(index + 1);
                this.undeployWAR(msg, warName);
            } else {
                this.writeStatus(msg, 200, "Don't know " + queryString);
            }
        } else if (queryString.startsWith("stop")) {
            this.stop(msg);
        } else {
            this.writeStatus(msg, 200, "Don't know " + queryString);
        }
    }

    private void writeStatus(HttpExchange msg, int code, String message) throws IOException {
        msg.getResponseHeaders().add("Content-Type", "text/html");
        msg.sendResponseHeaders(code, 0L);
        OutputStream outputStream = msg.getResponseBody();
        PrintWriter out = new PrintWriter(outputStream);
        out.println("<html><head><title>");
        out.println("JaxwsHttpServer Status");
        out.println("</title></head><body>");
        out.println(message);
        out.println("</body></html>");
        out.close();
    }

    private static void readFully(InputStream is) throws IOException {
        byte[] buf = new byte[1024];
        if (is != null) {
            while (is.read(buf) != -1) {
            }
        }
    }

    public class DeployWAR
    implements Runnable {
        @Override
        public void run() {
            System.out.println("Starting DeployWAR thread");
            while (!JaxwsHttpServer.this.isStopped()) {
                try {
                    File[] fileList = JaxwsHttpServer.this.webappsDir.listFiles();
                    if (fileList != null) {
                        for (File file : fileList) {
                            if (!file.isFile()) continue;
                            JaxwsHttpServer.this.deployWAR(file.getName());
                        }
                    }
                    Thread.sleep(10000L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            System.out.println("Stopping DeployWAR thread");
        }
    }

    static final class Adapter
    extends HttpAdapter {
        final String urlPattern;

        public Adapter(WSEndpoint endpoint, String urlPattern, AdapterList owner) {
            super(endpoint, (HttpAdapterList)owner);
            this.urlPattern = urlPattern;
        }
    }

    public class WarInfo {
    }

    static final class AdapterList
    extends HttpAdapterList<Adapter>
    implements DeploymentDescriptorParser.AdapterFactory<Adapter> {
        AdapterList() {
        }

        protected Adapter createHttpAdapter(String name, String urlPattern, WSEndpoint<?> endpoint) {
            return new Adapter(endpoint, urlPattern, this);
        }
    }
}

