/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.processor.modeler.annotation;

import com.sun.codemodel.ClassType;
import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JAnnotationArrayMember;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JCommentPart;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.codemodel.writer.ProgressCodeWriter;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.InterfaceDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.MirroredTypeException;
import com.sun.mirror.type.ReferenceType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.type.VoidType;
import com.sun.tools.jxc.apt.InlineAnnotationReaderImpl;
import com.sun.tools.jxc.model.nav.APTNavigator;
import com.sun.tools.ws.processor.generator.GeneratorBase;
import com.sun.tools.ws.processor.generator.Names;
import com.sun.tools.ws.processor.modeler.ModelerException;
import com.sun.tools.ws.processor.modeler.annotation.AnnotationProcessorContext;
import com.sun.tools.ws.processor.modeler.annotation.FaultInfo;
import com.sun.tools.ws.processor.modeler.annotation.MakeSafeTypeVisitor;
import com.sun.tools.ws.processor.modeler.annotation.MemberInfo;
import com.sun.tools.ws.processor.modeler.annotation.ModelBuilder;
import com.sun.tools.ws.processor.modeler.annotation.TypeMonikerFactory;
import com.sun.tools.ws.processor.modeler.annotation.WebServiceVisitor;
import com.sun.tools.ws.processor.modeler.annotation.WrapperInfo;
import com.sun.tools.ws.processor.util.DirectoryUtil;
import com.sun.tools.ws.resources.WebserviceapMessages;
import com.sun.tools.ws.util.ClassNameInfo;
import com.sun.tools.ws.wscompile.FilerCodeWriter;
import com.sun.tools.ws.wscompile.WsgenOptions;
import com.sun.tools.ws.wsdl.document.soap.SOAPStyle;
import com.sun.xml.bind.v2.model.annotation.AnnotationReader;
import com.sun.xml.bind.v2.model.nav.Navigator;
import com.sun.xml.ws.model.AbstractWrapperBeanGenerator;
import com.sun.xml.ws.spi.db.BindingHelper;
import com.sun.xml.ws.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jws.Oneway;
import javax.jws.WebMethod;
import javax.jws.WebService;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttachmentRef;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlList;
import javax.xml.bind.annotation.XmlMimeType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.namespace.QName;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;
import javax.xml.ws.WebFault;
import javax.xml.ws.WebServiceException;

public class WebServiceWrapperGenerator
extends WebServiceVisitor {
    private Set<String> wrapperNames;
    private Set<String> processedExceptions;
    private JCodeModel cm;
    private final MakeSafeTypeVisitor makeSafeVisitor;
    private static final FieldFactory FIELD_FACTORY = new FieldFactory();
    private final AbstractWrapperBeanGenerator APT_GENERATOR;

    public WebServiceWrapperGenerator(ModelBuilder builder, AnnotationProcessorContext context) {
        super(builder, context);
        this.APT_GENERATOR = new APTWrapperBeanGenerator((AnnotationReader<TypeMirror, TypeDeclaration, ?, MethodDeclaration>)InlineAnnotationReaderImpl.theInstance, (Navigator<TypeMirror, TypeDeclaration, ?, MethodDeclaration>)new APTNavigator(this.builder.getAPEnv()), FIELD_FACTORY);
        this.makeSafeVisitor = new MakeSafeTypeVisitor(builder.getAPEnv());
    }

    @Override
    protected void processWebService(WebService webService, TypeDeclaration d) {
        this.cm = new JCodeModel();
        this.wrapperNames = new HashSet<String>();
        this.processedExceptions = new HashSet<String>();
    }

    @Override
    protected void postProcessWebService(WebService webService, InterfaceDeclaration d) {
        super.postProcessWebService(webService, d);
        this.doPostProcessWebService(webService, (TypeDeclaration)d);
    }

    @Override
    protected void postProcessWebService(WebService webService, ClassDeclaration d) {
        super.postProcessWebService(webService, d);
        this.doPostProcessWebService(webService, (TypeDeclaration)d);
    }

    protected void doPostProcessWebService(WebService webService, TypeDeclaration d) {
        if (this.cm != null) {
            File sourceDir = this.builder.getSourceDir();
            assert (sourceDir != null);
            WsgenOptions options = this.builder.getOptions();
            try {
                FilerCodeWriter cw = new FilerCodeWriter(sourceDir, options);
                if (options.verbose) {
                    cw = new ProgressCodeWriter((CodeWriter)cw, System.out);
                }
                this.cm.build((CodeWriter)cw);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected void processMethod(MethodDeclaration method, WebMethod webMethod) {
        this.builder.log("WrapperGen - method: " + method);
        this.builder.log("method.getDeclaringType(): " + method.getDeclaringType());
        boolean generatedWrapper = false;
        if (this.wrapped && this.soapStyle.equals(SOAPStyle.DOCUMENT)) {
            generatedWrapper = this.generateWrappers(method, webMethod);
        }
        boolean bl = generatedWrapper = this.generateExceptionBeans(method) || generatedWrapper;
        if (generatedWrapper) {
            this.builder.setWrapperGenerated(generatedWrapper);
        }
    }

    private boolean generateExceptionBeans(MethodDeclaration method) {
        String beanPackage = this.packageName + ".jaxws.";
        if (this.packageName.length() == 0) {
            beanPackage = "jaxws.";
        }
        boolean beanGenerated = false;
        for (ReferenceType thrownType : method.getThrownTypes()) {
            ClassDeclaration typeDecl = ((com.sun.mirror.type.ClassType)thrownType).getDeclaration();
            if (typeDecl == null) {
                this.builder.onError(WebserviceapMessages.WEBSERVICEAP_COULD_NOT_FIND_TYPEDECL(thrownType.toString(), this.context.getRound()));
                return false;
            }
            boolean tmp = this.generateExceptionBean(typeDecl, beanPackage);
            beanGenerated = beanGenerated || tmp;
        }
        return beanGenerated;
    }

    private boolean duplicateName(String name) {
        for (String str : this.wrapperNames) {
            if (!str.equalsIgnoreCase(name)) continue;
            return true;
        }
        this.wrapperNames.add(name);
        return false;
    }

    private boolean generateWrappers(MethodDeclaration method, WebMethod webMethod) {
        boolean isOneway = method.getAnnotation(Oneway.class) != null;
        String beanPackage = this.packageName + ".jaxws.";
        if (this.packageName.length() == 0) {
            beanPackage = "jaxws.";
        }
        String methodName = method.getSimpleName();
        String operationName = this.builder.getOperationName(methodName);
        String reqName = operationName = webMethod != null && webMethod.operationName().length() > 0 ? webMethod.operationName() : operationName;
        String resName = operationName + "Response";
        String reqNamespace = this.typeNamespace;
        String resNamespace = this.typeNamespace;
        String requestClassName = beanPackage + StringUtils.capitalize((String)method.getSimpleName());
        RequestWrapper reqWrapper = (RequestWrapper)method.getAnnotation(RequestWrapper.class);
        if (reqWrapper != null) {
            if (reqWrapper.className().length() > 0) {
                requestClassName = reqWrapper.className();
            }
            if (reqWrapper.localName().length() > 0) {
                reqName = reqWrapper.localName();
            }
            if (reqWrapper.targetNamespace().length() > 0) {
                reqNamespace = reqWrapper.targetNamespace();
            }
        }
        this.builder.log("requestWrapper: " + requestClassName);
        File file = new File(DirectoryUtil.getOutputDirectoryFor(requestClassName, this.builder.getSourceDir()), Names.stripQualifier(requestClassName) + ".java");
        this.builder.getOptions().addGeneratedFile(file);
        boolean canOverwriteRequest = this.builder.canOverWriteClass(requestClassName);
        if (!canOverwriteRequest) {
            this.builder.log("Class " + requestClassName + " exists. Not overwriting.");
        }
        if (this.duplicateName(requestClassName) && canOverwriteRequest) {
            this.builder.onError(WebserviceapMessages.WEBSERVICEAP_METHOD_REQUEST_WRAPPER_BEAN_NAME_NOT_UNIQUE(this.typeDecl.getQualifiedName(), method.toString()));
        }
        String responseClassName = null;
        boolean canOverwriteResponse = canOverwriteRequest;
        if (!isOneway) {
            responseClassName = beanPackage + StringUtils.capitalize((String)method.getSimpleName()) + "Response";
            ResponseWrapper resWrapper = (ResponseWrapper)method.getAnnotation(ResponseWrapper.class);
            if (resWrapper != null) {
                if (resWrapper.className().length() > 0) {
                    responseClassName = resWrapper.className();
                }
                if (resWrapper.localName().length() > 0) {
                    resName = resWrapper.localName();
                }
                if (resWrapper.targetNamespace().length() > 0) {
                    resNamespace = resWrapper.targetNamespace();
                }
            }
            if (!(canOverwriteResponse = this.builder.canOverWriteClass(responseClassName))) {
                this.builder.log("Class " + responseClassName + " exists. Not overwriting.");
            }
            if (this.duplicateName(responseClassName) && canOverwriteResponse) {
                this.builder.onError(WebserviceapMessages.WEBSERVICEAP_METHOD_RESPONSE_WRAPPER_BEAN_NAME_NOT_UNIQUE(this.typeDecl.getQualifiedName(), method.toString()));
            }
            file = new File(DirectoryUtil.getOutputDirectoryFor(responseClassName, this.builder.getSourceDir()), Names.stripQualifier(responseClassName) + ".java");
            this.builder.getOptions().addGeneratedFile(file);
        }
        WrapperInfo reqWrapperInfo = new WrapperInfo(requestClassName);
        WrapperInfo resWrapperInfo = null;
        if (!isOneway) {
            resWrapperInfo = new WrapperInfo(responseClassName);
        }
        this.seiContext.setReqWrapperOperation(method, reqWrapperInfo);
        if (!isOneway) {
            this.seiContext.setResWrapperOperation(method, resWrapperInfo);
        }
        try {
            if (!canOverwriteRequest && !canOverwriteResponse) {
                return false;
            }
            JDefinedClass reqCls = null;
            if (canOverwriteRequest) {
                reqCls = this.getCMClass(requestClassName, ClassType.CLASS);
            }
            JDefinedClass resCls = null;
            if (!isOneway && canOverwriteResponse) {
                resCls = this.getCMClass(responseClassName, ClassType.CLASS);
            }
            this.writeXmlElementDeclaration(reqCls, reqName, reqNamespace);
            this.writeXmlElementDeclaration(resCls, resName, resNamespace);
            List reqMembers = this.APT_GENERATOR.collectRequestBeanMembers((Object)method);
            List resMembers = this.APT_GENERATOR.collectResponseBeanMembers((Object)method);
            this.writeXmlTypeDeclaration(reqCls, reqName, reqNamespace, reqMembers);
            this.writeXmlTypeDeclaration(resCls, resName, resNamespace, resMembers);
            this.writeMembers(reqCls, reqMembers);
            this.writeMembers(resCls, resMembers);
        }
        catch (Exception e) {
            throw new ModelerException("modeler.nestedGeneratorError", e);
        }
        return true;
    }

    private TypeMirror getSafeType(TypeMirror type) {
        return (TypeMirror)this.makeSafeVisitor.apply(type, this.builder.getAPEnv().getTypeUtils());
    }

    private JType getType(TypeMirror typeMirror) {
        String type = typeMirror.toString();
        try {
            return this.cm.parseType(type);
        }
        catch (ClassNotFoundException e) {
            return this.cm.ref(type);
        }
    }

    private void writeMembers(JDefinedClass cls, Collection<MemberInfo> members) {
        if (cls == null) {
            return;
        }
        for (MemberInfo memInfo : members) {
            JType type = this.getType(memInfo.getParamType());
            JFieldVar field = cls.field(4, type, memInfo.getParamName());
            this.annotateParameterWithJAXBAnnotations(memInfo, field);
        }
        for (MemberInfo memInfo : members) {
            this.writeMember(cls, memInfo.getParamType(), memInfo.getParamName());
        }
    }

    private void annotateParameterWithJAXBAnnotations(MemberInfo memInfo, JFieldVar field) {
        List<Annotation> jaxbAnnotations = memInfo.getJaxbAnnotations();
        for (Annotation ann : jaxbAnnotations) {
            JAnnotationUse jaxbAnn;
            if (ann instanceof XmlMimeType) {
                jaxbAnn = field.annotate(XmlMimeType.class);
                jaxbAnn.param("value", ((XmlMimeType)ann).value());
                continue;
            }
            if (ann instanceof XmlJavaTypeAdapter) {
                jaxbAnn = field.annotate(XmlJavaTypeAdapter.class);
                XmlJavaTypeAdapter ja = (XmlJavaTypeAdapter)ann;
                try {
                    ja.value();
                    throw new AssertionError();
                }
                catch (MirroredTypeException e) {
                    jaxbAnn.param("value", this.getType(e.getTypeMirror()));
                    continue;
                }
            }
            if (ann instanceof XmlAttachmentRef) {
                field.annotate(XmlAttachmentRef.class);
                continue;
            }
            if (ann instanceof XmlList) {
                field.annotate(XmlList.class);
                continue;
            }
            if (ann instanceof XmlElement) {
                XmlElement elemAnn = (XmlElement)ann;
                JAnnotationUse jAnn = field.annotate(XmlElement.class);
                jAnn.param("name", elemAnn.name());
                jAnn.param("namespace", elemAnn.namespace());
                if (elemAnn.nillable()) {
                    jAnn.param("nillable", true);
                }
                if (!elemAnn.required()) continue;
                jAnn.param("required", true);
                continue;
            }
            throw new WebServiceException("SEI Parameter cannot have this JAXB annotation: " + ann);
        }
    }

    protected JDefinedClass getCMClass(String className, ClassType type) {
        JDefinedClass cls;
        try {
            cls = this.cm._class(className, type);
        }
        catch (JClassAlreadyExistsException e) {
            cls = this.cm._getClass(className);
        }
        return cls;
    }

    private boolean generateExceptionBean(ClassDeclaration thrownDecl, String beanPackage) {
        boolean canOverWriteBean;
        if (!this.builder.isServiceException((TypeDeclaration)thrownDecl)) {
            return false;
        }
        String exceptionName = ClassNameInfo.getName(thrownDecl.getQualifiedName());
        if (this.processedExceptions.contains(exceptionName)) {
            return false;
        }
        this.processedExceptions.add(exceptionName);
        WebFault webFault = (WebFault)thrownDecl.getAnnotation(WebFault.class);
        String className = beanPackage + exceptionName + "Bean";
        Collection members = this.APT_GENERATOR.collectExceptionBeanMembers((Object)thrownDecl);
        boolean isWSDLException = this.isWSDLException(members, thrownDecl);
        String namespace = this.typeNamespace;
        String name = exceptionName;
        if (isWSDLException) {
            TypeMirror beanType = this.getFaultInfoMember(members).getParamType();
            FaultInfo faultInfo = new FaultInfo(TypeMonikerFactory.getTypeMoniker(beanType), true);
            namespace = webFault.targetNamespace().length() > 0 ? webFault.targetNamespace() : namespace;
            name = webFault.name().length() > 0 ? webFault.name() : name;
            faultInfo.setElementName(new QName(namespace, name));
            this.seiContext.addExceptionBeanEntry(thrownDecl.getQualifiedName(), faultInfo, this.builder);
            return false;
        }
        if (webFault != null) {
            namespace = webFault.targetNamespace().length() > 0 ? webFault.targetNamespace() : namespace;
            name = webFault.name().length() > 0 ? webFault.name() : name;
            className = webFault.faultBean().length() > 0 ? webFault.faultBean() : className;
        }
        JDefinedClass cls = this.getCMClass(className, ClassType.CLASS);
        FaultInfo faultInfo = new FaultInfo(className, false);
        if (this.duplicateName(className)) {
            this.builder.onError(WebserviceapMessages.WEBSERVICEAP_METHOD_EXCEPTION_BEAN_NAME_NOT_UNIQUE(this.typeDecl.getQualifiedName(), thrownDecl.getQualifiedName()));
        }
        if (!(canOverWriteBean = this.builder.canOverWriteClass(className))) {
            this.builder.log("Class " + className + " exists. Not overwriting.");
            this.seiContext.addExceptionBeanEntry(thrownDecl.getQualifiedName(), faultInfo, this.builder);
            return false;
        }
        if (this.seiContext.getExceptionBeanName(thrownDecl.getQualifiedName()) != null) {
            return false;
        }
        JDocComment comment = cls.javadoc();
        for (String doc : GeneratorBase.getJAXWSClassComment(this.builder.getSourceVersion())) {
            comment.add((Object)doc);
        }
        this.writeXmlElementDeclaration(cls, name, namespace);
        XmlType xmlType = (XmlType)thrownDecl.getAnnotation(XmlType.class);
        String xmlTypeName = xmlType != null && !xmlType.name().equals("##default") ? xmlType.name() : exceptionName;
        String xmlTypeNamespace = xmlType != null && !xmlType.namespace().equals("##default") ? xmlType.namespace() : this.typeNamespace;
        this.writeXmlTypeDeclaration(cls, xmlTypeName, xmlTypeNamespace, members);
        this.writeMembers(cls, members);
        this.seiContext.addExceptionBeanEntry(thrownDecl.getQualifiedName(), faultInfo, this.builder);
        return true;
    }

    protected boolean isWSDLException(Collection<MemberInfo> members, ClassDeclaration thrownDecl) {
        WebFault webFault = (WebFault)thrownDecl.getAnnotation(WebFault.class);
        if (webFault == null) {
            return false;
        }
        return members.size() == 2 && this.getFaultInfoMember(members) != null;
    }

    private MemberInfo getFaultInfoMember(Collection<MemberInfo> members) {
        for (MemberInfo member : members) {
            if (!member.getParamName().equals("faultInfo")) continue;
            return member;
        }
        return null;
    }

    private void writeXmlElementDeclaration(JDefinedClass cls, String elementName, String namespaceUri) {
        if (cls == null) {
            return;
        }
        JAnnotationUse xmlRootElementAnn = cls.annotate(XmlRootElement.class);
        xmlRootElementAnn.param("name", elementName);
        if (namespaceUri.length() > 0) {
            xmlRootElementAnn.param("namespace", namespaceUri);
        }
        JAnnotationUse xmlAccessorTypeAnn = cls.annotate(this.cm.ref(XmlAccessorType.class));
        xmlAccessorTypeAnn.param("value", (Enum)XmlAccessType.FIELD);
    }

    private void writeXmlTypeDeclaration(JDefinedClass cls, String typeName, String namespaceUri, Collection<MemberInfo> members) {
        if (cls == null) {
            return;
        }
        JAnnotationUse xmlTypeAnn = cls.annotate(this.cm.ref(XmlType.class));
        xmlTypeAnn.param("name", typeName);
        xmlTypeAnn.param("namespace", namespaceUri);
        if (members.size() > 1) {
            JAnnotationArrayMember paramArray = xmlTypeAnn.paramArray("propOrder");
            for (MemberInfo memInfo : members) {
                paramArray.param(memInfo.getParamName());
            }
        }
    }

    private void writeMember(JDefinedClass cls, TypeMirror paramType, String paramName) {
        if (cls == null) {
            return;
        }
        String accessorName = BindingHelper.mangleNameToPropertyName((String)paramName);
        String getterPrefix = paramType.toString().equals("boolean") ? "is" : "get";
        JType propType = this.getType(paramType);
        JMethod m = cls.method(1, propType, getterPrefix + accessorName);
        JDocComment methodDoc = m.javadoc();
        JCommentPart ret = methodDoc.addReturn();
        ret.add((Object)("returns " + propType.name()));
        JBlock body = m.body();
        body._return((JExpression)JExpr._this().ref(paramName));
        m = cls.method(1, (JType)this.cm.VOID, "set" + accessorName);
        JVar param = m.param(propType, paramName);
        methodDoc = m.javadoc();
        JCommentPart part = methodDoc.addParam(paramName);
        part.add((Object)("the value for the " + paramName + " property"));
        body = m.body();
        body.assign((JAssignmentTarget)JExpr._this().ref(paramName), (JExpression)param);
    }

    private static final class FieldFactory
    implements AbstractWrapperBeanGenerator.BeanMemberFactory<TypeMirror, MemberInfo> {
        private FieldFactory() {
        }

        public MemberInfo createWrapperBeanMember(TypeMirror paramType, String paramName, List<Annotation> jaxb) {
            return new MemberInfo(paramType, paramName, jaxb);
        }
    }

    private final class APTWrapperBeanGenerator
    extends AbstractWrapperBeanGenerator<TypeMirror, TypeDeclaration, MethodDeclaration, MemberInfo> {
        protected APTWrapperBeanGenerator(AnnotationReader<TypeMirror, TypeDeclaration, ?, MethodDeclaration> annReader, Navigator<TypeMirror, TypeDeclaration, ?, MethodDeclaration> nav, AbstractWrapperBeanGenerator.BeanMemberFactory<TypeMirror, MemberInfo> beanMemberFactory) {
            super(annReader, nav, beanMemberFactory);
        }

        protected TypeMirror getSafeType(TypeMirror type) {
            return WebServiceWrapperGenerator.this.getSafeType(type);
        }

        protected TypeMirror getHolderValueType(TypeMirror paramType) {
            return WebServiceWrapperGenerator.this.builder.getHolderValueType(paramType);
        }

        protected boolean isVoidType(TypeMirror type) {
            return type instanceof VoidType;
        }
    }
}

