/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.processor.model;

import com.sun.tools.ws.processor.model.Block;
import com.sun.tools.ws.processor.model.Fault;
import com.sun.tools.ws.processor.model.ModelException;
import com.sun.tools.ws.processor.model.ModelObject;
import com.sun.tools.ws.processor.model.ModelVisitor;
import com.sun.tools.ws.processor.model.Request;
import com.sun.tools.ws.processor.model.Response;
import com.sun.tools.ws.processor.model.java.JavaMethod;
import com.sun.tools.ws.wsdl.document.soap.SOAPStyle;
import com.sun.tools.ws.wsdl.document.soap.SOAPUse;
import com.sun.xml.bind.api.JAXBRIContext;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Operation
extends ModelObject {
    private String customizedName;
    private boolean _isWrapped = true;
    private QName _name;
    private String _uniqueName;
    private Request _request;
    private Response _response;
    private JavaMethod _javaMethod;
    private String _soapAction;
    private SOAPStyle _style = SOAPStyle.DOCUMENT;
    private SOAPUse _use = SOAPUse.LITERAL;
    private Set<String> _faultNames;
    private Set<Fault> _faults;
    private com.sun.tools.ws.wsdl.document.Operation wsdlOperation;

    public Operation() {
    }

    public Operation(Operation operation) {
        this(operation._name);
        this._style = operation._style;
        this._use = operation._use;
        this.customizedName = operation.customizedName;
    }

    public Operation(QName name) {
        this._name = name;
        this._uniqueName = name.getLocalPart();
        this._faultNames = new HashSet<String>();
        this._faults = new HashSet<Fault>();
    }

    public QName getName() {
        return this._name;
    }

    public void setName(QName n) {
        this._name = n;
    }

    public String getUniqueName() {
        return this._uniqueName;
    }

    public void setUniqueName(String s) {
        this._uniqueName = s;
    }

    public Request getRequest() {
        return this._request;
    }

    public void setRequest(Request r) {
        this._request = r;
    }

    public Response getResponse() {
        return this._response;
    }

    public void setResponse(Response r) {
        this._response = r;
    }

    public boolean isOverloaded() {
        return !this._name.getLocalPart().equals(this._uniqueName);
    }

    public void addFault(Fault f) {
        if (this._faultNames.contains(f.getName())) {
            throw new ModelException("model.uniqueness", new Object[0]);
        }
        this._faultNames.add(f.getName());
        this._faults.add(f);
    }

    public Iterator<Fault> getFaults() {
        return this._faults.iterator();
    }

    public Set<Fault> getFaultsSet() {
        return this._faults;
    }

    public void setFaultsSet(Set<Fault> s) {
        this._faults = s;
        this.initializeFaultNames();
    }

    private void initializeFaultNames() {
        this._faultNames = new HashSet<String>();
        if (this._faults != null) {
            for (Fault f : this._faults) {
                if (f.getName() != null && this._faultNames.contains(f.getName())) {
                    throw new ModelException("model.uniqueness", new Object[0]);
                }
                this._faultNames.add(f.getName());
            }
        }
    }

    public Iterator<Fault> getAllFaults() {
        Set<Fault> allFaults = this.getAllFaultsSet();
        return allFaults.iterator();
    }

    public Set<Fault> getAllFaultsSet() {
        HashSet<Fault> transSet = new HashSet<Fault>();
        transSet.addAll(this._faults);
        Iterator<Fault> iter = this._faults.iterator();
        while (iter.hasNext()) {
            Set tmpSet = iter.next().getAllFaultsSet();
            transSet.addAll(tmpSet);
        }
        return transSet;
    }

    public int getFaultCount() {
        return this._faults.size();
    }

    public Set<Block> getAllFaultBlocks() {
        HashSet<Block> blocks = new HashSet<Block>();
        for (Fault f : this._faults) {
            blocks.add(f.getBlock());
        }
        return blocks;
    }

    public JavaMethod getJavaMethod() {
        return this._javaMethod;
    }

    public void setJavaMethod(JavaMethod i) {
        this._javaMethod = i;
    }

    public String getSOAPAction() {
        return this._soapAction;
    }

    public void setSOAPAction(String s) {
        this._soapAction = s;
    }

    public SOAPStyle getStyle() {
        return this._style;
    }

    public void setStyle(SOAPStyle s) {
        this._style = s;
    }

    public SOAPUse getUse() {
        return this._use;
    }

    public void setUse(SOAPUse u) {
        this._use = u;
    }

    public boolean isWrapped() {
        return this._isWrapped;
    }

    public void setWrapped(boolean isWrapped) {
        this._isWrapped = isWrapped;
    }

    @Override
    public void accept(ModelVisitor visitor) throws Exception {
        visitor.visit(this);
    }

    public void setCustomizedName(String name) {
        this.customizedName = name;
    }

    public String getCustomizedName() {
        return this.customizedName;
    }

    public String getJavaMethodName() {
        if (this._javaMethod != null) {
            return this._javaMethod.getName();
        }
        if (this.customizedName != null) {
            return this.customizedName;
        }
        return JAXBRIContext.mangleNameToVariableName((String)this._name.getLocalPart());
    }

    public com.sun.tools.ws.wsdl.document.Operation getWSDLPortTypeOperation() {
        return this.wsdlOperation;
    }

    public void setWSDLPortTypeOperation(com.sun.tools.ws.wsdl.document.Operation wsdlOperation) {
        this.wsdlOperation = wsdlOperation;
    }
}

