/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.processor;

import com.sun.tools.ws.processor.ProcessorAction;
import com.sun.tools.ws.processor.ProcessorException;
import com.sun.tools.ws.processor.config.Configuration;
import com.sun.tools.ws.processor.config.ModelInfo;
import com.sun.tools.ws.processor.model.Model;
import com.sun.tools.ws.processor.util.ProcessorEnvironment;
import com.sun.xml.ws.util.exception.JAXWSExceptionBase;
import com.sun.xml.ws.util.localization.Localizable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class Processor {
    private final Properties _options;
    private final Configuration _configuration;
    private final List<ProcessorAction> _actions = new ArrayList<ProcessorAction>();
    private Model _model;
    private final boolean _printStackTrace;
    private final ProcessorEnvironment _env;

    public Processor(Configuration configuration, Properties options, Model model) {
        this(configuration, options);
        this._model = model;
    }

    public Processor(Configuration configuration, Properties options) {
        this._configuration = configuration;
        this._options = options;
        this._printStackTrace = Boolean.valueOf(this._options.getProperty("printStackTrace"));
        this._env = this._configuration.getEnvironment();
    }

    public void add(ProcessorAction action) {
        this._actions.add(action);
    }

    public Model getModel() {
        return this._model;
    }

    public void run() {
        this.runModeler();
        if (this._model != null) {
            this.runActions();
        }
    }

    public void runModeler() {
        try {
            ModelInfo modelInfo = this._configuration.getModelInfo();
            if (modelInfo == null) {
                throw new ProcessorException("processor.missing.model", new Object[0]);
            }
            this._model = modelInfo.buildModel(this._options);
        }
        catch (JAXWSExceptionBase e) {
            if (this._printStackTrace) {
                this._env.printStackTrace(e);
            }
            this._env.error((Localizable)e);
        }
    }

    public void runActions() {
        try {
            if (this._model == null) {
                return;
            }
            for (ProcessorAction action : this._actions) {
                action.perform(this._model, this._configuration, this._options);
            }
        }
        catch (JAXWSExceptionBase e) {
            if (this._printStackTrace || this._env.verbose()) {
                this._env.printStackTrace(e);
            }
            this._env.error((Localizable)e);
        }
    }
}

