/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.wsdl.parser;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.tools.ws.resources.WsdlMessages;
import com.sun.tools.ws.wscompile.ErrorReceiver;
import com.sun.tools.ws.wscompile.WsimportOptions;
import com.sun.tools.ws.wsdl.framework.ParseException;
import com.sun.tools.ws.wsdl.parser.DOMForest;
import com.sun.tools.ws.wsdl.parser.InternalizationLogic;
import com.sun.xml.ws.api.wsdl.parser.MetaDataResolver;
import com.sun.xml.ws.api.wsdl.parser.MetadataResolverFactory;
import com.sun.xml.ws.api.wsdl.parser.ServiceDescriptor;
import com.sun.xml.ws.util.DOMUtil;
import com.sun.xml.ws.util.ServiceFinder;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.LocatorImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MetadataFinder
extends DOMForest {
    public boolean isMexMetadata;
    private String rootWSDL;
    private Set<String> rootWsdls = new HashSet<String>();

    public MetadataFinder(InternalizationLogic logic, WsimportOptions options, ErrorReceiver errReceiver) {
        super(logic, options, errReceiver);
    }

    public void parseWSDL() throws SAXException, IOException {
        for (InputSource value : this.options.getWSDLs()) {
            Element doc;
            Document dom;
            String systemID = value.getSystemId();
            this.errorReceiver.pollAbort();
            if (this.options.entityResolver != null) {
                value = this.options.entityResolver.resolveEntity(null, systemID);
            }
            if (value == null) {
                value = new InputSource(systemID);
            }
            if ((dom = this.parse(value, true)) == null || (doc = dom.getDocumentElement()) == null) continue;
            if (doc.getNamespaceURI() == null || !doc.getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/") || !doc.getLocalName().equals("definitions")) {
                this.core.remove(systemID);
                this.rootDocuments.remove(systemID);
                this.errorReceiver.warning(this.locatorTable.getStartLocation(doc), WsdlMessages.INVALID_WSDL_WITH_DOOC(systemID, "{" + this.fixNull(doc.getNamespaceURI()) + "}" + doc.getLocalName()));
                dom = this.getFromMetadataResolver(systemID);
                if (dom == null) continue;
                doc = dom.getDocumentElement();
            }
            NodeList schemas = doc.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "schema");
            for (int i = 0; i < schemas.getLength(); ++i) {
                if (this.inlinedSchemaElements.contains(schemas.item(i))) continue;
                this.inlinedSchemaElements.add((Element)schemas.item(i));
            }
        }
        this.identifyRootWslds();
    }

    @Nullable
    public String getRootWSDL() {
        return this.rootWSDL;
    }

    @NotNull
    public Set<String> getRootWSDLs() {
        return this.rootWsdls;
    }

    private void identifyRootWslds() {
        for (String location : this.rootDocuments) {
            Element definition;
            Document doc = this.get(location);
            if (doc == null || (definition = doc.getDocumentElement()) == null || !definition.getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/") || !definition.getLocalName().equals("definitions")) continue;
            this.rootWsdls.add(location);
            NodeList nl = definition.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "service");
            if (nl.getLength() <= 0) continue;
            this.rootWSDL = location;
        }
    }

    private String fixNull(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    private Document getFromMetadataResolver(String systemId) {
        MetaDataResolver resolver = null;
        ServiceDescriptor serviceDescriptor = null;
        for (MetadataResolverFactory resolverFactory : ServiceFinder.find(MetadataResolverFactory.class)) {
            resolver = resolverFactory.metadataResolver(this.options.entityResolver);
            try {
                serviceDescriptor = resolver.resolve(new URI(systemId));
                if (serviceDescriptor == null) continue;
                break;
            }
            catch (URISyntaxException e) {
                throw new ParseException(e);
            }
        }
        if (serviceDescriptor != null) {
            return this.parseMetadata(systemId, serviceDescriptor);
        }
        this.errorReceiver.error(new LocatorImpl(), WsdlMessages.PARSING_UNABLE_TO_GET_METADATA(systemId));
        return null;
    }

    private Document parseMetadata(String systemId, ServiceDescriptor serviceDescriptor) {
        Node n;
        List mexWsdls = serviceDescriptor.getWSDLs();
        List mexSchemas = serviceDescriptor.getSchemas();
        Document root = null;
        for (Source src : mexWsdls) {
            Element imp;
            String loc;
            NodeList nl;
            Document doc;
            if (!(src instanceof DOMSource)) continue;
            n = ((DOMSource)src).getNode();
            if (n.getNodeType() == 1 && n.getOwnerDocument() == null) {
                doc = DOMUtil.createDom();
                doc.importNode(n, true);
            } else {
                doc = n.getOwnerDocument();
            }
            if (root == null && (nl = doc.getDocumentElement().getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "service")).getLength() > 0) {
                root = doc;
                this.rootWSDL = src.getSystemId();
            }
            if ((nl = doc.getDocumentElement().getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "import")).getLength() > 0 && (loc = (imp = (Element)nl.item(0)).getAttribute("location")) != null && !this.externalReferences.contains(loc)) {
                this.externalReferences.add(loc);
            }
            if (this.core.keySet().contains(systemId)) {
                this.core.remove(systemId);
            }
            this.core.put(src.getSystemId(), doc);
            this.isMexMetadata = true;
        }
        for (Source src : mexSchemas) {
            if (!(src instanceof DOMSource)) continue;
            n = ((DOMSource)src).getNode();
            Element e = n.getNodeType() == 1 ? (Element)n : DOMUtil.getFirstElementChild((Node)n);
            this.inlinedSchemaElements.add(e);
        }
        return root;
    }
}

