/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.server.sei;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.server.Invoker;
import com.sun.xml.ws.model.AbstractSEIModelImpl;
import com.sun.xml.ws.server.InvokerTube;
import com.sun.xml.ws.server.sei.DispatchException;
import com.sun.xml.ws.server.sei.EndpointMethodDispatcher;
import com.sun.xml.ws.server.sei.EndpointMethodDispatcherGetter;
import com.sun.xml.ws.server.sei.EndpointMethodHandler;
import java.util.List;

public class SEIInvokerTube
extends InvokerTube {
    private final SOAPVersion soapVersion;
    private final WSBinding binding;
    private final AbstractSEIModelImpl model;
    private final EndpointMethodDispatcherGetter methodDispatcherGetter;

    public SEIInvokerTube(AbstractSEIModelImpl model, Invoker invoker, WSBinding binding) {
        super(invoker);
        this.soapVersion = binding.getSOAPVersion();
        this.binding = binding;
        this.model = model;
        this.methodDispatcherGetter = new EndpointMethodDispatcherGetter(model, binding, this);
    }

    @NotNull
    public NextAction processRequest(@NotNull Packet req) {
        List<EndpointMethodDispatcher> dispatcherList = this.methodDispatcherGetter.getDispatcherList();
        Packet res = null;
        try {
            for (EndpointMethodDispatcher dispatcher : dispatcherList) {
                EndpointMethodHandler handler = dispatcher.getEndpointMethodHandler(req);
                if (handler == null) continue;
                res = handler.invoke(req);
                break;
            }
        }
        catch (DispatchException e) {
            return this.doReturnWith(req.createServerResponse(e.fault, this.model.getPort(), this.binding));
        }
        assert (res != null);
        return this.doReturnWith(res);
    }

    @NotNull
    public NextAction processResponse(@NotNull Packet response) {
        throw new IllegalStateException("InovkerPipe's processResponse shouldn't be called.");
    }

    @NotNull
    public NextAction processException(@NotNull Throwable t) {
        throw new IllegalStateException("InovkerPipe's processException shouldn't be called.");
    }
}

