/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.server.sei;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.fault.SOAPFaultBuilder;
import com.sun.xml.ws.message.ProblemActionHeader;
import com.sun.xml.ws.model.AbstractSEIModelImpl;
import com.sun.xml.ws.model.JavaMethodImpl;
import com.sun.xml.ws.server.sei.DispatchException;
import com.sun.xml.ws.server.sei.EndpointMethodDispatcher;
import com.sun.xml.ws.server.sei.EndpointMethodHandler;
import com.sun.xml.ws.server.sei.SEIInvokerTube;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.SOAPConstants;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.ws.WebServiceException;

final class ActionBasedDispatcher
implements EndpointMethodDispatcher {
    private final WSBinding binding;
    private final Map<String, EndpointMethodHandler> actionMethodHandlers;
    @NotNull
    private final AddressingVersion av;

    public ActionBasedDispatcher(AbstractSEIModelImpl model, WSBinding binding, SEIInvokerTube invokerTube) {
        this.binding = binding;
        assert (binding.getAddressingVersion() != null);
        this.av = binding.getAddressingVersion();
        this.actionMethodHandlers = new HashMap<String, EndpointMethodHandler>();
        for (JavaMethodImpl m : model.getJavaMethods()) {
            EndpointMethodHandler handler = new EndpointMethodHandler(invokerTube, model, m, binding);
            String action = m.getOperation().getOperation().getInput().getAction();
            if (action == null) continue;
            this.actionMethodHandlers.put(action, handler);
        }
    }

    public EndpointMethodHandler getEndpointMethodHandler(Packet request) throws DispatchException {
        Message result;
        HeaderList hl = request.getMessage().getHeaders();
        String action = hl.getAction(this.av, this.binding.getSOAPVersion());
        if (action == null) {
            return null;
        }
        EndpointMethodHandler h = this.actionMethodHandlers.get(action);
        if (h != null) {
            return h;
        }
        QName subcode = this.av.actionNotSupportedTag;
        String faultstring = String.format(this.av.actionNotSupportedText, action);
        try {
            SOAPFault fault;
            if (this.binding.getSOAPVersion() == SOAPVersion.SOAP_12) {
                fault = SOAPVersion.SOAP_12.saajSoapFactory.createFault();
                fault.setFaultCode(SOAPConstants.SOAP_SENDER_FAULT);
                fault.appendFaultSubcode(subcode);
                Detail detail = fault.addDetail();
                SOAPElement se = detail.addChildElement(this.av.problemActionTag);
                se = se.addChildElement(this.av.actionTag);
                se.addTextNode(action);
            } else {
                fault = SOAPVersion.SOAP_11.saajSoapFactory.createFault();
                fault.setFaultCode(subcode);
            }
            fault.setFaultString(faultstring);
            Message faultMessage = SOAPFaultBuilder.createSOAPFaultMessage(this.binding.getSOAPVersion(), fault);
            if (this.binding.getSOAPVersion() == SOAPVersion.SOAP_11) {
                faultMessage.getHeaders().add(new ProblemActionHeader(action, this.av));
            }
            result = faultMessage;
        }
        catch (SOAPException e) {
            throw new WebServiceException((Throwable)e);
        }
        throw new DispatchException(result);
    }
}

