/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.server.provider;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.fault.SOAPFaultBuilder;
import com.sun.xml.ws.server.provider.ProviderArgumentsBuilder;
import com.sun.xml.ws.server.provider.ProviderEndpointModel;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class SOAPProviderArgumentBuilder<T>
extends ProviderArgumentsBuilder<T> {
    protected final SOAPVersion soapVersion;

    private SOAPProviderArgumentBuilder(SOAPVersion soapVersion) {
        this.soapVersion = soapVersion;
    }

    @Override
    protected void updateResponse(Packet p, Exception e) {
    }

    static SOAPProviderArgumentBuilder create(ProviderEndpointModel model, SOAPVersion soapVersion) {
        if (model.getServiceMode() == Service.Mode.PAYLOAD) {
            return new PayloadSource(soapVersion);
        }
        return model.isSource() ? new MessageSource(soapVersion) : new SOAPMessageParameter(soapVersion);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SOAPMessageParameter
    extends SOAPProviderArgumentBuilder<SOAPMessage> {
        SOAPMessageParameter(SOAPVersion soapVersion) {
            super(soapVersion);
        }

        @Override
        public SOAPMessage getParameter(Message msg) {
            try {
                return msg.readAsSOAPMessage();
            }
            catch (SOAPException se) {
                throw new WebServiceException((Throwable)se);
            }
        }

        @Override
        public Message getResponse(SOAPMessage soapMsg) {
            return Messages.create(soapMsg);
        }

        @Override
        protected Message getResponseMessage(Exception e) {
            return SOAPFaultBuilder.createSOAPFaultMessage(this.soapVersion, null, e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MessageSource
    extends SOAPProviderArgumentBuilder<Source> {
        MessageSource(SOAPVersion soapVersion) {
            super(soapVersion);
        }

        @Override
        public Source getParameter(Message msg) {
            return msg.readEnvelopeAsSource();
        }

        @Override
        public Message getResponse(Source source) {
            return Messages.create(source, this.soapVersion);
        }

        @Override
        protected Message getResponseMessage(Exception e) {
            return SOAPFaultBuilder.createSOAPFaultMessage(this.soapVersion, null, e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PayloadSource
    extends SOAPProviderArgumentBuilder<Source> {
        PayloadSource(SOAPVersion soapVersion) {
            super(soapVersion);
        }

        @Override
        public Source getParameter(Message msg) {
            return msg.readPayloadAsSource();
        }

        @Override
        public Message getResponse(Source source) {
            return Messages.createUsingPayload(source, this.soapVersion);
        }

        @Override
        public Message getResponseMessage(Exception e) {
            return SOAPFaultBuilder.createSOAPFaultMessage(this.soapVersion, null, e);
        }
    }
}

