/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.server;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.api.server.WSWebServiceContext;
import com.sun.xml.ws.server.EndpointMessageContextImpl;
import com.sun.xml.ws.server.WSEndpointImpl;
import java.security.Principal;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWebServiceContext
implements WSWebServiceContext {
    private final WSEndpoint endpoint;

    public AbstractWebServiceContext(@NotNull WSEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public MessageContext getMessageContext() {
        return new EndpointMessageContextImpl(this.getRequestPacket());
    }

    public Principal getUserPrincipal() {
        Packet packet = this.getRequestPacket();
        return packet.webServiceContextDelegate.getUserPrincipal(packet);
    }

    public boolean isUserInRole(String role) {
        Packet packet = this.getRequestPacket();
        return packet.webServiceContextDelegate.isUserInRole(packet, role);
    }

    public EndpointReference getEndpointReference(Element ... referenceParameters) {
        return this.getEndpointReference(W3CEndpointReference.class, referenceParameters);
    }

    public <T extends EndpointReference> T getEndpointReference(Class<T> clazz, Element ... referenceParameters) {
        Packet packet = this.getRequestPacket();
        String address = packet.webServiceContextDelegate.getEPRAddress(packet, this.endpoint);
        String wsdlAddress = null;
        if (this.endpoint.getServiceDefinition() != null) {
            wsdlAddress = packet.webServiceContextDelegate.getWSDLAddress(packet, this.endpoint);
        }
        return (T)((EndpointReference)clazz.cast(((WSEndpointImpl)this.endpoint).getEndpointReference(clazz, address, wsdlAddress, referenceParameters)));
    }
}

