/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.fault;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.fault.CodeType;
import com.sun.xml.ws.fault.DetailType;
import com.sun.xml.ws.fault.ReasonType;
import com.sun.xml.ws.fault.SOAPFaultBuilder;
import com.sun.xml.ws.fault.SubcodeType;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPFaultException;
import org.w3c.dom.Node;

@XmlRootElement(name="Fault", namespace="http://www.w3.org/2003/05/soap-envelope")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"Code", "Reason", "Node", "Role", "Detail"})
class SOAP12Fault
extends SOAPFaultBuilder {
    @XmlTransient
    private static final String ns = "http://www.w3.org/2003/05/soap-envelope";
    @XmlElement(namespace="http://www.w3.org/2003/05/soap-envelope")
    private CodeType Code;
    @XmlElement(namespace="http://www.w3.org/2003/05/soap-envelope")
    private ReasonType Reason;
    @XmlElement(namespace="http://www.w3.org/2003/05/soap-envelope")
    private String Node;
    @XmlElement(namespace="http://www.w3.org/2003/05/soap-envelope")
    private String Role;
    @XmlElement(namespace="http://www.w3.org/2003/05/soap-envelope")
    private DetailType Detail;

    SOAP12Fault() {
    }

    SOAP12Fault(CodeType code, ReasonType reason, String node, String role, DetailType detail) {
        this.Code = code;
        this.Reason = reason;
        this.Node = node;
        this.Role = role;
        this.Detail = detail;
    }

    SOAP12Fault(SOAPFault fault) {
        this.Code = new CodeType(fault.getFaultCodeAsQName());
        if (this.Code != null) {
            try {
                this.fillFaultSubCodes(fault, this.Code.getSubcode());
            }
            catch (SOAPException e) {
                throw new WebServiceException((Throwable)e);
            }
        }
        this.Reason = new ReasonType(fault.getFaultString());
        this.Role = fault.getFaultRole();
        this.Detail = new DetailType(fault.getDetail());
    }

    SOAP12Fault(QName code, String reason, String actor, Node detailObject) {
        this.Code = new CodeType(code);
        this.Reason = new ReasonType(reason);
        if (detailObject != null) {
            this.Detail = new DetailType(detailObject);
        }
    }

    CodeType getCode() {
        return this.Code;
    }

    ReasonType getReason() {
        return this.Reason;
    }

    String getNode() {
        return this.Node;
    }

    String getRole() {
        return this.Role;
    }

    DetailType getDetail() {
        return this.Detail;
    }

    String getFaultString() {
        return this.Reason.texts().get(0).getText();
    }

    protected Throwable getProtocolException() {
        try {
            SOAPFault fault = SOAPVersion.SOAP_12.saajSoapFactory.createFault(this.Reason.texts().get(0).getText(), this.Code != null ? this.Code.getValue() : null);
            if (this.Detail != null && this.Detail.getDetails() != null && this.Detail.getDetails().size() > 0 && this.Detail.getDetails().get(0) instanceof Node) {
                Node n = fault.getOwnerDocument().importNode((Node)this.Detail.getDetails().get(0), true);
                fault.appendChild(n);
            }
            if (this.Code != null) {
                this.fillFaultSubCodes(fault, this.Code.getSubcode());
            }
            return new SOAPFaultException(fault);
        }
        catch (SOAPException e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    private void fillFaultSubCodes(SOAPFault fault, SubcodeType subcode) throws SOAPException {
        if (subcode != null) {
            fault.appendFaultSubcode(subcode.getValue());
            this.fillFaultSubCodes(fault, subcode.getSubcode());
        }
    }
}

