/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.binding;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.api.BindingID;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.pipe.Codec;
import com.sun.xml.ws.binding.HTTPBindingImpl;
import com.sun.xml.ws.binding.SOAPBindingImpl;
import com.sun.xml.ws.binding.WebServiceFeatureList;
import com.sun.xml.ws.client.HandlerConfiguration;
import com.sun.xml.ws.developer.MemberSubmissionAddressingFeature;
import java.util.Collections;
import java.util.List;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.soap.AddressingFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BindingImpl
implements WSBinding {
    private HandlerConfiguration handlerConfig;
    private final BindingID bindingId;
    protected final WebServiceFeatureList features = new WebServiceFeatureList();

    protected BindingImpl(BindingID bindingId) {
        this.bindingId = bindingId;
        this.setHandlerConfig(this.createHandlerConfig(Collections.<Handler>emptyList()));
    }

    @Override
    @NotNull
    public List<Handler> getHandlerChain() {
        return this.handlerConfig.getHandlerChain();
    }

    public HandlerConfiguration getHandlerConfig() {
        return this.handlerConfig;
    }

    public void setHandlerChain(List<Handler> chain) {
        this.setHandlerConfig(this.createHandlerConfig(chain));
    }

    protected void setHandlerConfig(HandlerConfiguration handlerConfig) {
        this.handlerConfig = handlerConfig;
    }

    protected abstract HandlerConfiguration createHandlerConfig(List<Handler> var1);

    @Override
    @NotNull
    public BindingID getBindingId() {
        return this.bindingId;
    }

    @Override
    public final SOAPVersion getSOAPVersion() {
        return this.bindingId.getSOAPVersion();
    }

    @Override
    public AddressingVersion getAddressingVersion() {
        AddressingVersion addressingVersion = this.features.isEnabled(AddressingFeature.class) ? AddressingVersion.W3C : (this.features.isEnabled(MemberSubmissionAddressingFeature.class) ? AddressingVersion.MEMBER : null);
        return addressingVersion;
    }

    @NotNull
    public final Codec createCodec() {
        return this.bindingId.createEncoder(this);
    }

    public static BindingImpl create(@NotNull BindingID bindingId) {
        if (bindingId.equals(BindingID.XML_HTTP)) {
            return new HTTPBindingImpl();
        }
        return new SOAPBindingImpl(bindingId);
    }

    public static BindingImpl create(@NotNull BindingID bindingId, WebServiceFeature[] features) {
        if (bindingId.equals(BindingID.XML_HTTP)) {
            return new HTTPBindingImpl();
        }
        return new SOAPBindingImpl(bindingId, features);
    }

    public static WSBinding getDefaultBinding() {
        return new SOAPBindingImpl(BindingID.SOAP11_HTTP);
    }

    @Override
    public boolean isMTOMEnabled() {
        return false;
    }

    @Override
    public void setMTOMEnabled(boolean value) {
    }

    public String getBindingID() {
        return this.bindingId.toString();
    }

    @Override
    public WebServiceFeature getFeature(String featureId) {
        if (featureId == null) {
            return null;
        }
        return this.features.get(featureId);
    }

    @Override
    @Nullable
    public <F extends WebServiceFeature> F getFeature(@NotNull Class<F> featureType) {
        return this.features.get(featureType);
    }

    @Override
    public boolean isFeatureEnabled(String featureId) {
        return this.features.isEnabled(featureId);
    }

    @Override
    public boolean isFeatureEnabled(@NotNull Class<? extends WebServiceFeature> feature) {
        return this.features.isEnabled(feature);
    }

    @Override
    @NotNull
    public WebServiceFeatureList getFeatures() {
        return this.features;
    }

    @Override
    public void setFeatures(WebServiceFeature ... newFeatures) {
        if (newFeatures != null) {
            for (WebServiceFeature f : newFeatures) {
                this.features.add(f);
            }
        }
    }

    public void addFeature(@NotNull WebServiceFeature newFeature) {
        this.features.add(newFeature);
    }
}

