/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.addressing;

import com.sun.istack.NotNull;
import com.sun.xml.ws.addressing.WsaTubeHelper;
import com.sun.xml.ws.addressing.model.InvalidMapException;
import com.sun.xml.ws.addressing.model.MapRequiredException;
import com.sun.xml.ws.addressing.v200408.WsaTubeHelperImpl;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.ws.developer.MemberSubmissionAddressingFeature;
import com.sun.xml.ws.message.FaultDetailHeader;
import com.sun.xml.ws.resources.AddressingMessages;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPFault;
import javax.xml.stream.XMLStreamException;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.AddressingFeature;

abstract class WsaTube
extends AbstractFilterTubeImpl {
    @NotNull
    protected final WSDLPort wsdlPort;
    protected final WSBinding binding;
    final WsaTubeHelper helper;
    @NotNull
    protected final AddressingVersion addressingVersion;
    protected final SOAPVersion soapVersion;
    private final boolean addressingRequired;

    public WsaTube(WSDLPort wsdlPort, WSBinding binding, Tube next) {
        super(next);
        this.wsdlPort = wsdlPort;
        this.binding = binding;
        this.addressingVersion = binding.getAddressingVersion();
        this.soapVersion = binding.getSOAPVersion();
        this.helper = this.getTubeHelper();
        this.addressingRequired = AddressingVersion.isRequired(binding);
    }

    public WsaTube(WsaTube that, TubeCloner cloner) {
        super(that, cloner);
        this.wsdlPort = that.wsdlPort;
        this.binding = that.binding;
        this.helper = that.helper;
        this.addressingVersion = that.addressingVersion;
        this.soapVersion = that.soapVersion;
        this.addressingRequired = that.addressingRequired;
    }

    @NotNull
    public NextAction processException(Throwable t) {
        return super.processException(t);
    }

    protected WsaTubeHelper getTubeHelper() {
        if (this.binding.isFeatureEnabled(AddressingFeature.class)) {
            return new com.sun.xml.ws.addressing.WsaTubeHelperImpl(this.wsdlPort, this.binding);
        }
        if (this.binding.isFeatureEnabled(MemberSubmissionAddressingFeature.class)) {
            return new WsaTubeHelperImpl(this.wsdlPort, this.binding);
        }
        throw new WebServiceException(AddressingMessages.ADDRESSING_NOT_ENABLED(this.getClass().getSimpleName()));
    }

    protected final Packet validateInboundHeaders(Packet packet) {
        FaultDetailHeader s11FaultDetailHeader;
        SOAPFault soapFault;
        try {
            this.checkCardinality(packet);
            return packet;
        }
        catch (InvalidMapException e) {
            soapFault = this.helper.newInvalidMapFault(e, this.addressingVersion);
            s11FaultDetailHeader = new FaultDetailHeader(this.addressingVersion, this.addressingVersion.problemHeaderQNameTag.getLocalPart(), e.getMapQName());
        }
        catch (MapRequiredException e) {
            soapFault = this.helper.newMapRequiredFault(e, this.addressingVersion);
            s11FaultDetailHeader = new FaultDetailHeader(this.addressingVersion, this.addressingVersion.problemHeaderQNameTag.getLocalPart(), e.getMapQName());
        }
        if (soapFault != null) {
            if (packet.getMessage().isOneWay(this.wsdlPort)) {
                return packet.createServerResponse(null, this.wsdlPort, this.binding);
            }
            Message m = Messages.create(soapFault);
            if (this.soapVersion == SOAPVersion.SOAP_11) {
                m.getHeaders().add(s11FaultDetailHeader);
            }
            Packet response = packet.createServerResponse(m, this.wsdlPort, this.binding);
            return response;
        }
        return packet;
    }

    final boolean isAddressingEngagedOrRequired(Packet packet, WSBinding binding) {
        if (AddressingVersion.isRequired(binding)) {
            return true;
        }
        if (packet == null) {
            return false;
        }
        if (packet.getMessage() == null) {
            return false;
        }
        if (packet.getMessage().getHeaders() != null) {
            return false;
        }
        String action = packet.getMessage().getHeaders().getAction(this.addressingVersion, this.soapVersion);
        if (action == null) {
            return true;
        }
        return true;
    }

    public void checkCardinality(Packet packet) {
        Message message = packet.getMessage();
        if (message == null) {
            if (this.addressingRequired) {
                throw new WebServiceException(AddressingMessages.NULL_MESSAGE());
            }
            return;
        }
        Iterator<Header> hIter = message.getHeaders().getHeaders(this.addressingVersion.nsUri, true);
        if (!hIter.hasNext()) {
            if (this.addressingRequired) {
                throw new InvalidMapException(this.addressingVersion.actionTag, this.addressingVersion.invalidCardinalityTag);
            }
            return;
        }
        boolean foundFrom = false;
        boolean foundTo = false;
        boolean foundReplyTo = false;
        boolean foundFaultTo = false;
        boolean foundAction = false;
        boolean foundMessageId = false;
        boolean foundRelatesTo = false;
        QName duplicateHeader = null;
        while (hIter.hasNext()) {
            Header h = hIter.next();
            if (!this.isInCurrentRole(h, this.binding)) continue;
            String local = h.getLocalPart();
            if (local.equals(this.addressingVersion.fromTag.getLocalPart())) {
                if (foundFrom) {
                    duplicateHeader = this.addressingVersion.fromTag;
                    break;
                }
                foundFrom = true;
                continue;
            }
            if (local.equals(this.addressingVersion.toTag.getLocalPart())) {
                if (foundTo) {
                    duplicateHeader = this.addressingVersion.toTag;
                    break;
                }
                foundTo = true;
                continue;
            }
            if (local.equals(this.addressingVersion.replyToTag.getLocalPart())) {
                if (foundReplyTo) {
                    duplicateHeader = this.addressingVersion.replyToTag;
                    break;
                }
                foundReplyTo = true;
                try {
                    h.readAsEPR(this.addressingVersion);
                    continue;
                }
                catch (XMLStreamException e) {
                    throw new WebServiceException(AddressingMessages.REPLY_TO_CANNOT_PARSE(), (Throwable)e);
                }
            }
            if (local.equals(this.addressingVersion.faultToTag.getLocalPart())) {
                if (foundFaultTo) {
                    duplicateHeader = this.addressingVersion.faultToTag;
                    break;
                }
                foundFaultTo = true;
                try {
                    h.readAsEPR(this.addressingVersion);
                    continue;
                }
                catch (XMLStreamException e) {
                    throw new WebServiceException(AddressingMessages.FAULT_TO_CANNOT_PARSE(), (Throwable)e);
                }
            }
            if (local.equals(this.addressingVersion.actionTag.getLocalPart())) {
                if (foundAction) {
                    duplicateHeader = this.addressingVersion.actionTag;
                    break;
                }
                foundAction = true;
                continue;
            }
            if (local.equals(this.addressingVersion.messageIDTag.getLocalPart())) {
                if (foundMessageId) {
                    duplicateHeader = this.addressingVersion.messageIDTag;
                    break;
                }
                foundMessageId = true;
                continue;
            }
            if (local.equals(this.addressingVersion.relatesToTag.getLocalPart())) {
                foundRelatesTo = true;
                continue;
            }
            if (local.equals(this.addressingVersion.faultDetailTag.getLocalPart())) continue;
            System.err.println(AddressingMessages.UNKNOWN_WSA_HEADER());
        }
        if (duplicateHeader != null) {
            throw new InvalidMapException(duplicateHeader, this.addressingVersion.invalidCardinalityTag);
        }
        boolean engaged = foundAction;
        if (engaged || this.addressingRequired) {
            this.checkMandatoryHeaders(packet, foundAction, foundTo, foundRelatesTo, foundMessageId);
        }
    }

    final boolean isInCurrentRole(Header header, WSBinding binding) {
        if (binding == null) {
            return true;
        }
        if (this.soapVersion == SOAPVersion.SOAP_11) {
            return true;
        }
        String role = header.getRole(this.soapVersion);
        return role.equals(SOAPVersion.SOAP_12.implicitRole);
    }

    protected final WSDLBoundOperation getWSDLBoundOperation(Packet packet) {
        return packet.getMessage().getOperation(this.wsdlPort);
    }

    protected abstract void validateAction(Packet var1);

    protected abstract void checkMandatoryHeaders(Packet var1, boolean var2, boolean var3, boolean var4, boolean var5);
}

