/*
 * Copyright (c) 1997, 2022 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Distribution License v. 1.0, which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

package com.sun.xml.ws.util.xml;

import java.util.Iterator;

import org.w3c.dom.NodeList;

/**
 * @author WS Development Team
 */
public class NodeListIterator implements Iterator {

    protected NodeList _list;
    protected int _index;

    public NodeListIterator(NodeList list) {
        _list = list;
        _index = 0;
    }

    @Override
    public boolean hasNext() {
        if (_list == null)
            return false;
        return _index < _list.getLength();
    }

    @Override
    public Object next() {
        Object obj = _list.item(_index);
        if (obj != null)
            ++_index;
        return obj;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}
