/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.encoding;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSFeatureList;
import com.sun.xml.ws.api.client.SelectOptimalEncodingFeature;
import com.sun.xml.ws.api.fastinfoset.FastInfosetFeature;
import com.sun.xml.ws.api.message.ExceptionHasMessage;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Codec;
import com.sun.xml.ws.api.pipe.Codecs;
import com.sun.xml.ws.api.pipe.ContentType;
import com.sun.xml.ws.api.pipe.StreamSOAPCodec;
import com.sun.xml.ws.binding.WebServiceFeatureList;
import com.sun.xml.ws.client.ContentNegotiation;
import com.sun.xml.ws.encoding.MimeCodec;
import com.sun.xml.ws.encoding.MimeMultipartParser;
import com.sun.xml.ws.encoding.MtomCodec;
import com.sun.xml.ws.encoding.SwACodec;
import com.sun.xml.ws.protocol.soap.MessageCreationException;
import com.sun.xml.ws.resources.StreamingMessages;
import com.sun.xml.ws.server.UnsupportedMediaException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.StringTokenizer;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.MTOMFeature;

public class SOAPBindingCodec
extends MimeCodec
implements com.sun.xml.ws.api.pipe.SOAPBindingCodec {
    public static final String UTF8_ENCODING = "utf-8";
    public static final String DEFAULT_ENCODING = "utf-8";
    private boolean acceptMtomMessages;
    private boolean isRequestMtomMessage;
    private TriState decodeFirst = TriState.UNSET;
    private boolean isFastInfosetDisabled;
    private boolean useFastInfosetForEncoding;
    private boolean ignoreContentNegotiationProperty;
    private final StreamSOAPCodec xmlSoapCodec;
    private final Codec fiSoapCodec;
    private final MimeCodec xmlMtomCodec;
    private final MimeCodec xmlSwaCodec;
    private final MimeCodec fiSwaCodec;
    private final String xmlMimeType;
    private final String fiMimeType;
    private final String xmlAccept;
    private final String connegXmlAccept;
    private AcceptContentType _adaptingContentType = new AcceptContentType();

    @Override
    public StreamSOAPCodec getXMLCodec() {
        return this.xmlSoapCodec;
    }

    public SOAPBindingCodec(WSFeatureList features) {
        this(features, Codecs.createSOAPEnvelopeXmlCodec(WebServiceFeatureList.getSoapVersion(features)));
    }

    public SOAPBindingCodec(WSFeatureList features, StreamSOAPCodec xmlSoapCodec) {
        super(WebServiceFeatureList.getSoapVersion(features), features);
        this.xmlSoapCodec = xmlSoapCodec;
        this.xmlMimeType = xmlSoapCodec.getMimeType();
        this.xmlMtomCodec = new MtomCodec(this.version, xmlSoapCodec, features);
        this.xmlSwaCodec = new SwACodec(this.version, features, xmlSoapCodec);
        String clientAcceptedContentTypes = xmlSoapCodec.getMimeType() + ", " + this.xmlMtomCodec.getMimeType();
        FastInfosetFeature fi = features.get(FastInfosetFeature.class);
        boolean bl = this.isFastInfosetDisabled = fi != null && !fi.isEnabled();
        if (!this.isFastInfosetDisabled) {
            this.fiSoapCodec = SOAPBindingCodec.getFICodec(xmlSoapCodec, this.version);
            if (this.fiSoapCodec != null) {
                this.fiMimeType = this.fiSoapCodec.getMimeType();
                this.fiSwaCodec = new SwACodec(this.version, features, this.fiSoapCodec);
                this.connegXmlAccept = this.fiMimeType + ", " + clientAcceptedContentTypes;
                SelectOptimalEncodingFeature select = features.get(SelectOptimalEncodingFeature.class);
                if (select != null) {
                    this.ignoreContentNegotiationProperty = true;
                    if (select.isEnabled()) {
                        if (fi != null) {
                            this.useFastInfosetForEncoding = true;
                        }
                        clientAcceptedContentTypes = this.connegXmlAccept;
                    } else {
                        this.isFastInfosetDisabled = true;
                    }
                }
            } else {
                this.isFastInfosetDisabled = true;
                this.fiSwaCodec = null;
                this.fiMimeType = "";
                this.connegXmlAccept = clientAcceptedContentTypes;
                this.ignoreContentNegotiationProperty = true;
            }
        } else {
            this.fiSwaCodec = null;
            this.fiSoapCodec = null;
            this.fiMimeType = "";
            this.connegXmlAccept = clientAcceptedContentTypes;
            this.ignoreContentNegotiationProperty = true;
        }
        this.xmlAccept = clientAcceptedContentTypes;
        if (WebServiceFeatureList.getSoapVersion(features) == null) {
            throw new WebServiceException("Expecting a SOAP binding but found ");
        }
    }

    @Override
    public String getMimeType() {
        return null;
    }

    @Override
    public ContentType getStaticContentType(Packet packet) {
        ContentType toAdapt = this.getEncoder(packet).getStaticContentType(packet);
        return toAdapt != null ? this._adaptingContentType.set(packet, toAdapt) : null;
    }

    @Override
    public ContentType encode(Packet packet, OutputStream out) throws IOException {
        this.preEncode(packet);
        AcceptContentType ct = this._adaptingContentType.set(packet, this.getEncoder(packet).encode(packet, out));
        this.postEncode();
        return ct;
    }

    @Override
    public ContentType encode(Packet packet, WritableByteChannel buffer) {
        this.preEncode(packet);
        AcceptContentType ct = this._adaptingContentType.set(packet, this.getEncoder(packet).encode(packet, buffer));
        this.postEncode();
        return ct;
    }

    private void preEncode(Packet p) {
        if (this.decodeFirst == TriState.UNSET) {
            this.decodeFirst = TriState.FALSE;
        }
    }

    private void postEncode() {
        this.decodeFirst = TriState.UNSET;
        this.acceptMtomMessages = false;
        this.isRequestMtomMessage = false;
    }

    private void preDecode(Packet p) {
        if (p.contentNegotiation == null) {
            this.useFastInfosetForEncoding = false;
        }
    }

    private void postDecode(Packet p) {
        if (this.decodeFirst == TriState.UNSET) {
            this.decodeFirst = TriState.TRUE;
        }
        if (this.features.isEnabled(MTOMFeature.class)) {
            this.acceptMtomMessages = this.isMtomAcceptable(p.acceptableMimeTypes);
        }
        if (!this.useFastInfosetForEncoding) {
            this.useFastInfosetForEncoding = this.isFastInfosetAcceptable(p.acceptableMimeTypes);
        }
    }

    private boolean isServerSide() {
        return this.decodeFirst == TriState.TRUE;
    }

    @Override
    public void decode(InputStream in, String contentType, Packet packet) throws IOException {
        if (contentType == null) {
            contentType = this.xmlMimeType;
        }
        this.preDecode(packet);
        try {
            if (this.isMultipartRelated(contentType)) {
                super.decode(in, contentType, packet);
            } else if (this.isFastInfoset(contentType)) {
                if (!this.ignoreContentNegotiationProperty && packet.contentNegotiation == ContentNegotiation.none) {
                    throw this.noFastInfosetForDecoding();
                }
                this.useFastInfosetForEncoding = true;
                this.fiSoapCodec.decode(in, contentType, packet);
            } else {
                this.xmlSoapCodec.decode(in, contentType, packet);
            }
        }
        catch (RuntimeException we) {
            if (we instanceof ExceptionHasMessage || we instanceof UnsupportedMediaException) {
                throw we;
            }
            throw new MessageCreationException(this.version, we);
        }
        this.postDecode(packet);
    }

    @Override
    public void decode(ReadableByteChannel in, String contentType, Packet packet) {
        if (contentType == null) {
            throw new UnsupportedMediaException();
        }
        this.preDecode(packet);
        try {
            if (this.isMultipartRelated(contentType)) {
                super.decode(in, contentType, packet);
            } else if (this.isFastInfoset(contentType)) {
                if (packet.contentNegotiation == ContentNegotiation.none) {
                    throw this.noFastInfosetForDecoding();
                }
                this.useFastInfosetForEncoding = true;
                this.fiSoapCodec.decode(in, contentType, packet);
            } else {
                this.xmlSoapCodec.decode(in, contentType, packet);
            }
        }
        catch (RuntimeException we) {
            if (we instanceof ExceptionHasMessage || we instanceof UnsupportedMediaException) {
                throw we;
            }
            throw new MessageCreationException(this.version, we);
        }
        this.postDecode(packet);
    }

    @Override
    public SOAPBindingCodec copy() {
        return new SOAPBindingCodec(this.features, (StreamSOAPCodec)this.xmlSoapCodec.copy());
    }

    @Override
    protected void decode(MimeMultipartParser mpp, Packet packet) throws IOException {
        String rootContentType = mpp.getRootPart().getContentType();
        if (this.isApplicationXopXml(rootContentType)) {
            this.isRequestMtomMessage = true;
            this.xmlMtomCodec.decode(mpp, packet);
        } else if (this.isFastInfoset(rootContentType)) {
            if (packet.contentNegotiation == ContentNegotiation.none) {
                throw this.noFastInfosetForDecoding();
            }
            this.useFastInfosetForEncoding = true;
            this.fiSwaCodec.decode(mpp, packet);
        } else if (this.isXml(rootContentType)) {
            this.xmlSwaCodec.decode(mpp, packet);
        } else {
            throw new IOException("");
        }
    }

    private boolean isMultipartRelated(String contentType) {
        return this.compareStrings(contentType, "multipart/related");
    }

    private boolean isApplicationXopXml(String contentType) {
        return this.compareStrings(contentType, "application/xop+xml");
    }

    private boolean isXml(String contentType) {
        return this.compareStrings(contentType, this.xmlMimeType);
    }

    private boolean isFastInfoset(String contentType) {
        if (this.isFastInfosetDisabled) {
            return false;
        }
        return this.compareStrings(contentType, this.fiMimeType);
    }

    private boolean compareStrings(String a, String b) {
        return a.length() >= b.length() && b.equalsIgnoreCase(a.substring(0, b.length()));
    }

    private boolean isFastInfosetAcceptable(String accept) {
        if (accept == null || this.isFastInfosetDisabled) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(accept, ",");
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (!token.equalsIgnoreCase(this.fiMimeType)) continue;
            return true;
        }
        return false;
    }

    private boolean isMtomAcceptable(String accept) {
        if (accept == null || this.isFastInfosetDisabled) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(accept, ",");
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (!token.toLowerCase().contains("application/xop+xml")) continue;
            return true;
        }
        return false;
    }

    private Codec getEncoder(Packet p) {
        if (!this.ignoreContentNegotiationProperty) {
            if (p.contentNegotiation == ContentNegotiation.none) {
                this.useFastInfosetForEncoding = false;
            } else if (p.contentNegotiation == ContentNegotiation.optimistic) {
                this.useFastInfosetForEncoding = true;
            }
        }
        if (this.useFastInfosetForEncoding) {
            Message m = p.getMessage();
            if (m == null || m.getAttachments().isEmpty() || this.features.isEnabled(MTOMFeature.class)) {
                return this.fiSoapCodec;
            }
            return this.fiSwaCodec;
        }
        if (this.features.isEnabled(MTOMFeature.class) && (!this.isServerSide() || this.isRequestMtomMessage || this.acceptMtomMessages)) {
            return this.xmlMtomCodec;
        }
        Message m = p.getMessage();
        if (m == null || m.getAttachments().isEmpty()) {
            return this.xmlSoapCodec;
        }
        return this.xmlSwaCodec;
    }

    private RuntimeException noFastInfosetForDecoding() {
        return new RuntimeException(StreamingMessages.FASTINFOSET_DECODING_NOT_ACCEPTED());
    }

    private static Codec getFICodec(StreamSOAPCodec soapCodec, SOAPVersion version) {
        try {
            Class<?> c = Class.forName("com.sun.xml.ws.encoding.fastinfoset.FastInfosetStreamSOAPCodec");
            Method m = c.getMethod("create", StreamSOAPCodec.class, SOAPVersion.class);
            return (Codec)m.invoke(null, new Object[]{soapCodec, version});
        }
        catch (Exception e) {
            return null;
        }
    }

    private class AcceptContentType
    implements ContentType {
        private ContentType _c;
        private String _accept;

        private AcceptContentType() {
        }

        public AcceptContentType set(Packet p, ContentType c) {
            this._accept = !SOAPBindingCodec.this.ignoreContentNegotiationProperty && p.contentNegotiation != ContentNegotiation.none ? SOAPBindingCodec.this.connegXmlAccept : SOAPBindingCodec.this.xmlAccept;
            this._c = c;
            return this;
        }

        @Override
        public String getContentType() {
            return this._c.getContentType();
        }

        @Override
        public String getSOAPActionHeader() {
            return this._c.getSOAPActionHeader();
        }

        @Override
        public String getAcceptHeader() {
            return this._accept;
        }
    }

    private static enum TriState {
        UNSET,
        TRUE,
        FALSE;

    }
}

