/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.binding;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.api.BindingID;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.pipe.Codec;
import com.sun.xml.ws.binding.FeatureListUtil;
import com.sun.xml.ws.binding.HTTPBindingImpl;
import com.sun.xml.ws.binding.SOAPBindingImpl;
import com.sun.xml.ws.binding.WebServiceFeatureList;
import com.sun.xml.ws.client.HandlerConfiguration;
import com.sun.xml.ws.developer.BindingTypeFeature;
import com.sun.xml.ws.developer.MemberSubmissionAddressingFeature;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.soap.AddressingFeature;
import org.jvnet.ws.EnvelopingFeature;

public abstract class BindingImpl
implements WSBinding {
    protected static final WebServiceFeature[] EMPTY_FEATURES = new WebServiceFeature[0];
    protected HandlerConfiguration handlerConfig;
    private final BindingID bindingId;
    protected final WebServiceFeatureList features = new WebServiceFeatureList();
    protected final Map<QName, WebServiceFeatureList> operationFeatures = new HashMap<QName, WebServiceFeatureList>();
    protected final Map<QName, WebServiceFeatureList> inputMessageFeatures = new HashMap<QName, WebServiceFeatureList>();
    protected final Map<QName, WebServiceFeatureList> outputMessageFeatures = new HashMap<QName, WebServiceFeatureList>();
    protected final Map<MessageKey, WebServiceFeatureList> faultMessageFeatures = new HashMap<MessageKey, WebServiceFeatureList>();
    protected Service.Mode serviceMode = Service.Mode.PAYLOAD;

    protected BindingImpl(BindingID bindingId, WebServiceFeature ... features) {
        this.bindingId = bindingId;
        this.handlerConfig = new HandlerConfiguration(Collections.<String>emptySet(), Collections.<Handler>emptyList());
        this.setFeatures(features);
    }

    @Override
    @NotNull
    public List<Handler> getHandlerChain() {
        return this.handlerConfig.getHandlerChain();
    }

    public HandlerConfiguration getHandlerConfig() {
        return this.handlerConfig;
    }

    public void setMode(@NotNull Service.Mode mode) {
        this.serviceMode = mode;
    }

    @Override
    public Set<QName> getKnownHeaders() {
        return this.handlerConfig.getHandlerKnownHeaders();
    }

    @Override
    @NotNull
    public BindingID getBindingId() {
        return this.bindingId;
    }

    @Override
    public final SOAPVersion getSOAPVersion() {
        return this.bindingId.getSOAPVersion();
    }

    @Override
    public AddressingVersion getAddressingVersion() {
        AddressingVersion addressingVersion = this.features.isEnabled(AddressingFeature.class) ? AddressingVersion.W3C : (this.features.isEnabled(MemberSubmissionAddressingFeature.class) ? AddressingVersion.MEMBER : null);
        return addressingVersion;
    }

    @NotNull
    public final Codec createCodec() {
        return this.bindingId.createEncoder(this);
    }

    public static BindingImpl create(@NotNull BindingID bindingId) {
        if (bindingId.equals(BindingID.XML_HTTP)) {
            return new HTTPBindingImpl();
        }
        return new SOAPBindingImpl(bindingId);
    }

    public static BindingImpl create(@NotNull BindingID bindingId, WebServiceFeature[] features) {
        for (WebServiceFeature feature : features) {
            if (!(feature instanceof BindingTypeFeature)) continue;
            BindingTypeFeature f = (BindingTypeFeature)feature;
            bindingId = BindingID.parse(f.getBindingId());
        }
        if (bindingId.equals(BindingID.XML_HTTP)) {
            return new HTTPBindingImpl(features);
        }
        return new SOAPBindingImpl(bindingId, features);
    }

    public static WSBinding getDefaultBinding() {
        return new SOAPBindingImpl(BindingID.SOAP11_HTTP);
    }

    public String getBindingID() {
        return this.bindingId.toString();
    }

    @Override
    @Nullable
    public <F extends WebServiceFeature> F getFeature(@NotNull Class<F> featureType) {
        return this.features.get(featureType);
    }

    @Override
    @Nullable
    public <F extends WebServiceFeature> F getOperationFeature(@NotNull Class<F> featureType, @NotNull QName operationName) {
        WebServiceFeatureList operationFeatureList = this.operationFeatures.get(operationName);
        return FeatureListUtil.mergeFeature(featureType, operationFeatureList, this.features);
    }

    @Override
    public boolean isFeatureEnabled(@NotNull Class<? extends WebServiceFeature> feature) {
        return this.features.isEnabled(feature);
    }

    @Override
    public boolean isOperationFeatureEnabled(@NotNull Class<? extends WebServiceFeature> featureType, @NotNull QName operationName) {
        WebServiceFeatureList operationFeatureList = this.operationFeatures.get(operationName);
        return FeatureListUtil.isFeatureEnabled(featureType, operationFeatureList, this.features);
    }

    @Override
    @NotNull
    public WebServiceFeatureList getFeatures() {
        if (!this.isFeatureEnabled(EnvelopingFeature.class)) {
            WebServiceFeature[] f = new WebServiceFeature[]{this.getSOAPVersion().toFeature()};
            this.features.mergeFeatures(f, false);
        }
        return this.features;
    }

    @Override
    @NotNull
    public WebServiceFeatureList getOperationFeatures(@NotNull QName operationName) {
        WebServiceFeatureList operationFeatureList = this.operationFeatures.get(operationName);
        return FeatureListUtil.mergeList(operationFeatureList, this.features);
    }

    @Override
    @NotNull
    public WebServiceFeatureList getInputMessageFeatures(@NotNull QName operationName) {
        WebServiceFeatureList operationFeatureList = this.operationFeatures.get(operationName);
        WebServiceFeatureList messageFeatureList = this.inputMessageFeatures.get(operationName);
        return FeatureListUtil.mergeList(operationFeatureList, messageFeatureList, this.features);
    }

    @Override
    @NotNull
    public WebServiceFeatureList getOutputMessageFeatures(@NotNull QName operationName) {
        WebServiceFeatureList operationFeatureList = this.operationFeatures.get(operationName);
        WebServiceFeatureList messageFeatureList = this.outputMessageFeatures.get(operationName);
        return FeatureListUtil.mergeList(operationFeatureList, messageFeatureList, this.features);
    }

    @Override
    @NotNull
    public WebServiceFeatureList getFaultMessageFeatures(@NotNull QName operationName, @NotNull QName messageName) {
        WebServiceFeatureList operationFeatureList = this.operationFeatures.get(operationName);
        WebServiceFeatureList messageFeatureList = this.faultMessageFeatures.get(new MessageKey(operationName, messageName));
        return FeatureListUtil.mergeList(operationFeatureList, messageFeatureList, this.features);
    }

    public void setFeatures(WebServiceFeature ... newFeatures) {
        if (newFeatures != null) {
            for (WebServiceFeature f : newFeatures) {
                this.features.add(f);
            }
        }
    }

    public void setOperationFeatures(@NotNull QName operationName, WebServiceFeature ... newFeatures) {
        if (newFeatures != null) {
            WebServiceFeatureList featureList = this.operationFeatures.get(operationName);
            if (featureList == null) {
                featureList = new WebServiceFeatureList();
            }
            for (WebServiceFeature f : newFeatures) {
                featureList.add(f);
            }
            this.operationFeatures.put(operationName, featureList);
        }
    }

    public void setInputMessageFeatures(@NotNull QName operationName, WebServiceFeature ... newFeatures) {
        if (newFeatures != null) {
            WebServiceFeatureList featureList = this.inputMessageFeatures.get(operationName);
            if (featureList == null) {
                featureList = new WebServiceFeatureList();
            }
            for (WebServiceFeature f : newFeatures) {
                featureList.add(f);
            }
            this.inputMessageFeatures.put(operationName, featureList);
        }
    }

    public void setOutputMessageFeatures(@NotNull QName operationName, WebServiceFeature ... newFeatures) {
        if (newFeatures != null) {
            WebServiceFeatureList featureList = this.outputMessageFeatures.get(operationName);
            if (featureList == null) {
                featureList = new WebServiceFeatureList();
            }
            for (WebServiceFeature f : newFeatures) {
                featureList.add(f);
            }
            this.outputMessageFeatures.put(operationName, featureList);
        }
    }

    public void setFaultMessageFeatures(@NotNull QName operationName, @NotNull QName messageName, WebServiceFeature ... newFeatures) {
        if (newFeatures != null) {
            MessageKey key = new MessageKey(operationName, messageName);
            WebServiceFeatureList featureList = this.faultMessageFeatures.get(key);
            if (featureList == null) {
                featureList = new WebServiceFeatureList();
            }
            for (WebServiceFeature f : newFeatures) {
                featureList.add(f);
            }
            this.faultMessageFeatures.put(key, featureList);
        }
    }

    public void addFeature(@NotNull WebServiceFeature newFeature) {
        this.features.add(newFeature);
    }

    protected static class MessageKey {
        private final QName operationName;
        private final QName messageName;

        public MessageKey(QName operationName, QName messageName) {
            this.operationName = operationName;
            this.messageName = messageName;
        }

        public int hashCode() {
            int hashFirst = this.operationName != null ? this.operationName.hashCode() : 0;
            int hashSecond = this.messageName != null ? this.messageName.hashCode() : 0;
            return (hashFirst + hashSecond) * hashSecond + hashFirst;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MessageKey other = (MessageKey)obj;
            if (!(this.operationName == other.operationName || this.operationName != null && this.operationName.equals(other.operationName))) {
                return false;
            }
            return this.messageName == other.messageName || this.messageName != null && this.messageName.equals(other.messageName);
        }

        public String toString() {
            return "(" + this.operationName + ", " + this.messageName + ")";
        }
    }
}

