/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.encoding;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.stream.buffer.AbstractCreatorProcessor;
import com.sun.xml.stream.buffer.MutableXMLStreamBuffer;
import com.sun.xml.stream.buffer.XMLStreamBuffer;
import com.sun.xml.stream.buffer.XMLStreamBufferMark;
import com.sun.xml.stream.buffer.stax.StreamReaderBufferCreator;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.message.AttachmentSet;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.ContentType;
import com.sun.xml.ws.api.streaming.XMLStreamReaderFactory;
import com.sun.xml.ws.api.streaming.XMLStreamWriterFactory;
import com.sun.xml.ws.developer.SerializationFeature;
import com.sun.xml.ws.encoding.ContentTypeImpl;
import com.sun.xml.ws.encoding.RootOnlyCodec;
import com.sun.xml.ws.encoding.StreamSOAP11Codec;
import com.sun.xml.ws.encoding.StreamSOAP12Codec;
import com.sun.xml.ws.encoding.TagInfoset;
import com.sun.xml.ws.message.AttachmentSetImpl;
import com.sun.xml.ws.message.stream.StreamHeader;
import com.sun.xml.ws.message.stream.StreamMessage;
import com.sun.xml.ws.protocol.soap.VersionMismatchException;
import com.sun.xml.ws.server.UnsupportedMediaException;
import com.sun.xml.ws.streaming.TidyXMLStreamReader;
import com.sun.xml.ws.streaming.XMLStreamReaderUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StreamSOAPCodec
implements com.sun.xml.ws.api.pipe.StreamSOAPCodec,
RootOnlyCodec {
    private static final String SOAP_ENVELOPE = "Envelope";
    private static final String SOAP_HEADER = "Header";
    private static final String SOAP_BODY = "Body";
    private final String SOAP_NAMESPACE_URI;
    private final SOAPVersion soapVersion;
    protected final SerializationFeature serializationFeature;
    protected String decodedMessageCharset;

    StreamSOAPCodec(SOAPVersion soapVersion) {
        this(soapVersion, null);
    }

    StreamSOAPCodec(WSBinding binding) {
        this(binding.getSOAPVersion(), binding.getFeature(SerializationFeature.class));
    }

    private StreamSOAPCodec(SOAPVersion soapVersion, @Nullable SerializationFeature sf) {
        this.soapVersion = soapVersion;
        this.SOAP_NAMESPACE_URI = soapVersion.nsUri;
        this.serializationFeature = sf;
    }

    @Override
    public ContentType getStaticContentType(Packet packet) {
        return this.getContentType(packet);
    }

    @Override
    public ContentType encode(Packet packet, OutputStream out) {
        if (packet.getMessage() != null) {
            String encoding = this.getPacketEncoding(packet);
            this.decodedMessageCharset = null;
            XMLStreamWriter writer = XMLStreamWriterFactory.create(out, encoding);
            try {
                packet.getMessage().writeTo(writer);
                writer.flush();
            }
            catch (XMLStreamException e) {
                throw new WebServiceException((Throwable)e);
            }
            XMLStreamWriterFactory.recycle(writer);
        }
        return this.getContentType(packet);
    }

    protected abstract ContentType getContentType(Packet var1);

    protected abstract String getDefaultContentType();

    @Override
    public ContentType encode(Packet packet, WritableByteChannel buffer) {
        throw new UnsupportedOperationException();
    }

    protected abstract List<String> getExpectedContentTypes();

    @Override
    public void decode(InputStream in, String contentType, Packet packet) throws IOException {
        this.decode(in, contentType, packet, (AttachmentSet)new AttachmentSetImpl());
    }

    private static boolean isContentTypeSupported(String ct, List<String> expected) {
        for (String contentType : expected) {
            if (!ct.contains(contentType)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public final Message decode(@NotNull XMLStreamReader reader) {
        return this.decode(reader, new AttachmentSetImpl());
    }

    @Override
    public final Message decode(XMLStreamReader reader, @NotNull AttachmentSet attachmentSet) {
        if (reader.getEventType() != 1) {
            XMLStreamReaderUtil.nextElementContent(reader);
        }
        XMLStreamReaderUtil.verifyReaderState(reader, 1);
        if (SOAP_ENVELOPE.equals(reader.getLocalName()) && !this.SOAP_NAMESPACE_URI.equals(reader.getNamespaceURI())) {
            throw new VersionMismatchException(this.soapVersion, this.SOAP_NAMESPACE_URI, reader.getNamespaceURI());
        }
        XMLStreamReaderUtil.verifyTag(reader, this.SOAP_NAMESPACE_URI, SOAP_ENVELOPE);
        TagInfoset envelopeTag = new TagInfoset(reader);
        HashMap<String, String> namespaces = new HashMap<String, String>();
        for (int i = 0; i < reader.getNamespaceCount(); ++i) {
            namespaces.put(reader.getNamespacePrefix(i), reader.getNamespaceURI(i));
        }
        XMLStreamReaderUtil.nextElementContent(reader);
        XMLStreamReaderUtil.verifyReaderState(reader, 1);
        HeaderList headers = null;
        TagInfoset headerTag = null;
        if (reader.getLocalName().equals(SOAP_HEADER) && reader.getNamespaceURI().equals(this.SOAP_NAMESPACE_URI)) {
            headerTag = new TagInfoset(reader);
            for (int i = 0; i < reader.getNamespaceCount(); ++i) {
                namespaces.put(reader.getNamespacePrefix(i), reader.getNamespaceURI(i));
            }
            XMLStreamReaderUtil.nextElementContent(reader);
            if (reader.getEventType() == 1) {
                headers = new HeaderList();
                try {
                    this.cacheHeaders(reader, namespaces, headers);
                }
                catch (XMLStreamException e) {
                    throw new WebServiceException((Throwable)e);
                }
            }
            XMLStreamReaderUtil.nextElementContent(reader);
        }
        XMLStreamReaderUtil.verifyTag(reader, this.SOAP_NAMESPACE_URI, SOAP_BODY);
        TagInfoset bodyTag = new TagInfoset(reader);
        XMLStreamReaderUtil.nextElementContent(reader);
        return new StreamMessage(envelopeTag, headerTag, attachmentSet, headers, bodyTag, reader, this.soapVersion);
    }

    @Override
    public void decode(ReadableByteChannel in, String contentType, Packet packet) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final StreamSOAPCodec copy() {
        return this;
    }

    private XMLStreamBuffer cacheHeaders(XMLStreamReader reader, Map<String, String> namespaces, HeaderList headers) throws XMLStreamException {
        MutableXMLStreamBuffer buffer = this.createXMLStreamBuffer();
        StreamReaderBufferCreator creator = new StreamReaderBufferCreator();
        creator.setXMLStreamBuffer(buffer);
        while (reader.getEventType() == 1) {
            Map<String, String> headerBlockNamespaces = namespaces;
            if (reader.getNamespaceCount() > 0) {
                headerBlockNamespaces = new HashMap<String, String>(namespaces);
                for (int i = 0; i < reader.getNamespaceCount(); ++i) {
                    headerBlockNamespaces.put(reader.getNamespacePrefix(i), reader.getNamespaceURI(i));
                }
            }
            XMLStreamBufferMark mark = new XMLStreamBufferMark(headerBlockNamespaces, (AbstractCreatorProcessor)creator);
            headers.add(this.createHeader(reader, (XMLStreamBuffer)mark));
            creator.createElementFragment(reader, false);
            if (reader.getEventType() == 1 || reader.getEventType() == 2) continue;
            XMLStreamReaderUtil.nextElementContent(reader);
        }
        return buffer;
    }

    protected abstract StreamHeader createHeader(XMLStreamReader var1, XMLStreamBuffer var2);

    private MutableXMLStreamBuffer createXMLStreamBuffer() {
        return new MutableXMLStreamBuffer();
    }

    @Override
    public void decode(InputStream in, String contentType, Packet packet, AttachmentSet att) throws IOException {
        List<String> expectedContentTypes = this.getExpectedContentTypes();
        if (contentType != null && !StreamSOAPCodec.isContentTypeSupported(contentType, expectedContentTypes)) {
            throw new UnsupportedMediaException(contentType, expectedContentTypes);
        }
        String charset = new ContentTypeImpl(contentType).getCharSet();
        if (charset != null && !Charset.isSupported(charset)) {
            throw new UnsupportedMediaException(charset);
        }
        this.decodedMessageCharset = charset;
        XMLStreamReader reader = XMLStreamReaderFactory.create(null, in, charset, true);
        reader = new TidyXMLStreamReader(reader, in);
        packet.setMessage(this.decode(reader, att));
    }

    @Override
    public void decode(ReadableByteChannel in, String contentType, Packet response, AttachmentSet att) {
        throw new UnsupportedOperationException();
    }

    public static StreamSOAPCodec create(SOAPVersion version) {
        if (version == null) {
            throw new IllegalArgumentException();
        }
        switch (version) {
            case SOAP_11: {
                return new StreamSOAP11Codec();
            }
            case SOAP_12: {
                return new StreamSOAP12Codec();
            }
        }
        throw new AssertionError();
    }

    public static StreamSOAPCodec create(WSBinding binding) {
        SOAPVersion version = binding.getSOAPVersion();
        if (version == null) {
            throw new IllegalArgumentException();
        }
        switch (version) {
            case SOAP_11: {
                return new StreamSOAP11Codec(binding);
            }
            case SOAP_12: {
                return new StreamSOAP12Codec(binding);
            }
        }
        throw new AssertionError();
    }

    private String getPacketEncoding(Packet packet) {
        if (this.serializationFeature != null) {
            return this.serializationFeature.getEncoding().equals("") ? "utf-8" : this.serializationFeature.getEncoding();
        }
        if (packet.endpoint != null) {
            return this.decodedMessageCharset == null ? "utf-8" : this.decodedMessageCharset;
        }
        return "utf-8";
    }

    protected String getContenTypeStr(Packet packet) {
        String encoding = this.getPacketEncoding(packet);
        if (encoding.equalsIgnoreCase("utf-8")) {
            return this.getDefaultContentType();
        }
        return this.getMimeType() + " ;charset=" + encoding;
    }
}

