/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.binding;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.BindingID;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.binding.BindingImpl;
import com.sun.xml.ws.client.HandlerConfiguration;
import com.sun.xml.ws.resources.ClientMessages;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPFactory;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.soap.MTOMFeature;
import javax.xml.ws.soap.SOAPBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SOAPBindingImpl
extends BindingImpl
implements SOAPBinding {
    public static final String X_SOAP12HTTP_BINDING = "http://java.sun.com/xml/ns/jaxws/2003/05/soap/bindings/HTTP/";
    private static final String ROLE_NONE = "http://www.w3.org/2003/05/soap-envelope/role/none";
    protected final SOAPVersion soapVersion;
    private Set<QName> portKnownHeaders = Collections.emptySet();
    private Set<QName> bindingUnderstoodHeaders = new HashSet<QName>();

    SOAPBindingImpl(BindingID bindingId) {
        this(bindingId, EMPTY_FEATURES);
    }

    SOAPBindingImpl(BindingID bindingId, WebServiceFeature ... features) {
        super(bindingId, features);
        this.soapVersion = bindingId.getSOAPVersion();
        this.setRoles(new HashSet<String>());
        this.features.addAll(bindingId.createBuiltinFeatureList());
        this.populateBindingUnderstoodHeaders();
    }

    public void setPortKnownHeaders(@NotNull Set<QName> headers) {
        this.portKnownHeaders = headers;
    }

    public boolean understandsHeader(QName header) {
        return this.serviceMode == Service.Mode.MESSAGE || this.portKnownHeaders.contains(header) || this.bindingUnderstoodHeaders.contains(header);
    }

    private void populateBindingUnderstoodHeaders() {
        AddressingVersion addressingVersion = this.getAddressingVersion();
        if (addressingVersion != null) {
            this.bindingUnderstoodHeaders.add(addressingVersion.actionTag);
            this.bindingUnderstoodHeaders.add(addressingVersion.faultToTag);
            this.bindingUnderstoodHeaders.add(addressingVersion.fromTag);
            this.bindingUnderstoodHeaders.add(addressingVersion.messageIDTag);
            this.bindingUnderstoodHeaders.add(addressingVersion.relatesToTag);
            this.bindingUnderstoodHeaders.add(addressingVersion.replyToTag);
            this.bindingUnderstoodHeaders.add(addressingVersion.toTag);
        }
    }

    public void setHandlerChain(List<Handler> chain) {
        this.handlerConfig = new HandlerConfiguration(this.handlerConfig.getRoles(), chain);
    }

    protected void addRequiredRoles(Set<String> roles) {
        roles.addAll(this.soapVersion.requiredRoles);
    }

    public Set<String> getRoles() {
        return this.handlerConfig.getRoles();
    }

    public void setRoles(Set<String> roles) {
        if (roles == null) {
            roles = new HashSet<String>();
        }
        if (roles.contains(ROLE_NONE)) {
            throw new WebServiceException(ClientMessages.INVALID_SOAP_ROLE_NONE());
        }
        this.addRequiredRoles(roles);
        this.handlerConfig = new HandlerConfiguration(roles, this.getHandlerConfig());
    }

    public boolean isMTOMEnabled() {
        return this.isFeatureEnabled(MTOMFeature.class);
    }

    public void setMTOMEnabled(boolean b) {
        this.setFeatures(new WebServiceFeature[]{new MTOMFeature(b)});
    }

    public SOAPFactory getSOAPFactory() {
        return this.soapVersion.saajSoapFactory;
    }

    public MessageFactory getMessageFactory() {
        return this.soapVersion.saajMessageFactory;
    }
}

