/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb;

import java.awt.Image;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.bind.JAXBException;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.SessionLoaderException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.jaxb.JAXBSchemaOutputResolver;
import org.eclipse.persistence.internal.jaxb.JaxbClassLoader;
import org.eclipse.persistence.internal.jaxb.SessionEventListener;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.schema.SchemaModelGenerator;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jaxb.JAXBBinder;
import org.eclipse.persistence.jaxb.JAXBContextFactory;
import org.eclipse.persistence.jaxb.JAXBIntrospector;
import org.eclipse.persistence.jaxb.JAXBMarshaller;
import org.eclipse.persistence.jaxb.JAXBUnmarshaller;
import org.eclipse.persistence.jaxb.JAXBValidator;
import org.eclipse.persistence.jaxb.TypeMappingInfo;
import org.eclipse.persistence.jaxb.compiler.Generator;
import org.eclipse.persistence.jaxb.compiler.MarshalCallback;
import org.eclipse.persistence.jaxb.compiler.UnmarshalCallback;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaModel;
import org.eclipse.persistence.jaxb.javamodel.reflection.AnnotationHelper;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaModelImpl;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaModelInputImpl;
import org.eclipse.persistence.jaxb.xmlmodel.JavaType;
import org.eclipse.persistence.jaxb.xmlmodel.XmlBindings;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLLogin;
import org.eclipse.persistence.oxm.platform.SAXPlatform;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBContext
extends javax.xml.bind.JAXBContext {
    private static final Map<String, Boolean> PARSER_FEATURES = new HashMap<String, Boolean>(2);
    private JAXBContextInput contextInput;
    private volatile JAXBContextState contextState;

    protected JAXBContext() {
        this.contextState = new JAXBContextState();
    }

    protected JAXBContext(JAXBContextInput contextInput) throws JAXBException {
        this.contextInput = contextInput;
        this.contextState = contextInput.createContextState();
    }

    public JAXBContext(XMLContext context) {
        this.contextState = new JAXBContextState(context);
    }

    public JAXBContext(XMLContext context, Generator generator, Type[] boundTypes) {
        this.contextState = new JAXBContextState(context, generator, boundTypes);
    }

    public JAXBContext(XMLContext context, Generator generator, TypeMappingInfo[] boundTypes) {
        this.contextState = new JAXBContextState(context, generator, boundTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshMetadata() throws JAXBException {
        if (null == this.contextInput) {
            return;
        }
        JAXBContext jAXBContext = this;
        synchronized (jAXBContext) {
            JAXBContextState newState = this.contextInput.createContextState();
            XMLContext xmlContext = this.getXMLContext();
            xmlContext.setXMLContextState(newState.getXMLContext().getXMLContextState());
            newState.setXMLContext(xmlContext);
            this.contextState = newState;
        }
    }

    public XMLContext getXMLContext() {
        return this.contextState.getXMLContext();
    }

    public void setXMLContext(XMLContext xmlContext) {
        this.contextState.setXMLContext(xmlContext);
    }

    public void generateSchema(SchemaOutputResolver outputResolver) {
        this.generateSchema(outputResolver, null);
    }

    public void generateSchema(SchemaOutputResolver outputResolver, Map<QName, Type> additonalGlobalElements) {
        JAXBContextState currentJAXBContextState = this.contextState;
        XMLContext xmlContext = currentJAXBContextState.getXMLContext();
        Generator generator = currentJAXBContextState.getGenerator();
        if (generator == null) {
            ArrayList<XMLDescriptor> descriptorsToProcess = new ArrayList<XMLDescriptor>();
            List sessions = xmlContext.getSessions();
            for (Session session : sessions) {
                List<ClassDescriptor> descriptors = session.getProject().getOrderedDescriptors();
                for (XMLDescriptor xMLDescriptor : descriptors) {
                    descriptorsToProcess.add(xMLDescriptor);
                }
            }
            SchemaModelGenerator smGen = new SchemaModelGenerator();
            smGen.generateSchemas(descriptorsToProcess, null, new JAXBSchemaOutputResolver(outputResolver), additonalGlobalElements);
        } else {
            generator.generateSchemaFiles(outputResolver, additonalGlobalElements);
        }
    }

    public JAXBMarshaller createMarshaller() {
        JAXBContextState currentJAXBContextState = this.contextState;
        XMLContext xmlContext = currentJAXBContextState.getXMLContext();
        Generator generator = currentJAXBContextState.getGenerator();
        JAXBMarshaller marshaller = new JAXBMarshaller(xmlContext.createMarshaller(), new JAXBIntrospector(xmlContext));
        if (generator != null && generator.hasMarshalCallbacks()) {
            Iterator callIt = generator.getMarshalCallbacks().keySet().iterator();
            while (callIt.hasNext()) {
                MarshalCallback cb = (MarshalCallback)generator.getMarshalCallbacks().get(callIt.next());
                cb.initialize(generator.getClass().getClassLoader());
            }
            marshaller.setMarshalCallbacks(generator.getMarshalCallbacks());
        }
        marshaller.setJaxbContext(this);
        return marshaller;
    }

    public JAXBUnmarshaller createUnmarshaller() {
        JAXBContextState currentJAXBContextState = this.contextState;
        XMLContext xmlContext = currentJAXBContextState.getXMLContext();
        Generator generator = currentJAXBContextState.getGenerator();
        JAXBUnmarshaller unmarshaller = new JAXBUnmarshaller(xmlContext.createUnmarshaller(PARSER_FEATURES));
        if (generator != null && generator.hasUnmarshalCallbacks()) {
            Iterator callIt = generator.getUnmarshalCallbacks().keySet().iterator();
            while (callIt.hasNext()) {
                UnmarshalCallback cb = (UnmarshalCallback)generator.getUnmarshalCallbacks().get(callIt.next());
                cb.initialize(generator.getClass().getClassLoader());
            }
            unmarshaller.setUnmarshalCallbacks(generator.getUnmarshalCallbacks());
        }
        unmarshaller.setJaxbContext(this);
        return unmarshaller;
    }

    public JAXBValidator createValidator() {
        return new JAXBValidator(this.getXMLContext().createValidator());
    }

    public JAXBBinder createBinder() {
        return new JAXBBinder(this.getXMLContext());
    }

    public <T> JAXBBinder createBinder(Class<T> nodeClass) {
        if (nodeClass.getName().equals("org.w3c.dom.Node")) {
            return new JAXBBinder(this.getXMLContext());
        }
        throw new UnsupportedOperationException(org.eclipse.persistence.exceptions.JAXBException.unsupportedNodeClass(nodeClass.getName()));
    }

    public JAXBIntrospector createJAXBIntrospector() {
        return new JAXBIntrospector(this.getXMLContext());
    }

    public void setQNameToGeneratedClasses(HashMap<QName, Class> qNameToClass) {
        this.contextState.setQNameToGeneratedClasses(qNameToClass);
    }

    public HashMap<String, Class> getClassToGeneratedClasses() {
        return this.contextState.getClassToGeneratedClasses();
    }

    public void setClassToGeneratedClasses(HashMap<String, Class> classToClass) {
        this.contextState.setClassToGeneratedClasses(classToClass);
    }

    public void applyORMMetadata(AbstractSession ormSession) {
        this.getXMLContext().applyORMMetadata(ormSession);
    }

    public HashMap<QName, Class> getQNamesToDeclaredClasses() {
        return this.contextState.getQNamesToDeclaredClasses();
    }

    Map<QName, Class> getQNameToGeneratedClasses() {
        return this.contextState.getQNameToGeneratedClasses();
    }

    public void setQNamesToDeclaredClasses(HashMap<QName, Class> nameToDeclaredClasses) {
        this.contextState.setQNamesToDeclaredClasses(nameToDeclaredClasses);
    }

    public Map<String, Class> getArrayClassesToGeneratedClasses() {
        return this.contextState.getGenerator().getAnnotationsProcessor().getArrayClassesToGeneratedClasses();
    }

    public Map<Type, Class> getCollectionClassesToGeneratedClasses() {
        return this.contextState.getGenerator().getAnnotationsProcessor().getCollectionClassesToGeneratedClasses();
    }

    public void initTypeToSchemaType() {
        this.contextState.initTypeToSchemaType();
    }

    public Map<TypeMappingInfo, QName> getTypeMappingInfoToSchemaType() {
        return this.contextState.getTypeMappingInfoToSchemaType();
    }

    public HashMap<Type, QName> getTypeToSchemaType() {
        return this.contextState.getTypeToSchemaType();
    }

    Map<TypeMappingInfo, Class> getTypeMappingInfoToGeneratedType() {
        return this.contextState.getTypeMappingInfoToGeneratedType();
    }

    Map<Type, TypeMappingInfo> getTypeToTypeMappingInfo() {
        return this.contextState.getTypeToTypeMappingInfo();
    }

    void setTypeToTypeMappingInfo(Map<Type, TypeMappingInfo> typeToMappingInfo) {
        this.contextState.setTypeToTypeMappingInfo(typeToMappingInfo);
    }

    void setTypeMappingInfoToJavaTypeAdapaters(Map<TypeMappingInfo, RootLevelXmlAdapter> typeMappingInfoToAdapters) {
        this.contextState.setTypeMappingInfoToJavaTypeAdapaters(typeMappingInfoToAdapters);
    }

    Map<TypeMappingInfo, RootLevelXmlAdapter> getTypeMappingInfoToJavaTypeAdapters() {
        return this.contextState.getTypeMappingInfoToJavaTypeAdapters();
    }

    public <T> T getValueByXPath(Object object, String xPath, NamespaceResolver namespaceResolver, Class<T> returnType) {
        return this.getXMLContext().getValueByXPath(object, xPath, namespaceResolver, returnType);
    }

    public void setValueByXPath(Object object, String xPath, NamespaceResolver namespaceResolver, Object value) {
        this.getXMLContext().setValueByXPath(object, xPath, namespaceResolver, value);
    }

    public Object createByQualifiedName(String namespace, String typeName, boolean isGlobalType) {
        return this.getXMLContext().createByQualifiedName(namespace, typeName, isGlobalType);
    }

    public <T> T createByXPath(Object parentObject, String xPath, NamespaceResolver namespaceResolver, Class<T> returnType) {
        return this.getXMLContext().createByXPath(parentObject, xPath, namespaceResolver, returnType);
    }

    public boolean hasSwaRef() {
        return this.contextState.getGenerator().getAnnotationsProcessor().hasSwaRef();
    }

    static {
        PARSER_FEATURES.put("http://apache.org/xml/features/validation/schema/normalized-value", false);
        PARSER_FEATURES.put("http://apache.org/xml/features/validation/schema/element-default", false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JAXBContextState {
        private XMLContext xmlContext;
        private Generator generator;
        private Map<QName, Class> qNameToGeneratedClasses;
        private HashMap<String, Class> classToGeneratedClasses;
        private HashMap<QName, Class> qNamesToDeclaredClasses;
        private HashMap<Type, QName> typeToSchemaType;
        private TypeMappingInfo[] boundTypes;
        private Map<TypeMappingInfo, Class> typeMappingInfoToGeneratedType;
        private Map<Type, TypeMappingInfo> typeToTypeMappingInfo;
        private Map<TypeMappingInfo, RootLevelXmlAdapter> typeMappingInfoToJavaTypeAdapters;

        private JAXBContextState() {
        }

        private JAXBContextState(XMLContext context) {
            this.xmlContext = context;
        }

        private JAXBContextState(XMLContext context, Generator generator, Type[] boundTypes) {
            this(context);
            this.generator = generator;
            this.qNameToGeneratedClasses = generator.getMappingsGenerator().getQNamesToGeneratedClasses();
            this.classToGeneratedClasses = generator.getMappingsGenerator().getClassToGeneratedClasses();
            this.qNamesToDeclaredClasses = generator.getMappingsGenerator().getQNamesToDeclaredClasses();
            this.boundTypes = new TypeMappingInfo[boundTypes.length];
            for (int i = 0; i < boundTypes.length; ++i) {
                TypeMappingInfo newTypeInfo = new TypeMappingInfo();
                newTypeInfo.setType(boundTypes[i]);
                this.boundTypes[i] = newTypeInfo;
            }
        }

        private JAXBContextState(XMLContext context, Generator generator, TypeMappingInfo[] boundTypes) {
            this(context);
            this.generator = generator;
            this.qNameToGeneratedClasses = generator.getMappingsGenerator().getQNamesToGeneratedClasses();
            this.classToGeneratedClasses = generator.getMappingsGenerator().getClassToGeneratedClasses();
            this.qNamesToDeclaredClasses = generator.getMappingsGenerator().getQNamesToDeclaredClasses();
            this.typeMappingInfoToGeneratedType = generator.getAnnotationsProcessor().getTypeMappingInfoToGeneratedClasses();
            this.setTypeMappingInfoToJavaTypeAdapaters(this.createAdaptersForAdapterClasses(generator.getAnnotationsProcessor().getTypeMappingInfoToAdapterClasses()));
            this.boundTypes = boundTypes;
        }

        private Map<TypeMappingInfo, RootLevelXmlAdapter> createAdaptersForAdapterClasses(Map<TypeMappingInfo, Class> typeMappingInfoToAdapterClasses) {
            HashMap<TypeMappingInfo, RootLevelXmlAdapter> typeMappingInfoToAdapters = new HashMap<TypeMappingInfo, RootLevelXmlAdapter>();
            for (Map.Entry<TypeMappingInfo, Class> entry : typeMappingInfoToAdapterClasses.entrySet()) {
                Class adapterClass = entry.getValue();
                if (adapterClass == null) continue;
                try {
                    XmlAdapter adapter = (XmlAdapter)adapterClass.newInstance();
                    Class boundType = this.getBoundTypeForXmlAdapterClass(adapterClass);
                    RootLevelXmlAdapter rootLevelXmlAdapter = new RootLevelXmlAdapter(adapter, boundType);
                    typeMappingInfoToAdapters.put(entry.getKey(), rootLevelXmlAdapter);
                }
                catch (Exception ex) {}
            }
            return typeMappingInfoToAdapters;
        }

        private Class getBoundTypeForXmlAdapterClass(Class adapterClass) {
            Class boundType = Object.class;
            for (Method method : PrivilegedAccessHelper.getDeclaredMethods(adapterClass)) {
                Class returnType;
                if (!method.getName().equals("marshal") || (returnType = PrivilegedAccessHelper.getMethodReturnType(method)).getName().equals(boundType.getName())) continue;
                boundType = returnType;
                break;
            }
            return boundType;
        }

        private HashMap<String, Class> getClassToGeneratedClasses() {
            return this.classToGeneratedClasses;
        }

        private Generator getGenerator() {
            return this.generator;
        }

        private XMLContext getXMLContext() {
            return this.xmlContext;
        }

        private HashMap<Type, QName> getTypeToSchemaType() {
            if (this.typeToSchemaType == null) {
                this.initTypeToSchemaType();
            }
            return this.typeToSchemaType;
        }

        private Map<TypeMappingInfo, Class> getTypeMappingInfoToGeneratedType() {
            return this.typeMappingInfoToGeneratedType;
        }

        private Map<TypeMappingInfo, RootLevelXmlAdapter> getTypeMappingInfoToJavaTypeAdapters() {
            return this.typeMappingInfoToJavaTypeAdapters;
        }

        private Map<Type, TypeMappingInfo> getTypeToTypeMappingInfo() {
            return this.typeToTypeMappingInfo;
        }

        private Map<TypeMappingInfo, QName> getTypeMappingInfoToSchemaType() {
            if (this.typeToTypeMappingInfo != null && this.typeToTypeMappingInfo.size() > 0) {
                return new HashMap<TypeMappingInfo, QName>();
            }
            return this.generator.getAnnotationsProcessor().getTypeMappingInfoToSchemaType();
        }

        private HashMap<QName, Class> getQNamesToDeclaredClasses() {
            return this.qNamesToDeclaredClasses;
        }

        private QName getSchemaTypeForTypeMappingInfo(Type type) {
            QName name = null;
            if (type instanceof Class && (name = this.generator.getAnnotationsProcessor().getUserDefinedSchemaTypes().get(((Class)type).getName())) == null) {
                Class theClass = (Class)type;
                name = type == ClassConstants.ABYTE || type == ClassConstants.APBYTE || type == Image.class || type == Source.class || theClass.getCanonicalName().equals("javax.activation.DataHandler") ? XMLConstants.BASE_64_BINARY_QNAME : (type == ClassConstants.OBJECT ? XMLConstants.ANY_TYPE_QNAME : (type == ClassConstants.XML_GREGORIAN_CALENDAR ? XMLConstants.ANY_SIMPLE_TYPE_QNAME : (QName)XMLConversionManager.getDefaultJavaTypes().get(type)));
            }
            return name;
        }

        private Map<QName, Class> getQNameToGeneratedClasses() {
            return this.qNameToGeneratedClasses;
        }

        private void initTypeToSchemaType() {
            this.typeToSchemaType = new HashMap();
            if (this.typeToTypeMappingInfo == null || this.typeToTypeMappingInfo.size() == 0) {
                return;
            }
            for (XMLDescriptor xMLDescriptor : this.xmlContext.getSession(0).getProject().getOrderedDescriptors()) {
                Class javaClass = xMLDescriptor.getJavaClass();
                if (xMLDescriptor.getSchemaReference() == null) continue;
                QName schemaType = xMLDescriptor.getSchemaReference().getSchemaContextAsQName(xMLDescriptor.getNamespaceResolver());
                Type type = null;
                if (this.generator != null) {
                    type = this.generator.getAnnotationsProcessor().getGeneratedClassesToCollectionClasses().get(javaClass);
                    if (type == null) {
                        JavaClass arrayClass = this.generator.getAnnotationsProcessor().getGeneratedClassesToArrayClasses().get(javaClass);
                        if (arrayClass != null) {
                            String arrayClassName = arrayClass.getName();
                            try {
                                type = PrivilegedAccessHelper.getClassForName(arrayClassName);
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                        }
                        if (type == null && this.getTypeMappingInfoToGeneratedType() != null) {
                            for (Map.Entry<TypeMappingInfo, Class> entry : this.getTypeMappingInfoToGeneratedType().entrySet()) {
                                if (!entry.getValue().equals(javaClass)) continue;
                                type = entry.getKey().getType();
                                break;
                            }
                        }
                    }
                    if (type == null) {
                        type = javaClass;
                    }
                } else {
                    type = javaClass;
                }
                this.typeToSchemaType.put(type, schemaType);
            }
            if (this.boundTypes != null) {
                for (TypeMappingInfo next : this.boundTypes) {
                    Type nextType;
                    QName name;
                    if (this.typeToSchemaType.get(next) != null || (name = this.getSchemaTypeForTypeMappingInfo(nextType = next.getType())) == null) continue;
                    this.typeToSchemaType.put(nextType, name);
                }
            }
        }

        private void setClassToGeneratedClasses(HashMap<String, Class> classToClass) {
            this.classToGeneratedClasses = classToClass;
        }

        private void setTypeToTypeMappingInfo(Map<Type, TypeMappingInfo> typeToMappingInfo) {
            this.typeToTypeMappingInfo = typeToMappingInfo;
            this.generator.setTypeToTypeMappingInfo(typeToMappingInfo);
        }

        private void setTypeMappingInfoToJavaTypeAdapaters(Map<TypeMappingInfo, RootLevelXmlAdapter> typeMappingInfoToAdapters) {
            this.typeMappingInfoToJavaTypeAdapters = typeMappingInfoToAdapters;
        }

        private void setQNamesToDeclaredClasses(HashMap<QName, Class> nameToDeclaredClasses) {
            this.qNamesToDeclaredClasses = nameToDeclaredClasses;
        }

        private void setQNameToGeneratedClasses(Map<QName, Class> qNameToClass) {
            this.qNameToGeneratedClasses = qNameToClass;
        }

        private void setXMLContext(XMLContext xmlContext) {
            this.xmlContext = xmlContext;
        }
    }

    static class TypeMappingInfoInput
    extends JAXBContextInput {
        private TypeMappingInfo[] typeMappingInfo;

        TypeMappingInfoInput(TypeMappingInfo[] typeMappingInfo, Map properties, ClassLoader classLoader) {
            super(properties, classLoader);
            this.typeMappingInfo = typeMappingInfo;
        }

        protected JAXBContextState createContextState() throws JAXBException {
            Map<String, XmlBindings> xmlBindings = JAXBContextFactory.getXmlBindingsFromProperties(this.properties, this.classLoader);
            String defaultTargetNamespace = null;
            AnnotationHelper annotationHelper = null;
            if (this.properties != null) {
                defaultTargetNamespace = (String)this.properties.get("defaultTargetNamespace");
                annotationHelper = (AnnotationHelper)this.properties.get("annotationHelper");
            }
            TypeMappingInfo[] typesToBeBound = this.typeMappingInfo;
            for (Map.Entry<String, XmlBindings> entry : xmlBindings.entrySet()) {
                typesToBeBound = TypeMappingInfoInput.getXmlBindingsClasses(entry.getValue(), this.classLoader, typesToBeBound);
            }
            JaxbClassLoader loader = new JaxbClassLoader(this.classLoader, typesToBeBound);
            JavaModelImpl jModel = annotationHelper != null ? new JavaModelImpl(loader, annotationHelper) : new JavaModelImpl(loader);
            HashMap<String, Boolean> metadataComplete = new HashMap<String, Boolean>();
            for (String packageName : xmlBindings.keySet()) {
                if (!xmlBindings.get(packageName).isXmlMappingMetadataComplete()) continue;
                metadataComplete.put(packageName, true);
            }
            if (metadataComplete.size() > 0) {
                jModel.setMetadataCompletePackageMap(metadataComplete);
            }
            JavaModelInputImpl inputImpl = new JavaModelInputImpl(typesToBeBound, (JavaModel)jModel);
            try {
                Generator generator = new Generator(inputImpl, typesToBeBound, inputImpl.getJavaClasses(), null, xmlBindings, this.classLoader, defaultTargetNamespace);
                return this.createContextState(generator, loader, typesToBeBound);
            }
            catch (Exception ex) {
                throw new JAXBException(ex.getMessage(), (Throwable)ex);
            }
        }

        private JAXBContextState createContextState(Generator generator, JaxbClassLoader loader, TypeMappingInfo[] typesToBeBound) throws Exception {
            Project proj = generator.generateProject();
            ConversionManager conversionManager = null;
            if (this.classLoader != null) {
                conversionManager = new ConversionManager();
                conversionManager.setLoader(loader);
            } else {
                conversionManager = ConversionManager.getDefaultManager();
            }
            proj.convertClassNamesToClasses(conversionManager.getLoader());
            for (ClassDescriptor descriptor : proj.getOrderedDescriptors()) {
                if (descriptor.getJavaClass() != null) continue;
                descriptor.setJavaClass(conversionManager.convertClassNameToClass(descriptor.getJavaClassName()));
            }
            SessionEventListener eventListener = new SessionEventListener();
            eventListener.setShouldValidateInstantiationPolicy(false);
            SAXPlatform platform = new SAXPlatform();
            platform.getConversionManager().setLoader(loader);
            XMLContext xmlContext = new XMLContext(proj, (ClassLoader)loader, eventListener);
            if (generator.getAnnotationsProcessor().getPackageToPackageInfoMappings().size() > 1) {
                ((XMLLogin)xmlContext.getSession(0).getDatasourceLogin()).setEqualNamespaceResolvers(false);
            }
            return new JAXBContextState(xmlContext, generator, typesToBeBound);
        }

        private static TypeMappingInfo[] getXmlBindingsClasses(XmlBindings xmlBindings, ClassLoader classLoader, TypeMappingInfo[] existingTypes) {
            XmlBindings.JavaTypes jTypes = xmlBindings.getJavaTypes();
            if (jTypes != null) {
                ArrayList existingClasses = new ArrayList(existingTypes.length);
                for (TypeMappingInfo typeMappingInfo : existingTypes) {
                    Type type = typeMappingInfo.getType();
                    if (type == null) {
                        throw org.eclipse.persistence.exceptions.JAXBException.nullTypeOnTypeMappingInfo(typeMappingInfo.getXmlTagName());
                    }
                    if (!(type instanceof Class)) continue;
                    Class cls = (Class)type;
                    existingClasses.add(cls);
                }
                ArrayList<TypeMappingInfo> additionalTypeMappingInfos = new ArrayList<TypeMappingInfo>(jTypes.getJavaType().size());
                for (JavaType javaType : jTypes.getJavaType()) {
                    try {
                        Class<?> nextClass = classLoader.loadClass(javaType.getName());
                        if (existingClasses.contains(nextClass)) continue;
                        TypeMappingInfo typeMappingInfo = new TypeMappingInfo();
                        typeMappingInfo.setType(nextClass);
                        additionalTypeMappingInfos.add(typeMappingInfo);
                        existingClasses.add(nextClass);
                    }
                    catch (ClassNotFoundException e) {
                        throw org.eclipse.persistence.exceptions.JAXBException.couldNotLoadClassFromMetadata(javaType.getName());
                    }
                }
                TypeMappingInfo[] allTypeMappingInfos = new TypeMappingInfo[existingTypes.length + additionalTypeMappingInfos.size()];
                System.arraycopy(existingTypes, 0, allTypeMappingInfos, 0, existingTypes.length);
                Object[] additionalTypes = additionalTypeMappingInfos.toArray();
                System.arraycopy(additionalTypes, 0, allTypeMappingInfos, existingTypes.length, additionalTypes.length);
                return allTypeMappingInfos;
            }
            return existingTypes;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ContextPathInput
    extends JAXBContextInput {
        private String contextPath;

        ContextPathInput(String contextPath, Map properties, ClassLoader classLoader) {
            super(properties, classLoader);
            this.contextPath = contextPath;
        }

        @Override
        protected JAXBContextState createContextState() throws JAXBException {
            EclipseLinkException sessionLoadingException = null;
            try {
                XMLContext xmlContext = new XMLContext(this.contextPath, this.classLoader);
                return new JAXBContextState(xmlContext);
            }
            catch (ValidationException vex) {
                if (vex.getErrorCode() != 7095) {
                    sessionLoadingException = vex;
                }
            }
            catch (SessionLoaderException ex) {
                sessionLoadingException = ex;
            }
            catch (Exception ex) {
                throw new JAXBException((Throwable)ex);
            }
            List<Class> classes = new ArrayList<Class>();
            Map<String, XmlBindings> xmlBindingMap = JAXBContextFactory.getXmlBindingsFromProperties(this.properties, this.classLoader);
            classes = this.getXmlBindingsClassesFromMap(xmlBindingMap, this.classLoader, classes);
            StringTokenizer tokenizer = new StringTokenizer(this.contextPath, ":");
            while (tokenizer.hasMoreElements()) {
                InputStream jaxbIndex;
                String path = tokenizer.nextToken();
                try {
                    Class<?> objectFactory = this.classLoader.loadClass(path + ".ObjectFactory");
                    if (this.isJAXB2ObjectFactory(objectFactory, this.classLoader)) {
                        classes.add(objectFactory);
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    this.classLoader.loadClass(path + ".package-info");
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if ((jaxbIndex = this.classLoader.getResourceAsStream(path.replace('.', '/') + "/jaxb.index")) == null) continue;
                BufferedReader reader = new BufferedReader(new InputStreamReader(jaxbIndex));
                try {
                    String line = reader.readLine();
                    while (line != null) {
                        String className = path + "." + line.trim();
                        try {
                            classes.add(this.classLoader.loadClass(className));
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        line = reader.readLine();
                    }
                }
                catch (Exception ex) {
                }
            }
            if (classes.size() == 0) {
                org.eclipse.persistence.exceptions.JAXBException jaxbException = org.eclipse.persistence.exceptions.JAXBException.noObjectFactoryOrJaxbIndexInPath(this.contextPath);
                if (sessionLoadingException != null) {
                    jaxbException.setInternalException(sessionLoadingException);
                }
                throw new JAXBException((Throwable)jaxbException);
            }
            Class[] classArray = new Class[classes.size()];
            for (int i = 0; i < classes.size(); ++i) {
                classArray[i] = classes.get(i);
            }
            return this.createContextState(classArray, xmlBindingMap);
        }

        private JAXBContextState createContextState(Class[] classesToBeBound, Map<String, XmlBindings> xmlBindings) throws JAXBException {
            JaxbClassLoader loader = new JaxbClassLoader(this.classLoader, classesToBeBound);
            String defaultTargetNamespace = null;
            AnnotationHelper annotationHelper = null;
            if (this.properties != null) {
                defaultTargetNamespace = (String)this.properties.get("defaultTargetNamespace");
                annotationHelper = (AnnotationHelper)this.properties.get("annotationHelper");
            }
            JavaModelImpl jModel = annotationHelper != null ? new JavaModelImpl(loader, annotationHelper) : new JavaModelImpl(loader);
            HashMap<String, Boolean> metadataComplete = new HashMap<String, Boolean>();
            for (String packageName : xmlBindings.keySet()) {
                if (!xmlBindings.get(packageName).isXmlMappingMetadataComplete()) continue;
                metadataComplete.put(packageName, true);
            }
            if (metadataComplete.size() > 0) {
                jModel.setMetadataCompletePackageMap(metadataComplete);
            }
            JavaModelInputImpl inputImpl = new JavaModelInputImpl(classesToBeBound, (JavaModel)jModel);
            try {
                Generator generator = new Generator(inputImpl, xmlBindings, loader, defaultTargetNamespace);
                return this.createContextState(generator, loader, classesToBeBound);
            }
            catch (Exception ex) {
                throw new JAXBException(ex.getMessage(), (Throwable)ex);
            }
        }

        private JAXBContextState createContextState(Generator generator, JaxbClassLoader loader, Type[] typesToBeBound) throws Exception {
            Project proj = generator.generateProject();
            ConversionManager conversionManager = null;
            if (this.classLoader != null) {
                conversionManager = new ConversionManager();
                conversionManager.setLoader(loader);
            } else {
                conversionManager = ConversionManager.getDefaultManager();
            }
            proj.convertClassNamesToClasses(conversionManager.getLoader());
            for (ClassDescriptor descriptor : proj.getOrderedDescriptors()) {
                if (descriptor.getJavaClass() != null) continue;
                descriptor.setJavaClass(conversionManager.convertClassNameToClass(descriptor.getJavaClassName()));
            }
            SessionEventListener eventListener = new SessionEventListener();
            eventListener.setShouldValidateInstantiationPolicy(false);
            SAXPlatform platform = new SAXPlatform();
            platform.getConversionManager().setLoader(loader);
            XMLContext xmlContext = new XMLContext(proj, (ClassLoader)loader, eventListener);
            if (generator.getAnnotationsProcessor().getPackageToPackageInfoMappings().size() > 1) {
                ((XMLLogin)xmlContext.getSession(0).getDatasourceLogin()).setEqualNamespaceResolvers(false);
            }
            return new JAXBContextState(xmlContext, generator, typesToBeBound);
        }

        private List<Class> getXmlBindingsClassesFromMap(Map<String, XmlBindings> xmlBindingMap, ClassLoader classLoader, List<Class> existingClasses) {
            List<Class> additionalClasses = existingClasses;
            for (Map.Entry<String, XmlBindings> entry : xmlBindingMap.entrySet()) {
                additionalClasses = this.getXmlBindingsClasses(entry.getValue(), classLoader, additionalClasses);
            }
            return additionalClasses;
        }

        private List<Class> getXmlBindingsClasses(XmlBindings xmlBindings, ClassLoader classLoader, List<Class> existingClasses) {
            List<Class> additionalClasses = existingClasses;
            XmlBindings.JavaTypes jTypes = xmlBindings.getJavaTypes();
            if (jTypes != null) {
                for (JavaType javaType : jTypes.getJavaType()) {
                    try {
                        Class<?> jClass = classLoader.loadClass(javaType.getName());
                        if (additionalClasses.contains(jClass)) continue;
                        additionalClasses.add(jClass);
                    }
                    catch (ClassNotFoundException e) {
                        throw org.eclipse.persistence.exceptions.JAXBException.couldNotLoadClassFromMetadata(javaType.getName());
                    }
                }
            }
            return additionalClasses;
        }

        private boolean isJAXB2ObjectFactory(Class objectFactoryClass, ClassLoader classLoader) {
            try {
                Class xmlRegistry = PrivilegedAccessHelper.getClassForName("javax.xml.bind.annotation.XmlRegistry", false, classLoader);
                return objectFactoryClass.isAnnotationPresent(xmlRegistry);
            }
            catch (Exception ex) {
                return false;
            }
        }
    }

    static abstract class JAXBContextInput {
        protected Map properties;
        protected ClassLoader classLoader;

        public JAXBContextInput(Map properties, ClassLoader classLoader) {
            this.properties = properties;
            this.classLoader = null == classLoader ? Thread.currentThread().getContextClassLoader() : classLoader;
        }

        protected abstract JAXBContextState createContextState() throws JAXBException;
    }

    static class RootLevelXmlAdapter {
        private XmlAdapter xmlAdapter;
        private Class boundType;

        public RootLevelXmlAdapter(XmlAdapter adapter, Class boundType) {
            this.xmlAdapter = adapter;
            this.boundType = boundType;
        }

        public XmlAdapter getXmlAdapter() {
            return this.xmlAdapter;
        }

        public Class getBoundType() {
            return this.boundType;
        }

        public void setXmlAdapter(XmlAdapter xmlAdapter) {
            this.xmlAdapter = xmlAdapter;
        }

        public void setBoundType(Class boundType) {
            this.boundType = boundType;
        }
    }
}

