/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.wscompile;

import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.writer.ProgressCodeWriter;
import com.sun.istack.tools.ParallelWorldClassLoader;
import com.sun.tools.ws.api.TJavaGeneratorExtension;
import com.sun.tools.ws.processor.generator.CustomExceptionGenerator;
import com.sun.tools.ws.processor.generator.GeneratorBase;
import com.sun.tools.ws.processor.generator.JwsImplGenerator;
import com.sun.tools.ws.processor.generator.SeiGenerator;
import com.sun.tools.ws.processor.generator.ServiceGenerator;
import com.sun.tools.ws.processor.model.Model;
import com.sun.tools.ws.processor.modeler.wsdl.ConsoleErrorReporter;
import com.sun.tools.ws.processor.modeler.wsdl.WSDLModeler;
import com.sun.tools.ws.processor.util.DirectoryUtil;
import com.sun.tools.ws.resources.WscompileMessages;
import com.sun.tools.ws.resources.WsdlMessages;
import com.sun.tools.ws.util.WSDLFetcher;
import com.sun.tools.ws.wscompile.AbortException;
import com.sun.tools.ws.wscompile.BadCommandLineException;
import com.sun.tools.ws.wscompile.DefaultAuthenticator;
import com.sun.tools.ws.wscompile.ErrorReceiver;
import com.sun.tools.ws.wscompile.ErrorReceiverFilter;
import com.sun.tools.ws.wscompile.FilerCodeWriter;
import com.sun.tools.ws.wscompile.JavaCompilerHelper;
import com.sun.tools.ws.wscompile.Options;
import com.sun.tools.ws.wscompile.Plugin;
import com.sun.tools.ws.wscompile.WSCodeWriter;
import com.sun.tools.ws.wscompile.WsimportListener;
import com.sun.tools.ws.wscompile.WsimportOptions;
import com.sun.tools.ws.wsdl.parser.MetadataFinder;
import com.sun.tools.ws.wsdl.parser.WSDLInternalizationLogic;
import com.sun.tools.xjc.util.NullStream;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.util.ServiceFinder;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Authenticator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import javax.xml.bind.JAXBPermission;
import javax.xml.stream.XMLStreamException;
import javax.xml.ws.EndpointContext;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class WsimportTool {
    private static final String WSIMPORT = "wsimport";
    private final PrintStream out;
    private final Container container;
    protected WsimportOptions options = new WsimportOptions();

    public WsimportTool(OutputStream out) {
        this(out, null);
    }

    public WsimportTool(OutputStream logStream, Container container) {
        this.out = logStream instanceof PrintStream ? (PrintStream)logStream : new PrintStream(logStream);
        this.container = container;
    }

    public boolean run(String[] args) {
        Listener listener = new Listener();
        Receiver receiver = new Receiver(listener);
        return this.run(args, listener, receiver);
    }

    /*
     * Exception decompiling
     */
    protected boolean run(String[] args, Listener listener, Receiver receiver) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 10[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteGeneratedFiles() {
        HashSet<File> trackedRootPackages = new HashSet<File>();
        if (this.options.clientjar != null) {
            Iterable<File> generatedFiles;
            Iterable<File> iterable = generatedFiles = this.options.getGeneratedFiles();
            synchronized (iterable) {
                for (File file : generatedFiles) {
                    if (file.getName().endsWith(".java")) continue;
                    file.delete();
                    trackedRootPackages.add(file.getParentFile());
                }
            }
            for (File pkg : trackedRootPackages) {
                while (pkg.list() != null && pkg.list().length == 0 && !pkg.equals(this.options.destDir)) {
                    File parentPkg = pkg.getParentFile();
                    pkg.delete();
                    pkg = parentPkg;
                }
            }
        }
        if (!this.options.keep) {
            this.options.removeGeneratedFiles();
        }
    }

    private void addClassesToGeneratedFiles() throws IOException {
        Iterable<File> generatedFiles = this.options.getGeneratedFiles();
        final ArrayList trackedClassFiles = new ArrayList();
        for (File f : generatedFiles) {
            if (!f.getName().endsWith(".java")) continue;
            String relativeDir = DirectoryUtil.getRelativePathfromCommonBase(f.getParentFile(), this.options.sourceDir);
            final String className = f.getName().substring(0, f.getName().indexOf(".java"));
            File classDir = new File(this.options.destDir, relativeDir);
            if (!classDir.exists()) continue;
            classDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    if (name.equals(className + ".class") || name.startsWith(className + "$") && name.endsWith(".class")) {
                        trackedClassFiles.add(new File(dir, name));
                        return true;
                    }
                    return false;
                }
            });
        }
        for (File f : trackedClassFiles) {
            this.options.addGeneratedFile(f);
        }
    }

    private void jarArtifacts(WsimportListener listener) throws IOException {
        File zipFile = new File(this.options.clientjar);
        if (!zipFile.isAbsolute()) {
            zipFile = new File(this.options.destDir, this.options.clientjar);
        }
        if (zipFile.exists()) {
            // empty if block
        }
        FileOutputStream fos = null;
        if (!this.options.quiet) {
            listener.message(WscompileMessages.WSIMPORT_ARCHIVING_ARTIFACTS(zipFile));
        }
        fos = new FileOutputStream(zipFile);
        JarOutputStream jos = new JarOutputStream(fos);
        String base = this.options.destDir.getCanonicalPath();
        for (File f : this.options.getGeneratedFiles()) {
            int bytesRead;
            if (f.getName().endsWith(".java")) continue;
            if (this.options.verbose) {
                listener.message(WscompileMessages.WSIMPORT_ARCHIVE_ARTIFACT(f, this.options.clientjar));
            }
            String entry = f.getCanonicalPath().substring(base.length() + 1);
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(f));
            JarEntry jarEntry = new JarEntry(entry);
            jos.putNextEntry(jarEntry);
            byte[] buffer = new byte[1024];
            while ((bytesRead = bis.read(buffer)) != -1) {
                jos.write(buffer, 0, bytesRead);
            }
            bis.close();
        }
        jos.close();
    }

    protected void parseArguments(String[] args, Listener listener, Receiver receiver) throws BadCommandLineException {
        this.options.parseArguments(args);
        this.options.validate();
        if (this.options.debugMode) {
            listener.enableDebugging();
        }
        this.options.parseBindings(receiver);
    }

    protected Model buildWsdlModel(Listener listener, Receiver receiver) throws BadCommandLineException, XMLStreamException, IOException {
        WSDLModeler wsdlModeler;
        Model wsdlModel;
        if (!this.options.quiet) {
            listener.message(WscompileMessages.WSIMPORT_PARSING_WSDL());
        }
        Authenticator.setDefault(new DefaultAuthenticator(receiver, this.options.authFile));
        MetadataFinder forest = new MetadataFinder(new WSDLInternalizationLogic(), this.options, receiver);
        forest.parseWSDL();
        if (forest.isMexMetadata) {
            receiver.reset();
        }
        if ((wsdlModel = (wsdlModeler = new WSDLModeler(this.options, receiver, forest)).buildModel()) == null) {
            listener.message(WsdlMessages.PARSING_PARSE_FAILED());
        }
        if (this.options.clientjar != null) {
            if (!this.options.quiet) {
                listener.message(WscompileMessages.WSIMPORT_FETCHING_METADATA());
            }
            this.options.wsdlLocation = new WSDLFetcher(this.options, listener).fetchWsdls(forest);
        }
        return wsdlModel;
    }

    protected boolean generateCode(Listener listener, Receiver receiver, Model wsdlModel, boolean generateService) throws IOException {
        if (!this.options.quiet) {
            listener.message(WscompileMessages.WSIMPORT_GENERATING_CODE());
        }
        TJavaGeneratorExtension[] genExtn = ServiceFinder.find(TJavaGeneratorExtension.class).toArray();
        CustomExceptionGenerator.generate(wsdlModel, this.options, receiver);
        SeiGenerator.generate(wsdlModel, this.options, receiver, genExtn);
        if (receiver.hadError()) {
            throw new AbortException();
        }
        if (generateService) {
            ServiceGenerator.generate(wsdlModel, this.options, receiver);
        }
        for (GeneratorBase g : ServiceFinder.find(GeneratorBase.class)) {
            g.init(wsdlModel, this.options, receiver);
            g.doGeneration();
        }
        List<String> implFiles = null;
        if (this.options.isGenerateJWS) {
            implFiles = JwsImplGenerator.generate(wsdlModel, this.options, receiver);
        }
        for (Plugin plugin : this.options.activePlugins) {
            try {
                plugin.run(wsdlModel, this.options, receiver);
            }
            catch (SAXException sex) {
                return false;
            }
        }
        CodeWriter cw = this.options.filer != null ? new FilerCodeWriter(this.options.sourceDir, this.options) : new WSCodeWriter(this.options.sourceDir, this.options);
        if (this.options.verbose) {
            cw = new ProgressCodeWriter(cw, this.out);
        }
        this.options.getCodeModel().build(cw);
        if (this.options.isGenerateJWS) {
            return JwsImplGenerator.moveToImplDestDir(implFiles, this.options, receiver);
        }
        return true;
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.options.entityResolver = resolver;
    }

    private static boolean useBootClasspath(Class clazz) {
        try {
            ParallelWorldClassLoader.toJarUrl(clazz.getResource('/' + clazz.getName().replace('.', '/') + ".class"));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected boolean compileGeneratedClasses(ErrorReceiver receiver, WsimportListener listener) {
        ArrayList<String> sourceFiles = new ArrayList<String>();
        for (File f : this.options.getGeneratedFiles()) {
            if (!f.exists() || !f.getName().endsWith(".java")) continue;
            sourceFiles.add(f.getAbsolutePath());
        }
        if (sourceFiles.size() > 0) {
            String classDir = this.options.destDir.getAbsolutePath();
            String classpathString = this.createClasspathString();
            boolean bootCP = WsimportTool.useBootClasspath(EndpointContext.class) || WsimportTool.useBootClasspath(JAXBPermission.class);
            String[] args = new String[4 + (bootCP ? 1 : 0) + (this.options.debug ? 1 : 0) + (this.options.encoding != null ? 2 : 0) + sourceFiles.size()];
            args[0] = "-d";
            args[1] = classDir;
            args[2] = "-classpath";
            args[3] = classpathString;
            int baseIndex = 4;
            if (bootCP) {
                args[baseIndex++] = "-Xbootclasspath/p:" + JavaCompilerHelper.getJarFile(EndpointContext.class) + File.pathSeparator + JavaCompilerHelper.getJarFile(JAXBPermission.class);
            }
            if (this.options.debug) {
                args[baseIndex++] = "-g";
            }
            if (this.options.encoding != null) {
                args[baseIndex++] = "-encoding";
                args[baseIndex++] = this.options.encoding;
            }
            for (int i = 0; i < sourceFiles.size(); ++i) {
                args[baseIndex + i] = (String)sourceFiles.get(i);
            }
            listener.message(WscompileMessages.WSIMPORT_COMPILING_CODE());
            if (this.options.verbose) {
                StringBuffer argstr = new StringBuffer();
                for (String arg : args) {
                    argstr.append(arg).append(" ");
                }
                listener.message("javac " + argstr.toString());
            }
            return JavaCompilerHelper.compile(args, this.out, receiver);
        }
        return true;
    }

    private String createClasspathString() {
        StringBuilder classpathStr = new StringBuilder(System.getProperty("java.class.path"));
        for (String s : this.options.cmdlineJars) {
            classpathStr.append(File.pathSeparator);
            classpathStr.append(new File(s).toString());
        }
        return classpathStr.toString();
    }

    protected void usage(Options options) {
        System.out.println(WscompileMessages.WSIMPORT_HELP(WSIMPORT));
        System.out.println(WscompileMessages.WSIMPORT_USAGE_EXTENSIONS());
        System.out.println(WscompileMessages.WSIMPORT_USAGE_EXAMPLES());
    }

    protected class Receiver
    extends ErrorReceiverFilter {
        private Listener listener;

        public Receiver(Listener listener) {
            super(listener);
            this.listener = listener;
        }

        @Override
        public void info(SAXParseException exception) {
            if (WsimportTool.this.options.verbose) {
                super.info(exception);
            }
        }

        @Override
        public void warning(SAXParseException exception) {
            if (!WsimportTool.this.options.quiet) {
                super.warning(exception);
            }
        }

        @Override
        public void pollAbort() throws AbortException {
            if (this.listener.isCanceled()) {
                throw new AbortException();
            }
        }

        @Override
        public void debug(SAXParseException exception) {
            if (WsimportTool.this.options.debugMode) {
                this.listener.debug(exception);
            }
        }
    }

    protected class Listener
    extends WsimportListener {
        ConsoleErrorReporter cer;

        protected Listener() {
            this.cer = new ConsoleErrorReporter(WsimportTool.this.out == null ? new PrintStream(new NullStream()) : WsimportTool.this.out);
        }

        @Override
        public void generatedFile(String fileName) {
            this.message(fileName);
        }

        @Override
        public void message(String msg) {
            WsimportTool.this.out.println(msg);
        }

        @Override
        public void error(SAXParseException exception) {
            this.cer.error(exception);
        }

        @Override
        public void fatalError(SAXParseException exception) {
            this.cer.fatalError(exception);
        }

        @Override
        public void warning(SAXParseException exception) {
            this.cer.warning(exception);
        }

        @Override
        public void debug(SAXParseException exception) {
            this.cer.debug(exception);
        }

        @Override
        public void info(SAXParseException exception) {
            this.cer.info(exception);
        }

        public void enableDebugging() {
            this.cer.enableDebugging();
        }
    }
}

