/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.db.toplink;

import java.lang.ref.SoftReference;
import java.util.concurrent.ConcurrentLinkedQueue;

public abstract class ObjectPool<T> {
    private volatile SoftReference<ConcurrentLinkedQueue<T>> queueRef;

    public final T allocate() {
        T value = this.derefQueue().poll();
        return value != null ? value : this.newInstance();
    }

    public final void replace(T value) {
        this.derefQueue().offer(value);
    }

    protected abstract T newInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ConcurrentLinkedQueue<T> derefQueue() {
        ConcurrentLinkedQueue<Object> q;
        if (this.queueRef == null || (q = this.queueRef.get()) == null) {
            ObjectPool objectPool = this;
            synchronized (objectPool) {
                if (this.queueRef == null || (q = this.queueRef.get()) == null) {
                    q = new ConcurrentLinkedQueue();
                    this.queueRef = new SoftReference<ConcurrentLinkedQueue<ConcurrentLinkedQueue<T>>>(q);
                }
            }
        }
        return q;
    }
}

