/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.async_client_transport;

import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.transport.async_client_transport.NonAnonymousAddressAllocator;
import com.sun.xml.ws.transport.async_client_transport.NonAnonymousResponseHandler;
import com.sun.xml.ws.transport.async_client_transport.NonAnonymousResponsesReceiver;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.ws.Endpoint;
import javax.xml.ws.Provider;
import javax.xml.ws.Service;
import javax.xml.ws.ServiceMode;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceProvider;

public class DefaultNonAnonymousResponseReceiver
implements NonAnonymousResponsesReceiver<Message> {
    private Endpoint e;
    private String bindingId;
    private String nonanonAddress;
    private static final Logger LOGGER = Logger.getLogger(DefaultNonAnonymousResponseReceiver.class.getName());

    public DefaultNonAnonymousResponseReceiver(String nonanonAddress, String bindingId) {
        this.bindingId = bindingId;
        this.nonanonAddress = nonanonAddress;
    }

    @Override
    public void register(NonAnonymousResponseHandler<Message> nonAnonymousResponseHandler) {
        this.e = Endpoint.create((String)this.bindingId, (Object)new DefaultNonAnonymousEndpoint(nonAnonymousResponseHandler));
        if (this.nonanonAddress == null) {
            this.nonanonAddress = NonAnonymousAddressAllocator.getInstance().createNonAnonymousAddress();
        }
        LOGGER.log(Level.INFO, "Starting NonAnonymousResponseReceiver on:{0}", this.nonanonAddress);
        try {
            this.e.publish(this.nonanonAddress);
        }
        catch (Exception ex) {
            throw new WebServiceException((Throwable)ex);
        }
    }

    @Override
    public void unregister(NonAnonymousResponseHandler<Message> nonAnonymousResponseHandler) {
        if (this.e != null) {
            this.e.stop();
        }
    }

    @Override
    public String getAddress() {
        return this.nonanonAddress;
    }

    @ServiceMode(value=Service.Mode.MESSAGE)
    @WebServiceProvider(serviceName="RINonAnonService", portName="RINonAnonPort", targetNamespace="http://jax-ws//foo")
    private static class DefaultNonAnonymousEndpoint
    implements Provider<Message> {
        private NonAnonymousResponseHandler<Message> handler;

        private DefaultNonAnonymousEndpoint(NonAnonymousResponseHandler<Message> handler) {
            this.handler = handler;
        }

        public Message invoke(Message m) {
            LOGGER.log(Level.FINE, "Message receieved by{0}", this.getClass());
            if (this.handler != null) {
                this.handler.onReceive(m);
            }
            return null;
        }
    }
}

