/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.async_client_transport;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.BindingID;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.ClientTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.TransportTubeFactory;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.ws.api.pipe.helper.AbstractTubeImpl;
import com.sun.xml.ws.api.streaming.XMLStreamWriterFactory;
import com.sun.xml.ws.binding.BindingImpl;
import com.sun.xml.ws.transport.async_client_transport.AsyncClientTransportFeature;
import com.sun.xml.ws.transport.async_client_transport.DefaultNonAnonymousResponseReceiver;
import com.sun.xml.ws.transport.async_client_transport.FeatureSupressingWSBinding;
import com.sun.xml.ws.transport.async_client_transport.NonAnonymousResponseHandler;
import com.sun.xml.ws.transport.async_client_transport.NonAnonymousResponsesReceiver;
import com.sun.xml.ws.transport.async_client_transport.RequestSender;
import com.sun.xml.ws.util.ByteArrayBuffer;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.ws.WebServiceFeature;

public class AsyncClientTransportTube
extends AbstractFilterTubeImpl {
    WSBinding binding;
    NonAnonymousResponsesReceiver<Message> responseReceiver;
    RINonAnonymousResponseHandler nonAnonHandler;
    RequestSender requestSender;
    AddressingVersion addrVersion;
    WSEndpointReference nonAnonymousEPR;
    Header nonAnonymousHeader;
    public static final boolean dump;
    private static final Logger LOGGER;

    protected AsyncClientTransportTube(ClientTubeAssemblerContext context) {
        super(TransportTubeFactory.create((ClassLoader)Thread.currentThread().getContextClassLoader(), (ClientTubeAssemblerContext)AsyncClientTransportTube.recreateClientContext(context)));
        this.binding = context.getBinding();
        this.addrVersion = this.binding.getAddressingVersion();
        AsyncClientTransportFeature nonanonftr = (AsyncClientTransportFeature)this.binding.getFeature(AsyncClientTransportFeature.class);
        if (this.addrVersion != null && nonanonftr.isEnabled()) {
            this.responseReceiver = nonanonftr.getReceiver() == null ? new DefaultNonAnonymousResponseReceiver(nonanonftr.getNonanonAddress(), this.binding.getBindingID()) : nonanonftr.getReceiver();
        }
        this.nonAnonHandler = new RINonAnonymousResponseHandler();
        this.responseReceiver.register(this.nonAnonHandler);
        this.requestSender = new RequestSender(((Object)((Object)this)).toString(), this.next);
        this.nonAnonymousEPR = new WSEndpointReference(this.responseReceiver.getAddress(), this.binding.getAddressingVersion());
        this.nonAnonymousHeader = this.nonAnonymousEPR.createHeader(this.binding.getAddressingVersion().replyToTag);
    }

    protected AsyncClientTransportTube(AsyncClientTransportTube that, TubeCloner cloner) {
        super((AbstractFilterTubeImpl)that, cloner);
        this.binding = that.binding;
        this.nonAnonHandler = that.nonAnonHandler;
        this.responseReceiver = that.responseReceiver;
        this.requestSender = that.requestSender;
        this.nonAnonymousEPR = that.nonAnonymousEPR;
        this.nonAnonymousHeader = that.nonAnonymousHeader;
    }

    private static ClientTubeAssemblerContext recreateClientContext(ClientTubeAssemblerContext context) {
        return new ClientTubeAssemblerContext(context.getAddress(), context.getWsdlModel(), context.getBindingProvider(), AsyncClientTransportTube.recreateBinding(context.getBinding()), context.getContainer(), context.getCodec(), context.getSEIModel(), context.getSEI());
    }

    private static WSBinding recreateBinding(WSBinding binding) {
        return BindingImpl.create((BindingID)binding.getBindingId(), (WebServiceFeature[])new FeatureSupressingWSBinding(AsyncClientTransportFeature.class, binding).getFeatures().toArray());
    }

    public AbstractTubeImpl copy(TubeCloner cloner) {
        return new AsyncClientTransportTube(this, cloner);
    }

    @NotNull
    public NextAction processRequest(Packet request) {
        if (request.expectReply.booleanValue()) {
            this.setNonAnnonymousReplyTo(request.getMessage(), this.binding.getAddressingVersion(), this.nonAnonymousHeader);
            String msgId = this.getMessageId(request.getMessage());
            this.nonAnonHandler.addNonAnonymousResponseHandler(msgId, new ClientResponseHandler(request));
            LOGGER.log(Level.FINE, "Sending request with message id{0}", msgId);
            this.requestSender.send(request);
            return this.doSuspend();
        }
        return this.doInvoke(this.next, request);
    }

    @NotNull
    public NextAction processResponse(Packet response) {
        return this.doReturnWith(response);
    }

    @NotNull
    public NextAction processException(Throwable t) {
        return this.doThrow(t);
    }

    public void preDestroy() {
        this.responseReceiver.unregister(this.nonAnonHandler);
        this.requestSender.close();
        this.nonAnonHandler.cleanUp();
        this.nonAnonHandler = null;
        this.responseReceiver = null;
        this.requestSender = null;
    }

    String getMessageId(Message m) {
        return m.getHeaders().getMessageID(this.binding.getAddressingVersion(), this.binding.getSOAPVersion());
    }

    String getRelatesTo(Message m) {
        return m.getHeaders().getRelatesTo(this.binding.getAddressingVersion(), this.binding.getSOAPVersion());
    }

    void setNonAnnonymousReplyTo(Message m, AddressingVersion av, Header nonAnonymousHeader) {
        HeaderList headers = m.getHeaders();
        headers.remove(av.replyToTag);
        headers.add(nonAnonymousHeader);
        if (headers.remove(av.faultToTag) != null) {
            headers.add(nonAnonymousHeader);
        }
    }

    static {
        boolean b;
        try {
            b = Boolean.getBoolean(AsyncClientTransportTube.class.getName() + ".dump");
        }
        catch (Throwable t) {
            b = false;
        }
        dump = b;
        LOGGER = Logger.getLogger(AsyncClientTransportTube.class.getName());
    }

    class SyncResponseHandler
    implements Fiber.CompletionCallback {
        private final String msgId;
        private RINonAnonymousResponseHandler nonAnonResponseTracker;

        SyncResponseHandler(String msgId, RINonAnonymousResponseHandler nonAnonResponseTracker) {
            this.msgId = msgId;
            this.nonAnonResponseTracker = nonAnonResponseTracker;
        }

        public void onCompletion(@NotNull Packet response) {
            Message responseMessage = response.getMessage();
            if (responseMessage != null && responseMessage.hasPayload()) {
                NonAnonymousResponseHandler responseHandler;
                String relatesToId = AsyncClientTransportTube.this.getRelatesTo(responseMessage);
                if (!this.msgId.equals(relatesToId)) {
                    LOGGER.log(Level.WARNING, "Received unexpected message for id = {0}with id = {1}", new Object[]{this.msgId, AsyncClientTransportTube.this.getMessageId(responseMessage)});
                }
                if ((responseHandler = this.nonAnonResponseTracker.remove(this.msgId)) != null) {
                    responseHandler.onReceive(responseMessage);
                }
            }
        }

        public void onCompletion(@NotNull Throwable error) {
            LOGGER.log(Level.WARNING, "Received unexpected error for request with id = {0}", this.msgId);
            NonAnonymousResponseHandler responseHandler = this.nonAnonResponseTracker.remove(this.msgId);
            if (responseHandler != null) {
                responseHandler.onError(error);
            }
        }
    }

    class RINonAnonymousResponseHandler
    implements NonAnonymousResponseHandler<Message> {
        Map<String, NonAnonymousResponseHandler> waiting = Collections.synchronizedMap(new HashMap());

        RINonAnonymousResponseHandler() {
        }

        public void addNonAnonymousResponseHandler(String msgId, NonAnonymousResponseHandler handler) {
            this.waiting.put(msgId, handler);
        }

        public NonAnonymousResponseHandler remove(String msgId) {
            return this.waiting.remove(msgId);
        }

        public void cleanUp() {
            this.waiting.clear();
        }

        @Override
        public void onReceive(@NotNull Message response) {
            String msgId = AsyncClientTransportTube.this.getRelatesTo(response);
            LOGGER.log(Level.FINE, "Received message with id{0}", msgId);
            if (msgId != null) {
                NonAnonymousResponseHandler handler = this.waiting.remove(msgId);
                if (handler == null) {
                    LOGGER.log(Level.WARNING, "Received unexpected message with realtesTo id = {0}", msgId);
                } else {
                    handler.onReceive(response);
                }
            } else {
                LOGGER.warning("Received unexpected message - cannot find key");
            }
        }

        @Override
        public void onError(@NotNull Throwable t) {
        }
    }

    public class ClientResponseHandler
    implements NonAnonymousResponseHandler<Message> {
        final Fiber fiber;
        final Packet request;

        public ClientResponseHandler(Packet request) {
            this.request = request;
            this.fiber = Fiber.current();
        }

        @Override
        public void onReceive(@NotNull Message msg) {
            LOGGER.log(Level.INFO, "Client being resumed for processing message with id{0}", AsyncClientTransportTube.this.getRelatesTo(msg));
            try {
                if (dump) {
                    System.out.println("Received message: ");
                    ByteArrayBuffer baos = new ByteArrayBuffer();
                    XMLStreamWriter writer = XMLStreamWriterFactory.create((OutputStream)baos);
                    msg.copy().writeTo(writer);
                    writer.close();
                    baos.writeTo((OutputStream)System.out);
                    System.out.flush();
                }
            }
            catch (Exception e) {
                this.onError(e);
            }
            Packet reply = this.request.createClientResponse(msg);
            this.fiber.resume(reply);
        }

        @Override
        public void onError(@NotNull Throwable t) {
            this.fiber.resume(t);
        }
    }
}

